/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.type;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.util.Nullable;

public abstract class ResolveDeclaredTypeNode
extends ExpressionNode {
    @Node.Child
    private IndirectCallNode callNode = IndirectCallNode.create();

    protected ResolveDeclaredTypeNode(SourceSection sourceSection) {
        super(sourceSection);
    }

    protected VmTyped getEnclosingModule(VmObjectLike initialOwner) {
        VmObjectLike curr = initialOwner;
        for (VmObjectLike next = curr.getEnclosingOwner(); next != null; next = next.getEnclosingOwner()) {
            curr = next;
        }
        assert (curr.isModuleObject());
        return (VmTyped)curr;
    }

    protected VmTyped getImport(VmTyped module, Identifier importName, SourceSection importNameSection) {
        assert (importName.isLocalProp());
        ObjectMember member = module.getMember(importName);
        if (member == null) {
            throw this.exceptionBuilder().evalError("cannotFindModuleImport", importName).withSourceSection(importNameSection).build();
        }
        if (!member.isImport()) {
            throw this.exceptionBuilder().evalError("notAModuleImport", importName).withSourceSection(importNameSection).build();
        }
        if (member.isGlob()) {
            throw this.exceptionBuilder().evalError("notAType", importName).withSourceSection(importNameSection).build();
        }
        assert (member.getConstantValue() == null);
        Object result = module.getCachedValue(importName);
        if (result == null) {
            result = this.callNode.call((CallTarget)member.getCallTarget(), new Object[]{module, module, importName});
            module.setCachedValue(importName, result);
        }
        return (VmTyped)result;
    }

    @Nullable
    protected Object getType(VmTyped module, Identifier typeName, SourceSection typeNameSection) {
        ObjectMember member = module.getMember(typeName);
        if (member == null) {
            return null;
        }
        if (!member.isType()) {
            throw this.exceptionBuilder().evalError("notAType", typeName).withSourceSection(typeNameSection).build();
        }
        assert (member.getConstantValue() == null);
        Object result = module.getCachedValue(typeName);
        if (result == null) {
            result = this.callNode.call((CallTarget)member.getCallTarget(), new Object[]{module, module, typeName});
            module.setCachedValue(typeName, result);
        }
        return result;
    }
}

