/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.member;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.PklNode;
import org.pkl.core.ast.member.FunctionNode;
import org.pkl.core.ast.member.Member;
import org.pkl.core.ast.type.TypeNode;
import org.pkl.core.ast.type.UnresolvedTypeNode;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.Nullable;

public final class UnresolvedFunctionNode
extends PklNode {
    private final VmLanguage language;
    private final FrameDescriptor descriptor;
    private final Member member;
    private final int parameterCount;
    @Node.Children
    @Nullable
    private final UnresolvedTypeNode[] unresolvedParameterTypeNodes;
    @Node.Child
    @Nullable
    private UnresolvedTypeNode unresolvedReturnTypeNode;
    private final ExpressionNode bodyNode;

    public UnresolvedFunctionNode(VmLanguage language, FrameDescriptor descriptor, Member member, int parameterCount, @Nullable UnresolvedTypeNode[] unresolvedParameterTypeNodes, @Nullable UnresolvedTypeNode unresolvedReturnTypeNode, ExpressionNode bodyNode) {
        super(member.getSourceSection());
        this.language = language;
        this.descriptor = descriptor;
        this.member = member;
        this.parameterCount = parameterCount;
        this.unresolvedParameterTypeNodes = unresolvedParameterTypeNodes;
        this.unresolvedReturnTypeNode = unresolvedReturnTypeNode;
        this.bodyNode = bodyNode;
    }

    public FunctionNode execute(VirtualFrame frame) {
        CompilerAsserts.neverPartOfCompilation();
        TypeNode[] parameterTypeNodes = VmUtils.resolveParameterTypes(frame, this.descriptor, this.unresolvedParameterTypeNodes);
        TypeNode returnTypeNode = this.unresolvedReturnTypeNode != null ? this.unresolvedReturnTypeNode.execute(frame) : null;
        return new FunctionNode(this.language, this.descriptor, this.member, this.parameterCount, parameterTypeNodes, returnTypeNode, true, this.bodyNode);
    }
}

