/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.literal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.expression.literal.AmendFunctionNode;
import org.pkl.core.ast.type.TypeNode;
import org.pkl.core.ast.type.UnresolvedTypeNode;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmFunction;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.Nullable;

@NodeChild(value="parentNode", type=ExpressionNode.class)
public abstract class ObjectLiteralNode
extends ExpressionNode {
    protected final VmLanguage language;
    protected final String qualifiedScopeName;
    protected final boolean isCustomThisScope;
    @Nullable
    protected final FrameDescriptor parametersDescriptor;
    @Node.Children
    protected final UnresolvedTypeNode[] parameterTypes;

    public ObjectLiteralNode(SourceSection sourceSection, VmLanguage language, String qualifiedScopeName, boolean isCustomThisScope, @Nullable FrameDescriptor parametersDescriptor, UnresolvedTypeNode[] parameterTypes) {
        super(sourceSection);
        this.language = language;
        this.qualifiedScopeName = qualifiedScopeName;
        this.isCustomThisScope = isCustomThisScope;
        this.parametersDescriptor = parametersDescriptor;
        this.parameterTypes = parameterTypes;
    }

    protected abstract ExpressionNode getParentNode();

    protected abstract Object executeWithParent(VirtualFrame var1, Object var2);

    protected abstract ObjectLiteralNode copy(ExpressionNode var1);

    protected final AmendFunctionNode createAmendFunctionNode(VirtualFrame frame) {
        TypeNode[] resolvedParameterTypes = this.parametersDescriptor == null ? new TypeNode[]{} : VmUtils.resolveParameterTypes(frame, this.parametersDescriptor, this.parameterTypes);
        return new AmendFunctionNode(this, resolvedParameterTypes, frame.getFrameDescriptor());
    }

    @Idempotent
    protected static boolean isTypedObjectClass(VmClass clazz) {
        return !clazz.isListingClass() && !clazz.isMappingClass() && !clazz.isDynamicClass();
    }

    protected final boolean checkIsValidFunctionAmendment(VmFunction parent) {
        int length2 = this.parameterTypes.length;
        if (length2 > 0 && length2 != parent.getParameterCount()) {
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().evalError("wrongFunctionAmendmentParameterCount", length2, parent.getParameterCount()).withSourceSection(this.getParentNode().getSourceSection()).build();
        }
        return true;
    }
}

