/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmTypes;
import org.pkl.core.runtime.VmUtils;

@NodeInfo(language="Pkl")
@TypeSystemReference(value=VmTypes.class)
public abstract class PklNode
extends Node {
    protected final SourceSection sourceSection;

    protected PklNode(SourceSection sourceSection) {
        this.sourceSection = sourceSection;
    }

    protected PklNode() {
        this(VmUtils.unavailableSourceSection());
    }

    public SourceSection getSourceSection() {
        return this.sourceSection;
    }

    @CompilerDirectives.TruffleBoundary
    protected VmExceptionBuilder exceptionBuilder() {
        return new VmExceptionBuilder().withLocation(this);
    }

    @CompilerDirectives.TruffleBoundary
    protected final String getShortName() {
        return VmUtils.getNodeInfo(this).shortName();
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return String.format("(%s:%d) %s", this.sourceSection.getSource().getName(), this.sourceSection.getStartLine(), this.sourceSection.getCharacters());
    }
}

