/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.base;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import java.util.Base64;
import org.pkl.core.resource.Resource;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.stdlib.ExternalPropertyNode;
import org.pkl.core.util.ByteArrayUtils;

public final class ResourceNodes {
    private ResourceNodes() {
    }

    public static abstract class sha256Int
    extends ExternalPropertyNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"self.hasExtraStorage()"})
        protected long evalWithExtraStorage(VmTyped self) {
            Resource resource = (Resource)self.getExtraStorage();
            return ByteArrayUtils.sha256Int(resource.getBytes());
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!self.hasExtraStorage()"})
        protected long evalWithoutExtraStorage(VmTyped self) {
            String base642 = (String)VmUtils.readMember(self, Identifier.BASE64);
            byte[] bytes = Base64.getDecoder().decode(base642);
            return ByteArrayUtils.sha256Int(bytes);
        }
    }

    public static abstract class sha256
    extends ExternalPropertyNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"self.hasExtraStorage()"})
        protected String evalWithExtraStorage(VmTyped self) {
            Resource resource = (Resource)self.getExtraStorage();
            return ByteArrayUtils.sha256(resource.getBytes());
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!self.hasExtraStorage()"})
        protected String evalWithoutExtraStorage(VmTyped self) {
            String base642 = (String)VmUtils.readMember(self, Identifier.BASE64);
            byte[] bytes = Base64.getDecoder().decode(base642);
            return ByteArrayUtils.sha256(bytes);
        }
    }

    public static abstract class sha1
    extends ExternalPropertyNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"self.hasExtraStorage()"})
        protected String evalWithExtraStorage(VmTyped self) {
            Resource resource = (Resource)self.getExtraStorage();
            return ByteArrayUtils.sha1(resource.getBytes());
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!self.hasExtraStorage()"})
        protected String evalWithoutExtraStorage(VmTyped self) {
            String base642 = (String)VmUtils.readMember(self, Identifier.BASE64);
            byte[] bytes = Base64.getDecoder().decode(base642);
            return ByteArrayUtils.sha1(bytes);
        }
    }

    public static abstract class md5
    extends ExternalPropertyNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"self.hasExtraStorage()"})
        protected String evalWithExtraStorage(VmTyped self) {
            Resource resource = (Resource)self.getExtraStorage();
            return ByteArrayUtils.md5(resource.getBytes());
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!self.hasExtraStorage()"})
        protected String evalWithoutExtraStorage(VmTyped self) {
            String base642 = (String)VmUtils.readMember(self, Identifier.BASE64);
            byte[] bytes = Base64.getDecoder().decode(base642);
            return ByteArrayUtils.md5(bytes);
        }
    }
}

