/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.base;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.stdlib.ExternalMethod1Node;
import org.pkl.core.stdlib.PklConverter;
import org.pkl.core.stdlib.base.PcfRenderer;

public final class PcfRendererNodes {
    private PcfRendererNodes() {
    }

    private static PcfRenderer createRenderer(VmTyped self, StringBuilder builder) {
        String indent = (String)VmUtils.readMember(self, Identifier.INDENT);
        VmMapping converters = (VmMapping)VmUtils.readMember(self, Identifier.CONVERTERS);
        boolean omitNullProperties = (Boolean)VmUtils.readMember(self, Identifier.OMIT_NULL_PROPERTIES);
        boolean useCustomStringDelimiters = (Boolean)VmUtils.readMember(self, Identifier.USE_CUSTOM_STRING_DELIMITERS);
        PklConverter converter = new PklConverter(converters);
        return new PcfRenderer(builder, indent, converter, omitNullProperties, useCustomStringDelimiters);
    }

    public static abstract class renderValue
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String eval(VmTyped self, Object value2) {
            StringBuilder builder = new StringBuilder();
            PcfRendererNodes.createRenderer(self, builder).renderValue(value2);
            return builder.toString();
        }
    }

    public static abstract class renderDocument
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String eval(VmTyped self, Object value2) {
            StringBuilder builder = new StringBuilder();
            PcfRendererNodes.createRenderer(self, builder).renderDocument(value2);
            return builder.toString();
        }
    }
}

