/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.base;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import java.net.URI;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.stdlib.ExternalMethod1Node;
import org.pkl.core.stdlib.PklName;

@PklName(value="Module")
public final class ModuleClassNodes {
    private ModuleClassNodes() {
    }

    public static abstract class relativePathTo
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected VmList eval(VmObjectLike self, VmObjectLike other) {
            URI baseUri;
            URI relativizedUri;
            ModuleKey selfKey = VmUtils.getModuleInfo(self).getModuleKey();
            URI selfUri = selfKey.getUri();
            if (!other.isModuleObject()) {
                throw this.exceptionBuilder().evalError("expectedModule", new Object[0]).build();
            }
            ModuleKey otherKey = VmUtils.getModuleInfo(other).getModuleKey();
            URI otherUri = otherKey.getUri();
            int index = selfUri.toString().lastIndexOf(47);
            if (index != -1 && !(relativizedUri = (baseUri = URI.create(selfUri.toString().substring(0, index + 1))).relativize(otherUri)).isAbsolute()) {
                Object[] pathElements = relativizedUri.getPath().split("/");
                return VmList.create(pathElements, pathElements.length - 1);
            }
            throw this.exceptionBuilder().evalError("noDescendentPathBetweenModules", selfUri, otherUri).build();
        }
    }
}

