/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.concurrent.GuardedBy;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.collections.UnmodifiableEconomicSet;
import org.graalvm.collections.UnmodifiableMapCursor;
import org.pkl.core.Member;
import org.pkl.core.PClass;
import org.pkl.core.PClassInfo;
import org.pkl.core.PObject;
import org.pkl.core.TypeParameter;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.MemberNode;
import org.pkl.core.ast.VmModifier;
import org.pkl.core.ast.member.ClassMethod;
import org.pkl.core.ast.member.ClassProperty;
import org.pkl.core.ast.member.DelegateToExtraStorageMapOrParentNode;
import org.pkl.core.ast.member.DelegateToExtraStorageObjNode;
import org.pkl.core.ast.member.DelegateToExtraStorageObjOrParentNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.ast.member.TypeCheckedPropertyNodeGen;
import org.pkl.core.ast.member.UntypedObjectMemberNode;
import org.pkl.core.ast.type.TypeNode;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.MirrorFactories;
import org.pkl.core.runtime.VmCollection;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmSet;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.runtime.VmValue;
import org.pkl.core.runtime.VmValueConverter;
import org.pkl.core.runtime.VmValueVisitor;
import org.pkl.core.util.CollectionUtils;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.LateInit;
import org.pkl.core.util.Nullable;

public final class VmClass
extends VmValue {
    private final SourceSection sourceSection;
    private final SourceSection headerSection;
    @Nullable
    private final SourceSection docComment;
    private final List<VmTyped> annotations;
    private final int modifiers;
    private final PClassInfo<?> classInfo;
    private final List<TypeParameter> typeParameters;
    private final VmTyped prototype;
    private final EconomicMap<Identifier, ClassProperty> declaredProperties = EconomicMaps.create();
    private final EconomicMap<Identifier, ClassMethod> declaredMethods = EconomicMaps.create();
    @CompilerDirectives.CompilationFinal
    @Nullable
    private TypeNode supertypeNode;
    @CompilerDirectives.CompilationFinal
    @Nullable
    private VmClass superclass;
    @LateInit
    @GuardedBy(value="allPropertiesLock")
    private UnmodifiableEconomicMap<Identifier, ClassProperty> __allProperties;
    private final Object allPropertiesLock = new Object();
    @LateInit
    @GuardedBy(value="allMethodsLock")
    private UnmodifiableEconomicMap<Identifier, ClassMethod> __allMethods;
    private final Object allMethodsLock = new Object();
    @LateInit
    @GuardedBy(value="allRegularPropertyNamesLock")
    private UnmodifiableEconomicSet<Object> __allRegularPropertyNames;
    private final Object allRegularPropertyNamesLock = new Object();
    @LateInit
    @GuardedBy(value="allHiddenPropertyNamesLock")
    private UnmodifiableEconomicSet<Object> __allHiddenPropertyNames;
    private final Object allHiddenPropertyNamesLock = new Object();
    @CompilerDirectives.CompilationFinal
    private volatile boolean isInitialized;
    @LateInit
    @GuardedBy(value="pClassLock")
    private PClass __pClass;
    private final Object pClassLock = new Object();
    @LateInit
    @GuardedBy(value="mirrorLock")
    private VmTyped __mirror;
    private final Object mirrorLock = new Object();
    @LateInit
    @GuardedBy(value="typedToDynamicMembersLock")
    private EconomicMap<Object, ObjectMember> __typedToDynamicMembers;
    private final Object typedToDynamicMembersLock = new Object();
    @LateInit
    @GuardedBy(value="dynamicToTypedMembersLock")
    private EconomicMap<Object, ObjectMember> __dynamicToTypedMembers;
    private final Object dynamicToTypedMembersLock = new Object();
    @LateInit
    @GuardedBy(value="mapToTypedMembersLock")
    private EconomicMap<Object, ObjectMember> __mapToTypedMembers;
    private final Object mapToTypedMembersLock = new Object();

    public VmClass(SourceSection sourceSection, SourceSection headerSection, @Nullable SourceSection docComment, List<VmTyped> annotations, int modifiers, PClassInfo<?> classInfo, List<TypeParameter> typeParameters, VmTyped prototype) {
        this.sourceSection = sourceSection;
        this.headerSection = headerSection;
        this.docComment = docComment;
        this.annotations = annotations;
        this.modifiers = modifiers;
        this.classInfo = classInfo;
        this.typeParameters = typeParameters;
        this.prototype = prototype;
        prototype.lateInitVmClass(this);
    }

    public void initSupertype(TypeNode supertypeNode, VmClass superclass) {
        assert (this.supertypeNode == null);
        assert (this.superclass == null);
        this.supertypeNode = supertypeNode;
        this.superclass = superclass;
        this.prototype.lateInitParent(superclass.getPrototype());
    }

    @CompilerDirectives.TruffleBoundary
    public void addProperty(ClassProperty property) {
        this.prototype.addProperty(property.getInitializer());
        EconomicMaps.put(this.declaredProperties, property.getName(), property);
        if (!property.isLocal()) {
            this.__allProperties = null;
            this.__allHiddenPropertyNames = null;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void addProperties(Iterable<ClassProperty> properties) {
        for (ClassProperty property : properties) {
            this.addProperty(property);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void addMethod(ClassMethod method) {
        EconomicMaps.put(this.declaredMethods, method.getName(), method);
        if (!method.isLocal()) {
            this.__allMethods = null;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void addMethods(Iterable<ClassMethod> methods) {
        for (ClassMethod method : methods) {
            this.addMethod(method);
        }
    }

    public void notifyInitialized() {
        this.isInitialized = true;
    }

    public int getTypeParameterCount() {
        return this.typeParameters.size();
    }

    @Nullable
    public ClassProperty getDeclaredProperty(Identifier name) {
        return EconomicMaps.get(this.declaredProperties, name);
    }

    public Iterable<ClassProperty> getDeclaredProperties() {
        return EconomicMaps.getValues(this.declaredProperties);
    }

    @Override
    public VmClass getVmClass() {
        return BaseModule.getClassClass();
    }

    public SourceSection getSourceSection() {
        return this.sourceSection;
    }

    public SourceSection getHeaderSection() {
        return this.headerSection;
    }

    @Nullable
    public SourceSection getDocComment() {
        return this.docComment;
    }

    public List<VmTyped> getAnnotations() {
        return this.annotations;
    }

    public String getModuleName() {
        return this.classInfo.getModuleName();
    }

    public VmTyped getModule() {
        return this.classInfo.isModuleClass() ? this.prototype : (VmTyped)this.prototype.getEnclosingOwner();
    }

    public VmTyped getModuleMirror() {
        return this.getModule().getModuleInfo().getMirror(this.getModule());
    }

    public String getSimpleName() {
        return this.classInfo.getSimpleName();
    }

    public String getQualifiedName() {
        return this.classInfo.getQualifiedName();
    }

    public String getDisplayName() {
        return this.classInfo.getDisplayName();
    }

    public PClassInfo<?> getPClassInfo() {
        return this.classInfo;
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isHiddenProperty(Object key2) {
        return this.getAllHiddenPropertyNames().contains(key2);
    }

    @Nullable
    public ClassProperty getProperty(Identifier name) {
        return EconomicMaps.get(this.getAllProperties(), name);
    }

    public boolean hasProperty(Identifier name) {
        return !this.isInitialized || EconomicMaps.containsKey(this.getAllProperties(), name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnmodifiableEconomicSet<Object> getAllRegularPropertyNames() {
        Object object = this.allRegularPropertyNamesLock;
        synchronized (object) {
            if (this.__allRegularPropertyNames == null) {
                this.__allRegularPropertyNames = this.collectAllRegularPropertyNames();
            }
            return this.__allRegularPropertyNames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnmodifiableEconomicSet<Object> getAllHiddenPropertyNames() {
        Object object = this.allHiddenPropertyNamesLock;
        synchronized (object) {
            if (this.__allHiddenPropertyNames == null) {
                this.__allHiddenPropertyNames = this.collectAllHiddenPropertyNames();
            }
            return this.__allHiddenPropertyNames;
        }
    }

    public boolean hasDeclaredMethod(Identifier name) {
        return EconomicMaps.containsKey(this.declaredMethods, name);
    }

    @Nullable
    public ClassMethod getDeclaredMethod(Identifier name) {
        return EconomicMaps.get(this.declaredMethods, name);
    }

    public Iterable<ClassMethod> getDeclaredMethods() {
        return EconomicMaps.getValues(this.declaredMethods);
    }

    @Nullable
    public ClassMethod getMethod(Identifier name) {
        return EconomicMaps.get(this.getAllMethods(), name);
    }

    public Iterable<ClassMethod> getMethods() {
        return EconomicMaps.getValues(this.getAllMethods());
    }

    @Nullable
    public VmClass getSuperclass() {
        return this.superclass;
    }

    @Override
    public VmTyped getPrototype() {
        return this.prototype;
    }

    @Idempotent
    public boolean isAbstract() {
        return VmModifier.isAbstract(this.modifiers);
    }

    @Idempotent
    public boolean isExternal() {
        return VmModifier.isExternal(this.modifiers);
    }

    @Idempotent
    public boolean isOpen() {
        return VmModifier.isOpen(this.modifiers);
    }

    @Idempotent
    public boolean isClosed() {
        return VmModifier.isClosed(this.modifiers);
    }

    @Idempotent
    public boolean isInstantiable() {
        return VmModifier.isInstantiable(this.modifiers);
    }

    @Idempotent
    public boolean isNullClass() {
        return this.isClass(BaseModule.getNullClass(), "pkl.base#Null");
    }

    @Idempotent
    public boolean isCollectionClass() {
        return this.isClass(BaseModule.getCollectionClass(), "pkl.base#Collection");
    }

    @Idempotent
    public boolean isListClass() {
        return this.isClass(BaseModule.getListClass(), "pkl.base#List");
    }

    @Idempotent
    public boolean isSetClass() {
        return this.isClass(BaseModule.getSetClass(), "pkl.base#Set");
    }

    @Idempotent
    public boolean isMapClass() {
        return this.isClass(BaseModule.getMapClass(), "pkl.base#Map");
    }

    @Idempotent
    public boolean isListingClass() {
        return this.isClass(BaseModule.getListingClass(), "pkl.base#Listing");
    }

    @Idempotent
    public boolean isMappingClass() {
        return this.isClass(BaseModule.getMappingClass(), "pkl.base#Mapping");
    }

    @Idempotent
    public boolean isDynamicClass() {
        return this.isClass(BaseModule.getDynamicClass(), "pkl.base#Dynamic");
    }

    @Idempotent
    public boolean isPairClass() {
        return this.isClass(BaseModule.getPairClass(), "pkl.base#Pair");
    }

    @Idempotent
    public boolean isFunctionClass() {
        return this.isClass(BaseModule.getFunctionClass(), "pkl.base#Function");
    }

    @Idempotent
    public boolean isFunctionNClass() {
        return this.superclass != null && this.superclass.isClass(BaseModule.getFunctionClass(), "pkl.base#Function");
    }

    @Idempotent
    public boolean isModuleClass() {
        return this.isClass(BaseModule.getModuleClass(), "pkl.base#Module");
    }

    @Idempotent
    public boolean isClassClass() {
        return this.isClass(BaseModule.getClassClass(), "pkl.base#Class");
    }

    @Idempotent
    public boolean isVarArgsClass() {
        return this.isClass(BaseModule.getVarArgsClass(), "pkl.base#VarArgs");
    }

    private boolean isClass(@Nullable VmClass clazz, String qualifiedClassName) {
        return clazz != null ? this == clazz : this.getQualifiedName().equals(qualifiedClassName);
    }

    public boolean isSuperclassOf(VmClass other) {
        if (this.isClosed()) {
            return this == other;
        }
        for (VmClass clazz = other; clazz != null; clazz = clazz.getSuperclass()) {
            if (clazz != this) continue;
            return true;
        }
        return false;
    }

    public boolean isSubclassOf(VmClass other) {
        return other.isSuperclassOf(this);
    }

    public void visitMethodDefsTopDown(Consumer<ClassMethod> visitor) {
        if (this.superclass != null) {
            this.superclass.visitMethodDefsTopDown(visitor);
        }
        EconomicMaps.getValues(this.declaredMethods).forEach(visitor);
    }

    @Override
    public void force(boolean allowUndefinedValues) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VmTyped getMirror() {
        Object object = this.mirrorLock;
        synchronized (object) {
            if (this.__mirror == null) {
                this.__mirror = MirrorFactories.classFactory.create(this);
            }
            return this.__mirror;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public EconomicMap<Object, ObjectMember> getTypedToDynamicMembers() {
        Object object = this.typedToDynamicMembersLock;
        synchronized (object) {
            if (this.__typedToDynamicMembers == null) {
                this.__typedToDynamicMembers = this.createDelegatingMembers(member -> new UntypedObjectMemberNode(null, new FrameDescriptor(), (ObjectMember)member, (ExpressionNode)new DelegateToExtraStorageObjNode()));
            }
            return this.__typedToDynamicMembers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public EconomicMap<Object, ObjectMember> getDynamicToTypedMembers() {
        Object object = this.dynamicToTypedMembersLock;
        synchronized (object) {
            if (this.__dynamicToTypedMembers == null) {
                this.__dynamicToTypedMembers = this.createDelegatingMembers(member -> TypeCheckedPropertyNodeGen.create(null, new FrameDescriptor(), member, new DelegateToExtraStorageObjOrParentNode()));
            }
            return this.__dynamicToTypedMembers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public EconomicMap<Object, ObjectMember> getMapToTypedMembers() {
        Object object = this.mapToTypedMembersLock;
        synchronized (object) {
            if (this.__mapToTypedMembers == null) {
                this.__mapToTypedMembers = this.createDelegatingMembers(member -> TypeCheckedPropertyNodeGen.create(null, new FrameDescriptor(), member, new DelegateToExtraStorageMapOrParentNode()));
            }
            return this.__mapToTypedMembers;
        }
    }

    private EconomicMap<Object, ObjectMember> createDelegatingMembers(Function<ObjectMember, MemberNode> memberNodeFactory) {
        EconomicMap result = EconomicMaps.create();
        UnmodifiableMapCursor cursor = this.getAllProperties().getEntries();
        while (cursor.advance()) {
            ClassProperty property = (ClassProperty)cursor.getValue();
            if (property.isHidden()) continue;
            Identifier name = (Identifier)cursor.getKey();
            ObjectMember member = new ObjectMember(VmUtils.unavailableSourceSection(), VmUtils.unavailableSourceSection(), 0, name, name.toString());
            member.initMemberNode(memberNodeFactory.apply(member));
            result.put((Object)name, (Object)member);
        }
        return result;
    }

    public VmSet getModifierMirrors() {
        return VmModifier.getMirrors(this.modifiers, true);
    }

    public VmList getTypeParameterMirrors() {
        VmCollection.Builder<VmList> builder = VmList.EMPTY.builder();
        for (TypeParameter typeParameter : this.typeParameters) {
            builder.add(MirrorFactories.typeParameterFactory.create(typeParameter));
        }
        return builder.build();
    }

    public VmValue getSuperclassMirror() {
        return this.superclass == null ? VmNull.withoutDefault() : this.superclass.getMirror();
    }

    public VmValue getSupertypeMirror() {
        return this.supertypeNode == null ? VmNull.withoutDefault() : this.supertypeNode.getMirror();
    }

    public VmMap getPropertyMirrors() {
        VmMap.Builder builder = VmMap.builder();
        for (ClassProperty property : this.declaredProperties.getValues()) {
            if (property.isLocal()) continue;
            builder.add(property.getName().toString(), property.getMirror());
        }
        return builder.build();
    }

    public VmMap getMethodMirrors() {
        VmMap.Builder builder = VmMap.builder();
        for (ClassMethod method : this.declaredMethods.getValues()) {
            if (method.isLocal()) continue;
            builder.add(method.getName().toString(), method.getMirror());
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CompilerDirectives.TruffleBoundary
    public PClass export() {
        Object object = this.pClassLock;
        synchronized (object) {
            if (this.__pClass == null) {
                ArrayList<PObject> exportedAnnotations = new ArrayList<PObject>();
                LinkedHashMap<String, PClass.Property> properties = CollectionUtils.newLinkedHashMap(EconomicMaps.size(this.declaredProperties));
                LinkedHashMap<String, PClass.Method> methods = CollectionUtils.newLinkedHashMap(EconomicMaps.size(this.declaredMethods));
                this.__pClass = new PClass(VmUtils.exportDocComment(this.docComment), new Member.SourceLocation(this.headerSection.getStartLine(), this.sourceSection.getEndLine()), VmModifier.export(this.modifiers, true), exportedAnnotations, this.classInfo, this.typeParameters, properties, methods);
                for (TypeParameter parameter : this.typeParameters) {
                    parameter.initOwner(this.__pClass);
                }
                if (this.supertypeNode != null) {
                    assert (this.superclass != null);
                    this.__pClass.initSupertype(TypeNode.export(this.supertypeNode), this.superclass.export());
                }
                VmUtils.exportAnnotations(this.annotations, exportedAnnotations);
                for (ClassProperty property : EconomicMaps.getValues(this.declaredProperties)) {
                    if (!this.isClassPropertyDefinition(property)) continue;
                    properties.put(property.getName().toString(), property.export(this.__pClass));
                }
                for (ClassMethod method : EconomicMaps.getValues(this.declaredMethods)) {
                    if (method.isLocal()) continue;
                    methods.put(method.getName().toString(), method.export(this.__pClass));
                }
            }
            return this.__pClass;
        }
    }

    @Override
    public void accept(VmValueVisitor visitor) {
        visitor.visitClass(this);
    }

    @Override
    public <T> T accept(VmValueConverter<T> converter, Iterable<Object> path) {
        return converter.convertClass(this, path);
    }

    public String toString() {
        return this.getDisplayName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UnmodifiableEconomicMap<Identifier, ClassProperty> getAllProperties() {
        Object object = this.allPropertiesLock;
        synchronized (object) {
            if (this.__allProperties == null) {
                this.__allProperties = this.collectAllProperties();
            }
            return this.__allProperties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UnmodifiableEconomicMap<Identifier, ClassMethod> getAllMethods() {
        Object object = this.allMethodsLock;
        synchronized (object) {
            if (this.__allMethods == null) {
                this.__allMethods = this.collectAllMethods();
            }
            return this.__allMethods;
        }
    }

    private boolean isClassPropertyDefinition(ClassProperty declaredProperty) {
        if (declaredProperty.isLocal() || declaredProperty.isClass() || declaredProperty.isTypeAlias()) {
            return false;
        }
        return this.getProperty(declaredProperty.getName()) == declaredProperty;
    }

    @CompilerDirectives.TruffleBoundary
    private UnmodifiableEconomicMap<Identifier, ClassProperty> collectAllProperties() {
        if (EconomicMaps.isEmpty(this.declaredProperties)) {
            return this.superclass == null ? EconomicMaps.create() : this.superclass.getAllProperties();
        }
        int size = EconomicMaps.size(this.declaredProperties) + (this.superclass == null ? 0 : EconomicMaps.size(this.superclass.getAllProperties()));
        EconomicMap result = EconomicMaps.create(size);
        if (this.superclass != null) {
            EconomicMaps.putAll(result, this.superclass.getAllProperties());
        }
        for (ClassProperty property : EconomicMaps.getValues(this.declaredProperties)) {
            if (property.isLocal() || property.getTypeNode() == null && EconomicMaps.containsKey(result, property.getName())) continue;
            EconomicMaps.put(result, property.getName(), property);
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    private UnmodifiableEconomicMap<Identifier, ClassMethod> collectAllMethods() {
        if (EconomicMaps.isEmpty(this.declaredMethods)) {
            return this.superclass == null ? EconomicMaps.create() : this.superclass.getAllMethods();
        }
        int size = EconomicMaps.size(this.declaredMethods) + (this.superclass == null ? 0 : EconomicMaps.size(this.superclass.getAllMethods()));
        EconomicMap result = EconomicMaps.create(size);
        if (this.superclass != null) {
            EconomicMaps.putAll(result, this.superclass.getAllMethods());
        }
        for (ClassMethod method : EconomicMaps.getValues(this.declaredMethods)) {
            if (method.isLocal()) continue;
            EconomicMaps.put(result, method.getName(), method);
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    private UnmodifiableEconomicSet<Object> collectAllRegularPropertyNames() {
        if (EconomicMaps.isEmpty(this.declaredProperties)) {
            return this.superclass == null ? EconomicSet.create() : this.superclass.getAllRegularPropertyNames();
        }
        int size = this.superclass == null ? 0 : this.superclass.getAllRegularPropertyNames().size();
        EconomicSet result = EconomicSet.create((int)size);
        for (ClassProperty property : EconomicMaps.getValues(this.declaredProperties)) {
            if (property.isLocal() || this.isHiddenProperty(property.getName()) || property.isExternal()) continue;
            result.add((Object)property.getName());
        }
        if (this.superclass == null) {
            return result;
        }
        if (result.isEmpty()) {
            return this.superclass.getAllRegularPropertyNames();
        }
        result.addAll(this.superclass.getAllRegularPropertyNames());
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    private UnmodifiableEconomicSet<Object> collectAllHiddenPropertyNames() {
        if (EconomicMaps.isEmpty(this.declaredProperties)) {
            return this.superclass == null ? EconomicSet.create() : this.superclass.getAllHiddenPropertyNames();
        }
        int size = this.superclass == null ? 0 : this.superclass.getAllHiddenPropertyNames().size();
        EconomicSet result = EconomicSet.create((int)size);
        for (ClassProperty property : EconomicMaps.getValues(this.declaredProperties)) {
            if (!property.isHidden()) continue;
            result.add((Object)property.getName());
        }
        if (this.superclass == null) {
            return result;
        }
        if (result.isEmpty()) {
            return this.superclass.getAllHiddenPropertyNames();
        }
        result.addAll(this.superclass.getAllHiddenPropertyNames());
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return this.classInfo.hashCode();
    }
}

