/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.parser;

import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.InputMismatchException;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.IntervalSet;
import org.pkl.core.parser.Lexer;

final class ErrorStrategy
extends DefaultErrorStrategy {
    ErrorStrategy() {
    }

    protected void reportNoViableAlternative(Parser parser, NoViableAltException e2) {
        StringBuilder builder = new StringBuilder();
        Token offendingToken = e2.getOffendingToken();
        if (Lexer.isKeyword(offendingToken)) {
            this.appendKeywordNotAllowedMessage(builder, e2.getOffendingToken(), e2.getExpectedTokens());
        } else {
            builder.append("No viable alternative at input ");
            TokenStream tokens = parser.getInputStream();
            if (e2.getStartToken().getType() == -1) {
                builder.append("<EOF>");
            } else {
                builder.append(this.escapeWSAndQuote(tokens.getText((Object)e2.getStartToken(), (Object)offendingToken)));
            }
        }
        parser.notifyErrorListeners(offendingToken, builder.toString(), (RecognitionException)e2);
    }

    protected void reportInputMismatch(Parser parser, InputMismatchException e2) {
        StringBuilder builder = new StringBuilder();
        Token offendingToken = e2.getOffendingToken();
        if (Lexer.isKeyword(offendingToken)) {
            this.appendKeywordNotAllowedMessage(builder, e2.getOffendingToken(), e2.getExpectedTokens());
        } else {
            builder.append("Mismatched input: ").append(this.getTokenErrorDisplay(offendingToken)).append(". ");
            this.appendExpectedTokensMessage(builder, parser);
        }
        parser.notifyErrorListeners(offendingToken, builder.toString(), (RecognitionException)e2);
    }

    protected void reportUnwantedToken(Parser parser) {
        if (this.inErrorRecoveryMode(parser)) {
            return;
        }
        this.beginErrorCondition(parser);
        StringBuilder builder = new StringBuilder();
        Token currentToken = parser.getCurrentToken();
        if (Lexer.isKeyword(currentToken)) {
            this.appendKeywordNotAllowedMessage(builder, currentToken, parser.getExpectedTokens());
        } else {
            builder.append("Extraneous input: ").append(this.getTokenErrorDisplay(currentToken)).append(". ");
            this.appendExpectedTokensMessage(builder, parser);
        }
        parser.notifyErrorListeners(currentToken, builder.toString(), null);
    }

    protected void reportMissingToken(Parser parser) {
        if (this.inErrorRecoveryMode(parser)) {
            return;
        }
        this.beginErrorCondition(parser);
        StringBuilder builder = new StringBuilder();
        Token currentToken = parser.getCurrentToken();
        IntervalSet expecting = this.getExpectedTokens(parser);
        builder.append("Missing ").append(expecting.toString(parser.getVocabulary())).append(" at ").append(this.getTokenErrorDisplay(currentToken)).append(". ");
        parser.notifyErrorListeners(currentToken, builder.toString(), null);
    }

    private void appendExpectedTokensMessage(StringBuilder builder, Parser parser) {
        IntervalSet expectedTokens = parser.getExpectedTokens();
        int size = expectedTokens.size();
        if (size == 0) {
            return;
        }
        builder.append(size == 1 ? "Expected: " : "Expected one of: ");
        String msg = expectedTokens.toString(parser.getVocabulary());
        if (msg.startsWith("{")) {
            msg = msg.substring(1);
        }
        if (msg.endsWith("}")) {
            msg = msg.substring(0, msg.length() - 1);
        }
        builder.append(msg);
    }

    private void appendKeywordNotAllowedMessage(StringBuilder builder, Token offendingToken, IntervalSet expectedTokens) {
        builder.append("Keyword `").append(offendingToken.getText()).append("` is not allowed here.");
        if (expectedTokens.contains(88)) {
            builder.append(" (If you must use this name as identifier, enclose it in backticks.)");
        }
    }
}

