/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.packages;

import java.net.URI;
import java.net.URISyntaxException;
import org.pkl.core.PklBugException;
import org.pkl.core.Version;
import org.pkl.core.packages.Checksums;
import org.pkl.core.packages.PackageAssetUri;
import org.pkl.core.util.ErrorMessages;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.Nullable;

public final class PackageUri {
    private final URI uri;
    private final Version version;
    private final String pathWithoutVersion;
    @Nullable
    private Checksums checksums;

    public static PackageUri create(String baseUri) {
        try {
            return new PackageUri(baseUri);
        }
        catch (URISyntaxException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    public PackageUri(String baseUri) throws URISyntaxException {
        this(new URI(baseUri));
    }

    public PackageUri(URI uri) throws URISyntaxException {
        if (uri.isOpaque()) {
            throw new URISyntaxException(uri.toString(), ErrorMessages.create("invalidModuleUriMissingSlash", uri, "package"));
        }
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equals("package") && !scheme.equals("projectpackage")) {
            throw new URISyntaxException(uri.toString(), ErrorMessages.create("invalidSchemeInPackageUri", scheme));
        }
        String authority = uri.getAuthority();
        if (authority == null || authority.isEmpty()) {
            throw new URISyntaxException(uri.toString(), ErrorMessages.create("missingAuthorityInPackageUri", uri));
        }
        String path = uri.getPath();
        if (path == null || path.isEmpty()) {
            throw new URISyntaxException(uri.toString(), ErrorMessages.create("missingPathInPackageUri", uri));
        }
        int versionIdx = path.lastIndexOf(64);
        if (versionIdx == -1) {
            throw new URISyntaxException(uri.toString(), ErrorMessages.create("missingVersionInPackageUri", path));
        }
        this.uri = IoUtils.stripFragment(uri);
        this.pathWithoutVersion = path.substring(0, versionIdx);
        int checksumIdx = path.indexOf("::");
        String versionPart = path.substring(versionIdx + 1);
        if (checksumIdx > versionIdx) {
            String checksumPart = path.substring(checksumIdx + 2);
            versionPart = path.substring(versionIdx + 1, checksumIdx);
            this.checksums = this.parseChecksumPart(checksumPart);
        }
        try {
            this.version = Version.parse(versionPart);
        }
        catch (IllegalArgumentException e2) {
            throw new URISyntaxException(uri.toString(), e2.getMessage());
        }
    }

    public URI getUri() {
        return this.uri;
    }

    public URI getMetadataRequestUri() {
        if (this.checksums != null) {
            String schemeSpecificPart = this.uri.getSchemeSpecificPart();
            int checksumIdx = schemeSpecificPart.lastIndexOf("::");
            String effectiveSchemeSpecificPart = schemeSpecificPart.substring(0, checksumIdx);
            return URI.create("https:" + effectiveSchemeSpecificPart);
        }
        return URI.create("https:" + this.uri.getSchemeSpecificPart());
    }

    public Version getVersion() {
        return this.version;
    }

    public String toString() {
        return this.uri.toString();
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageUri that = (PackageUri)o;
        return this.getUri().equals(that.getUri());
    }

    public PackageAssetUri toPackageAssetUri(String path) {
        return new PackageAssetUri(this, path);
    }

    public String getDisplayName() {
        String str = this.toExternalPackageUri().toString();
        if (this.checksums != null) {
            int checksumsIdx = str.lastIndexOf("::");
            return str.substring(0, checksumsIdx);
        }
        return str;
    }

    public PackageUri toExternalPackageUri() {
        if (this.uri.getScheme().equals("package")) {
            return this;
        }
        try {
            return new PackageUri(new URI("package", this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), this.uri.getPath(), this.uri.getQuery(), this.uri.getFragment()));
        }
        catch (URISyntaxException e2) {
            throw PklBugException.unreachableCode();
        }
    }

    public PackageUri toProjectPackageUri() {
        if (this.uri.getScheme().equals("projectpackage")) {
            return this;
        }
        try {
            return new PackageUri(new URI("projectpackage", this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), this.uri.getPath(), this.uri.getQuery(), this.uri.getFragment()));
        }
        catch (URISyntaxException e2) {
            throw PklBugException.unreachableCode();
        }
    }

    public String getPathWithoutVersion() {
        return this.pathWithoutVersion;
    }

    @Nullable
    public Checksums getChecksums() {
        return this.checksums;
    }

    private Checksums parseChecksumPart(String checksumPart) throws URISyntaxException {
        String[] parts = checksumPart.split(":");
        if (parts.length != 2) {
            throw new URISyntaxException(this.uri.toString(), ErrorMessages.create("invalidPackageUriChecksum", checksumPart));
        }
        String algorithm = parts[0];
        String checksum = parts[1];
        if (!algorithm.equals("sha256")) {
            throw new URISyntaxException(this.uri.toString(), ErrorMessages.create("unknownChecksumAlgorithm", algorithm));
        }
        return new Checksums(checksum);
    }
}

