/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.packages;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.pkl.core.Version;
import org.pkl.core.packages.Checksums;
import org.pkl.core.packages.Dependency;
import org.pkl.core.packages.PackageUri;
import org.pkl.core.packages.PackageUtils;
import org.pkl.core.util.Nullable;
import org.pkl.core.util.json.Json;
import org.pkl.core.util.json.JsonWriter;

public final class DependencyMetadata {
    private final String name;
    private final PackageUri packageUri;
    private final Version version;
    private final URI packageZipUrl;
    private final Checksums packageZipChecksums;
    private final Map<String, Dependency.RemoteDependency> dependencies;
    @Nullable
    private final String sourceCodeUrlScheme;
    @Nullable
    private final URI sourceCode;
    @Nullable
    private final URI documentation;
    @Nullable
    private final String license;
    @Nullable
    private final String licenseText;
    @Nullable
    private final List<String> authors;
    @Nullable
    private final URI issueTracker;
    @Nullable
    private final String description;

    public static DependencyMetadata parse(String input) throws Json.JsonParseException {
        Json.JsObject parsed = Json.parseObject(input);
        String name = parsed.getString("name");
        PackageUri packageUri = parsed.get("packageUri", it -> new PackageUri((String)it));
        Version version = parsed.getVersion("version");
        URI packageZipUrl = parsed.getURI("packageZipUrl");
        Checksums packageZipChecksums = parsed.get("packageZipChecksums", DependencyMetadata::parseChecksums);
        Map dependencies = parsed.get("dependencies", DependencyMetadata::parseDependencies);
        String sourceCodeUrlScheme = parsed.getStringOrNull("sourceCodeUrlScheme");
        URI sourceCode = parsed.getURIOrNull("sourceCode");
        URI documentation = parsed.getURIOrNull("documentation");
        String license = parsed.getStringOrNull("license");
        String licenseText = parsed.getStringOrNull("licenseText");
        List authors = parsed.getNullable("authors", DependencyMetadata::parseAuthors);
        URI issueTracker = parsed.getURIOrNull("issueTracker");
        String description = parsed.getStringOrNull("description");
        return new DependencyMetadata(name, packageUri, version, packageZipUrl, packageZipChecksums, dependencies, sourceCodeUrlScheme, sourceCode, documentation, license, licenseText, authors, issueTracker, description);
    }

    private static Map<String, Dependency.RemoteDependency> parseDependencies(Object deps) throws Json.JsonParseException {
        if (!(deps instanceof Json.JsObject)) {
            throw new Json.FormatException("object", deps.getClass());
        }
        Json.JsObject dependencies = (Json.JsObject)deps;
        HashMap<String, Dependency.RemoteDependency> ret = new HashMap<String, Dependency.RemoteDependency>(dependencies.size());
        for (String key2 : dependencies.keySet()) {
            Dependency.RemoteDependency remoteDependency = dependencies.get(key2, dep -> {
                if (!(dep instanceof Json.JsObject)) {
                    throw new Json.FormatException("object", dep.getClass());
                }
                Json.JsObject obj = (Json.JsObject)dep;
                Checksums checksums = obj.get("checksums", DependencyMetadata::parseChecksums);
                PackageUri packageUri = obj.get("uri", PackageUtils::parsePackageUriWithoutChecksums);
                return new Dependency.RemoteDependency(packageUri, checksums);
            });
            ret.put(key2, remoteDependency);
        }
        return ret;
    }

    public static Checksums parseChecksums(Object obj) throws Json.JsonParseException {
        if (!(obj instanceof Json.JsObject)) {
            throw new Json.FormatException("object", obj.getClass());
        }
        Json.JsObject jsObj = (Json.JsObject)obj;
        String sha2562 = jsObj.getString("sha256");
        return new Checksums(sha2562);
    }

    public static List<String> parseAuthors(Object obj) throws Json.JsonParseException {
        if (!(obj instanceof Json.JsArray)) {
            throw new Json.FormatException("array", obj.getClass());
        }
        Json.JsArray arr = (Json.JsArray)obj;
        ArrayList<String> ret = new ArrayList<String>(arr.size());
        for (Object elem : arr) {
            if (!(elem instanceof String)) {
                throw new Json.FormatException("string", elem.getClass());
            }
            String string = (String)elem;
            ret.add(string);
        }
        return ret;
    }

    public DependencyMetadata(String name, PackageUri packageUri, Version version, URI packageZipUrl, Checksums packageZipChecksums, Map<String, Dependency.RemoteDependency> dependencies, @Nullable String sourceCodeUrlScheme, @Nullable URI sourceCode, @Nullable URI documentation, @Nullable String license, @Nullable String licenseText, @Nullable List<String> authors, @Nullable URI issueTracker, @Nullable String description) {
        this.name = name;
        this.packageUri = packageUri;
        this.version = version;
        this.packageZipUrl = packageZipUrl;
        this.packageZipChecksums = packageZipChecksums;
        this.dependencies = dependencies;
        this.sourceCodeUrlScheme = sourceCodeUrlScheme;
        this.sourceCode = sourceCode;
        this.documentation = documentation;
        this.license = license;
        this.licenseText = licenseText;
        this.authors = authors;
        this.issueTracker = issueTracker;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public Version getVersion() {
        return this.version;
    }

    public URI getPackageZipUrl() {
        return this.packageZipUrl;
    }

    public Checksums getPackageZipChecksums() {
        return this.packageZipChecksums;
    }

    public Map<String, Dependency.RemoteDependency> getDependencies() {
        return this.dependencies;
    }

    @Nullable
    public String getSourceCodeUrlScheme() {
        return this.sourceCodeUrlScheme;
    }

    @Nullable
    public URI getSourceCode() {
        return this.sourceCode;
    }

    @Nullable
    public URI getDocumentation() {
        return this.documentation;
    }

    @Nullable
    public String getLicense() {
        return this.license;
    }

    @Nullable
    public String getLicenseText() {
        return this.licenseText;
    }

    @Nullable
    public List<String> getAuthors() {
        return this.authors;
    }

    @Nullable
    public URI getIssueTracker() {
        return this.issueTracker;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void writeTo(OutputStream out) throws IOException {
        new DependencyMetadataWriter(out, this).write();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependencyMetadata that = (DependencyMetadata)o;
        return this.name.equals(that.name) && this.packageUri.equals(that.packageUri) && this.version.equals(that.version) && this.packageZipUrl.equals(that.packageZipUrl) && this.packageZipChecksums.equals(that.packageZipChecksums) && this.dependencies.equals(that.dependencies) && Objects.equals(this.sourceCodeUrlScheme, that.sourceCodeUrlScheme) && Objects.equals(this.sourceCode, that.sourceCode) && Objects.equals(this.documentation, that.documentation) && Objects.equals(this.license, that.license) && Objects.equals(this.licenseText, that.licenseText) && Objects.equals(this.authors, that.authors) && Objects.equals(this.issueTracker, that.issueTracker) && Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.packageUri, this.version, this.packageZipUrl, this.packageZipChecksums, this.dependencies, this.sourceCodeUrlScheme, this.sourceCode, this.documentation, this.license, this.licenseText, this.authors, this.issueTracker, this.description);
    }

    public String toString() {
        return "DependencyMetadata{name='" + this.name + "'packageUri='" + this.packageUri + "', version=" + this.version + ", packageZipUrl=" + this.packageZipUrl + ", packageZipChecksums=" + this.packageZipChecksums + ", dependencies=" + this.dependencies + ", sourceCodeUrlScheme='" + this.sourceCodeUrlScheme + "', sourceCode='" + this.sourceCode + "', documentation='" + this.documentation + "', license='" + this.license + "', licenseText='" + this.licenseText + "', authors=" + this.authors + "', issueTracker=" + this.issueTracker + "', description=" + this.description + "}";
    }

    private static final class DependencyMetadataWriter {
        private final JsonWriter jsonWriter;
        private final DependencyMetadata dependencyMetadata;

        private DependencyMetadataWriter(OutputStream outputStream, DependencyMetadata dependencyMetadata) {
            this.jsonWriter = new JsonWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
            this.jsonWriter.setIndent("  ");
            this.dependencyMetadata = dependencyMetadata;
        }

        private void writeChecksums() throws IOException {
            this.jsonWriter.beginObject();
            this.jsonWriter.name("sha256").value(this.dependencyMetadata.packageZipChecksums.getSha256());
            this.jsonWriter.endObject();
        }

        private void writeDependencies() throws IOException {
            this.jsonWriter.beginObject();
            for (Map.Entry<String, Dependency.RemoteDependency> entry : this.dependencyMetadata.getDependencies().entrySet()) {
                this.jsonWriter.name(entry.getKey());
                this.jsonWriter.beginObject();
                this.jsonWriter.name("uri").value(entry.getValue().getPackageUri().toString());
                Checksums checksums = entry.getValue().getChecksums();
                if (checksums != null) {
                    this.jsonWriter.name("checksums");
                    this.jsonWriter.beginObject();
                    this.jsonWriter.name("sha256").value(entry.getValue().getChecksums().getSha256());
                    this.jsonWriter.endObject();
                }
                this.jsonWriter.endObject();
            }
            this.jsonWriter.endObject();
        }

        private void writeAuthors() throws IOException {
            List<String> authors = this.dependencyMetadata.authors;
            assert (authors != null);
            this.jsonWriter.beginArray();
            for (String author : authors) {
                this.jsonWriter.value(author);
            }
            this.jsonWriter.endArray();
        }

        private void write() throws IOException {
            this.jsonWriter.beginObject();
            this.jsonWriter.name("name").value(this.dependencyMetadata.name);
            this.jsonWriter.name("packageUri").value(this.dependencyMetadata.packageUri.toString());
            this.jsonWriter.name("version").value(this.dependencyMetadata.version.toString());
            this.jsonWriter.name("packageZipUrl").value(this.dependencyMetadata.packageZipUrl.toString());
            this.jsonWriter.name("packageZipChecksums");
            this.writeChecksums();
            this.jsonWriter.name("dependencies");
            this.writeDependencies();
            if (this.dependencyMetadata.sourceCodeUrlScheme != null) {
                this.jsonWriter.name("sourceCodeUrlScheme").value(this.dependencyMetadata.sourceCodeUrlScheme);
            }
            if (this.dependencyMetadata.sourceCode != null) {
                this.jsonWriter.name("sourceCode").value(this.dependencyMetadata.sourceCode.toString());
            }
            if (this.dependencyMetadata.documentation != null) {
                this.jsonWriter.name("documentation").value(this.dependencyMetadata.documentation.toString());
            }
            if (this.dependencyMetadata.license != null) {
                this.jsonWriter.name("license").value(this.dependencyMetadata.license);
            }
            if (this.dependencyMetadata.licenseText != null) {
                this.jsonWriter.name("licenseText").value(this.dependencyMetadata.licenseText);
            }
            if (this.dependencyMetadata.authors != null) {
                this.jsonWriter.name("authors");
                this.writeAuthors();
            }
            if (this.dependencyMetadata.issueTracker != null) {
                this.jsonWriter.name("issueTracker").value(this.dependencyMetadata.issueTracker.toString());
            }
            if (this.dependencyMetadata.description != null) {
                this.jsonWriter.name("description").value(this.dependencyMetadata.description);
            }
            this.jsonWriter.endObject();
            this.jsonWriter.close();
        }
    }
}

