/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.http;

import com.oracle.truffle.api.nodes.ExplodeLoop;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.util.List;
import org.pkl.core.http.NoProxyRule;
import org.pkl.core.util.ErrorMessages;
import org.pkl.core.util.Nullable;

final class ProxySelector
extends java.net.ProxySelector {
    public static final List<Proxy> NO_PROXY = List.of(Proxy.NO_PROXY);
    @Nullable
    private final List<Proxy> myProxy;
    private final List<NoProxyRule> noProxyRules;
    @Nullable
    private final java.net.ProxySelector delegate;

    ProxySelector(@Nullable URI proxyAddress, List<String> noProxyRules) {
        this.noProxyRules = noProxyRules.stream().map(NoProxyRule::new).toList();
        if (proxyAddress == null) {
            this.delegate = java.net.ProxySelector.getDefault();
            this.myProxy = null;
        } else {
            if (!proxyAddress.getScheme().equalsIgnoreCase("http") || proxyAddress.getHost() == null || !proxyAddress.getPath().isEmpty() || proxyAddress.getUserInfo() != null) {
                throw new IllegalArgumentException(ErrorMessages.create("malformedProxyAddress", proxyAddress));
            }
            this.delegate = null;
            int port = proxyAddress.getPort();
            if (port == -1) {
                port = 80;
            }
            this.myProxy = List.of(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyAddress.getHost(), port)));
        }
    }

    @Override
    @ExplodeLoop
    public List<Proxy> select(URI uri) {
        for (NoProxyRule proxyRule : this.noProxyRules) {
            if (!proxyRule.matches(uri)) continue;
            return NO_PROXY;
        }
        if (this.delegate != null) {
            return this.delegate.select(uri);
        }
        assert (this.myProxy != null);
        return this.myProxy;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
    }
}

