/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.http;

import java.io.IOException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.pkl.core.http.HttpClient;

@ThreadSafe
final class LazyHttpClient
implements HttpClient {
    private final Supplier<HttpClient> supplier;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private HttpClient client;
    @GuardedBy(value="lock")
    private RuntimeException exception;

    LazyHttpClient(Supplier<HttpClient> supplier) {
        this.supplier = supplier;
    }

    @Override
    public <T> HttpResponse<T> send(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) throws IOException {
        return this.getOrCreateClient().send(request, responseBodyHandler);
    }

    @Override
    public void close() {
        this.getClient().ifPresent(HttpClient::close);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpClient getOrCreateClient() {
        Object object = this.lock;
        synchronized (object) {
            if (this.exception != null) {
                throw this.exception;
            }
            if (this.client == null) {
                try {
                    this.client = this.supplier.get();
                }
                catch (RuntimeException t) {
                    this.exception = t;
                    throw t;
                }
            }
            return this.client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<HttpClient> getClient() {
        Object object = this.lock;
        synchronized (object) {
            return Optional.ofNullable(this.client);
        }
    }
}

