/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.type;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.source.SourceSection;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.pkl.core.ValueFormatter;
import org.pkl.core.ast.type.TypeNode;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmTypeAlias;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.runtime.VmValueRenderer;
import org.pkl.core.util.ErrorMessages;

public abstract class VmTypeMismatchException
extends ControlFlowException {
    protected final SourceSection sourceSection;
    protected final Object actualValue;

    protected VmTypeMismatchException(SourceSection sourceSection, Object actualValue) {
        this.sourceSection = sourceSection;
        this.actualValue = actualValue;
    }

    @CompilerDirectives.TruffleBoundary
    public abstract void describe(StringBuilder var1, String var2);

    @CompilerDirectives.TruffleBoundary
    public abstract VmException toVmException();

    public static final class Nothing
    extends VmTypeMismatchException {
        public Nothing(SourceSection sourceSection, Object actualValue) {
            super(sourceSection, actualValue);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void describe(StringBuilder builder, String indent) {
            builder.append(ErrorMessages.createIndented("cannotAssignToNothing", indent, VmUtils.getClass(this.actualValue))).append("\n").append(indent).append("Value: ").append(VmValueRenderer.singleLine(80 - indent.length()).render(this.actualValue));
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public VmException toVmException() {
            return this.exceptionBuilder().build();
        }

        private VmExceptionBuilder exceptionBuilder() {
            StringBuilder builder = new StringBuilder();
            this.describe(builder, "");
            return new VmExceptionBuilder().adhocEvalError(builder.toString(), new Object[0]).withSourceSection(this.sourceSection);
        }
    }

    public static final class Union
    extends VmTypeMismatchException {
        private final TypeNode.UnionTypeNode typeCheckNode;
        private final VmTypeMismatchException[] children;

        public Union(SourceSection sourceSection, Object actualValue, TypeNode.UnionTypeNode typeCheckNode, VmTypeMismatchException[] children) {
            super(sourceSection, actualValue);
            this.typeCheckNode = typeCheckNode;
            this.children = children;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void describe(StringBuilder builder, String indent) {
            this.describeSummary(builder, indent);
            this.describeDetails(builder, indent);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public VmException toVmException() {
            return this.exceptionBuilder().build();
        }

        private VmExceptionBuilder exceptionBuilder() {
            StringBuilder summary = new StringBuilder();
            this.describeSummary(summary, "");
            StringBuilder details = new StringBuilder();
            this.describeDetails(details, "");
            return new VmExceptionBuilder().adhocEvalError(summary.toString(), new Object[0]).withSourceSection(this.sourceSection).withHint(details.toString());
        }

        private void describeSummary(StringBuilder builder, String indent) {
            List<Integer> nonTrivialMismatches = this.findNonTrivialMismatches();
            if (nonTrivialMismatches.isEmpty()) {
                if (this.actualValue instanceof VmNull) {
                    builder.append(ErrorMessages.createIndented("typeMismatchValue", indent, this.sourceSection.getCharacters().toString(), "null"));
                } else {
                    builder.append(ErrorMessages.createIndented("typeMismatch", indent, this.sourceSection.getCharacters().toString(), VmUtils.getClass(this.actualValue)));
                }
            } else {
                builder.append(ErrorMessages.createIndented("typeMismatchDifferent", indent, this.sourceSection.getCharacters().toString(), VmUtils.getClass(this.actualValue)));
            }
            builder.append("\n").append(indent).append("Value: ").append(VmValueRenderer.singleLine(80 - indent.length()).render(this.actualValue));
        }

        private void describeDetails(StringBuilder builder, String indent) {
            List<Integer> nonTrivialMismatches = this.findNonTrivialMismatches();
            boolean isPeerError = false;
            for (Integer idx : nonTrivialMismatches) {
                if (!indent.isEmpty() || isPeerError) {
                    builder.append("\n\n");
                }
                isPeerError = true;
                builder.append(ErrorMessages.createIndented("typeMismatchBecause", indent, this.typeCheckNode.elementTypeNodes[idx].getSourceSection().getCharacters().toString())).append("\n");
                this.children[idx].describe(builder, indent + "  ");
            }
        }

        private List<Integer> findNonTrivialMismatches() {
            ArrayList<Integer> result = new ArrayList<Integer>();
            for (int idx = 0; idx < this.children.length; ++idx) {
                VmTypeMismatchException child = this.children[idx];
                if (child instanceof Simple && child.sourceSection == this.typeCheckNode.elementTypeNodes[idx].getSourceSection()) continue;
                result.add(idx);
            }
            return result;
        }
    }

    public static final class Constraint
    extends VmTypeMismatchException {
        public Constraint(SourceSection sourceSection, Object actualValue) {
            super(sourceSection, actualValue);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void describe(StringBuilder builder, String indent) {
            builder.append(ErrorMessages.createIndented("typeConstraintViolated", indent, this.sourceSection.getCharacters().toString())).append("\n").append(indent).append("Value: ").append(VmValueRenderer.singleLine(80 - indent.length()).render(this.actualValue));
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public VmException toVmException() {
            return this.exceptionBuilder().build();
        }

        private VmExceptionBuilder exceptionBuilder() {
            StringBuilder builder = new StringBuilder();
            this.describe(builder, "");
            return new VmExceptionBuilder().adhocEvalError(builder.toString(), new Object[0]).withSourceSection(this.sourceSection);
        }
    }

    public static final class Simple
    extends VmTypeMismatchException {
        private final Object expectedType;

        public Simple(SourceSection sourceSection, Object actualValue, Object expectedType) {
            super(sourceSection, actualValue);
            assert (expectedType instanceof VmClass || expectedType instanceof VmTypeAlias || expectedType instanceof String || expectedType instanceof Set);
            this.expectedType = expectedType;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void describe(StringBuilder builder, String indent) {
            String renderedType;
            ValueFormatter valueFormatter = ValueFormatter.basic();
            Object object = this.expectedType;
            if (object instanceof String) {
                String string = (String)object;
                renderedType = valueFormatter.formatStringValue(string, "");
            } else if (this.expectedType instanceof Set) {
                Set stringLiterals = (Set)this.expectedType;
                renderedType = stringLiterals.stream().map(l -> valueFormatter.formatStringValue((String)l, "")).collect(Collectors.joining("|"));
            } else {
                renderedType = this.expectedType.toString();
            }
            if (this.actualValue instanceof VmNull || this.actualValue instanceof String && this.expectedType instanceof Set) {
                builder.append(ErrorMessages.createIndented("typeMismatchValue", indent, renderedType, new VmException.ProgramValue("", this.actualValue)));
                return;
            }
            Object object2 = this.actualValue;
            if (object2 instanceof VmTyped) {
                VmTyped actualObj = (VmTyped)object2;
                object2 = this.expectedType;
                if (object2 instanceof VmClass) {
                    VmClass expectedClass = (VmClass)object2;
                    VmClass actualClass = actualObj.getVmClass();
                    if (actualClass.getQualifiedName().equals(expectedClass.getQualifiedName())) {
                        URI actualModuleUri = actualClass.getModule().getModuleInfo().getModuleKey().getUri();
                        URI expectedModuleUri = expectedClass.getModule().getModuleInfo().getModuleKey().getUri();
                        builder.append(ErrorMessages.createIndented(actualClass.getPClassInfo().isModuleClass() ? "typeMismatchVersionConflict1" : "typeMismatchVersionConflict2", indent, renderedType, expectedModuleUri, actualModuleUri)).append("\n");
                        return;
                    }
                }
            }
            builder.append(ErrorMessages.createIndented("typeMismatch", indent, renderedType, VmUtils.getClass(this.actualValue))).append("\n").append(indent).append("Value: ").append(VmValueRenderer.singleLine(80 - indent.length()).render(this.actualValue));
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public VmException toVmException() {
            return this.exceptionBuilder().build();
        }

        private VmExceptionBuilder exceptionBuilder() {
            StringBuilder builder = new StringBuilder();
            this.describe(builder, "");
            return new VmExceptionBuilder().adhocEvalError(builder.toString(), new Object[0]).withSourceSection(this.sourceSection);
        }
    }
}

