/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.type;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Set;
import org.pkl.core.TypeParameter;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.PklNode;
import org.pkl.core.ast.expression.primary.GetModuleNode;
import org.pkl.core.ast.type.TypeConstraintNode;
import org.pkl.core.ast.type.TypeNode;
import org.pkl.core.ast.type.TypeNodeFactory;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmTypeAlias;
import org.pkl.core.runtime.VmTyped;

public abstract class UnresolvedTypeNode
extends PklNode {
    protected UnresolvedTypeNode(SourceSection sourceSection) {
        super(sourceSection);
    }

    public abstract TypeNode execute(VirtualFrame var1);

    public static final class TypeVariable
    extends UnresolvedTypeNode {
        private final TypeParameter typeParameter;

        public TypeVariable(SourceSection sourceSection, TypeParameter typeParameter) {
            super(sourceSection);
            this.typeParameter = typeParameter;
        }

        @Override
        public TypeNode execute(VirtualFrame frame) {
            CompilerDirectives.transferToInterpreter();
            return new TypeNode.TypeVariableNode(this.sourceSection, this.typeParameter);
        }
    }

    public static final class Function
    extends UnresolvedTypeNode {
        @Node.Children
        private final UnresolvedTypeNode[] parameterTypeNodes;
        @Node.Child
        private UnresolvedTypeNode returnTypeNode;

        public Function(SourceSection sourceSection, UnresolvedTypeNode[] parameterTypeNodes, UnresolvedTypeNode returnTypeNode) {
            super(sourceSection);
            this.parameterTypeNodes = parameterTypeNodes;
            this.returnTypeNode = returnTypeNode;
        }

        @Override
        @ExplodeLoop
        public TypeNode execute(VirtualFrame frame) {
            CompilerDirectives.transferToInterpreter();
            TypeNode[] parameterTypeNodes = new TypeNode[this.parameterTypeNodes.length];
            for (int i = 0; i < parameterTypeNodes.length; ++i) {
                parameterTypeNodes[i] = this.parameterTypeNodes[i].execute(frame);
            }
            return TypeNodeFactory.FunctionTypeNodeGen.create(this.sourceSection, parameterTypeNodes, this.returnTypeNode.execute(frame));
        }
    }

    public static final class UnionOfStringLiterals
    extends UnresolvedTypeNode {
        private final Set<String> stringLiterals;
        private final int defaultIndex;

        public UnionOfStringLiterals(SourceSection sourceSection, int defaultIndex, Set<String> stringLiterals) {
            super(sourceSection);
            this.stringLiterals = stringLiterals;
            this.defaultIndex = defaultIndex;
        }

        @Override
        public TypeNode execute(VirtualFrame frame) {
            CompilerDirectives.transferToInterpreter();
            return new TypeNode.UnionOfStringLiteralsTypeNode(this.sourceSection, this.defaultIndex, this.stringLiterals);
        }
    }

    public static final class Union
    extends UnresolvedTypeNode {
        @Node.Children
        private final UnresolvedTypeNode[] unresolvedElementTypeNodes;
        private final int defaultIndex;

        public Union(SourceSection sourceSection, int defaultIndex, UnresolvedTypeNode[] elementTypeNodes) {
            super(sourceSection);
            this.unresolvedElementTypeNodes = elementTypeNodes;
            this.defaultIndex = defaultIndex;
        }

        @Override
        @ExplodeLoop
        public TypeNode execute(VirtualFrame frame) {
            CompilerDirectives.transferToInterpreter();
            TypeNode[] elementTypeNodes = new TypeNode[this.unresolvedElementTypeNodes.length];
            boolean skipElementTypeChecks = true;
            for (int i = 0; i < elementTypeNodes.length; ++i) {
                TypeNode elementTypeNode;
                elementTypeNodes[i] = elementTypeNode = this.unresolvedElementTypeNodes[i].execute(frame);
                skipElementTypeChecks &= elementTypeNode.isNoopTypeCheck();
            }
            return new TypeNode.UnionTypeNode(this.sourceSection, this.defaultIndex, elementTypeNodes, skipElementTypeChecks);
        }
    }

    public static final class Nullable
    extends UnresolvedTypeNode {
        @Node.Child
        private UnresolvedTypeNode elementTypeNode;

        public Nullable(SourceSection sourceSection, UnresolvedTypeNode elementTypeNode) {
            super(sourceSection);
            this.elementTypeNode = elementTypeNode;
        }

        @Override
        public TypeNode execute(VirtualFrame frame) {
            CompilerDirectives.transferToInterpreter();
            return TypeNodeFactory.NullableTypeNodeGen.create(this.sourceSection, this.elementTypeNode.execute(frame));
        }
    }

    public static final class Parameterized
    extends UnresolvedTypeNode {
        @Node.Child
        private ExpressionNode resolveTypeNode;
        @Node.Children
        private final UnresolvedTypeNode[] typeArgumentNodes;

        public Parameterized(SourceSection sourceSection, ExpressionNode resolveTypeNode, UnresolvedTypeNode[] typeArgumentNodes) {
            super(sourceSection);
            this.resolveTypeNode = resolveTypeNode;
            this.typeArgumentNodes = typeArgumentNodes;
        }

        @Override
        public TypeNode execute(VirtualFrame frame) {
            CompilerDirectives.transferToInterpreter();
            Object baseType = this.resolveTypeNode.executeGeneric(frame);
            if (baseType instanceof VmClass) {
                VmClass clazz = (VmClass)baseType;
                this.checkNumberOfTypeArguments(clazz);
                if (clazz.isCollectionClass()) {
                    return TypeNodeFactory.CollectionTypeNodeGen.create(this.sourceSection, this.typeArgumentNodes[0].execute(frame));
                }
                if (clazz.isListClass()) {
                    return TypeNodeFactory.ListTypeNodeGen.create(this.sourceSection, this.typeArgumentNodes[0].execute(frame));
                }
                if (clazz.isSetClass()) {
                    return TypeNodeFactory.SetTypeNodeGen.create(this.sourceSection, this.typeArgumentNodes[0].execute(frame));
                }
                if (clazz.isMapClass()) {
                    return TypeNodeFactory.MapTypeNodeGen.create(this.sourceSection, this.typeArgumentNodes[0].execute(frame), this.typeArgumentNodes[1].execute(frame));
                }
                if (clazz.isListingClass()) {
                    return TypeNodeFactory.ListingTypeNodeGen.create(this.sourceSection, this.typeArgumentNodes[0].execute(frame));
                }
                if (clazz.isMappingClass()) {
                    return TypeNodeFactory.MappingTypeNodeGen.create(this.sourceSection, this.typeArgumentNodes[0].execute(frame), this.typeArgumentNodes[1].execute(frame));
                }
                if (clazz.isPairClass()) {
                    return TypeNodeFactory.PairTypeNodeGen.create(this.sourceSection, this.typeArgumentNodes[0].execute(frame), this.typeArgumentNodes[1].execute(frame));
                }
                if (clazz.isFunctionClass()) {
                    return TypeNodeFactory.FunctionClassTypeNodeGen.create(this.sourceSection, this.typeArgumentNodes[0].execute(frame));
                }
                if (clazz.isFunctionNClass()) {
                    int argLength = this.typeArgumentNodes.length;
                    TypeNode[] resolvedTypeArgumentNodes = new TypeNode[argLength];
                    for (int i = 0; i < argLength; ++i) {
                        resolvedTypeArgumentNodes[i] = this.typeArgumentNodes[i].execute(frame);
                    }
                    return TypeNodeFactory.FunctionNClassTypeNodeGen.create(this.sourceSection, resolvedTypeArgumentNodes);
                }
                if (clazz.isClassClass()) {
                    return new TypeNode.FinalClassTypeNode(this.sourceSection, clazz);
                }
                if (clazz.isVarArgsClass()) {
                    return new TypeNode.VarArgsTypeNode(this.sourceSection, this.typeArgumentNodes[0].execute(frame));
                }
                throw this.exceptionBuilder().evalError("notAParameterizableClass", clazz.getDisplayName()).withSourceSection(this.typeArgumentNodes[0].sourceSection).build();
            }
            if (baseType instanceof VmTypeAlias) {
                VmTypeAlias typeAlias = (VmTypeAlias)baseType;
                int argLength = this.typeArgumentNodes.length;
                TypeNode[] resolvedTypeArgumentNodes = new TypeNode[argLength];
                for (int i = 0; i < argLength; ++i) {
                    resolvedTypeArgumentNodes[i] = this.typeArgumentNodes[i].execute(frame);
                }
                return new TypeNode.TypeAliasTypeNode(this.sourceSection, typeAlias, resolvedTypeArgumentNodes);
            }
            VmTyped module = (VmTyped)baseType;
            throw this.exceptionBuilder().evalError("notAParameterizableClass", module.getModuleInfo().getModuleName()).withSourceSection(this.typeArgumentNodes[0].sourceSection).build();
        }

        private void checkNumberOfTypeArguments(VmClass clazz) {
            int actualCount;
            int expectedCount = clazz.getTypeParameterCount();
            if (expectedCount != (actualCount = this.typeArgumentNodes.length)) {
                CompilerDirectives.transferToInterpreter();
                throw this.exceptionBuilder().evalError("wrongTypeArgumentCount", expectedCount, actualCount).build();
            }
        }
    }

    public static final class Declared
    extends UnresolvedTypeNode {
        @Node.Child
        private ExpressionNode resolveTypeNode;

        public Declared(SourceSection sourceSection, ExpressionNode resolveTypeNode) {
            super(sourceSection);
            this.resolveTypeNode = resolveTypeNode;
        }

        @Override
        public TypeNode execute(VirtualFrame frame) {
            CompilerDirectives.transferToInterpreter();
            Object type = this.resolveTypeNode.executeGeneric(frame);
            if (type instanceof VmClass) {
                VmClass clazz = (VmClass)type;
                if (clazz.getModuleName().equals("pkl.base")) {
                    switch (clazz.getSimpleName()) {
                        case "String": {
                            return new TypeNode.StringTypeNode(this.sourceSection);
                        }
                        case "Boolean": {
                            return new TypeNode.BooleanTypeNode(this.sourceSection);
                        }
                        case "Int": {
                            return new TypeNode.IntTypeNode(this.sourceSection);
                        }
                        case "Float": {
                            return new TypeNode.FloatTypeNode(this.sourceSection);
                        }
                        case "Number": {
                            return new TypeNode.NumberTypeNode(this.sourceSection);
                        }
                        case "Any": {
                            return new TypeNode.AnyTypeNode(this.sourceSection);
                        }
                        case "Typed": {
                            return new TypeNode.TypedTypeNode(this.sourceSection);
                        }
                        case "Dynamic": {
                            return new TypeNode.DynamicTypeNode(this.sourceSection);
                        }
                    }
                }
                return TypeNode.forClass(this.sourceSection, clazz);
            }
            if (type instanceof VmTypeAlias) {
                VmTypeAlias alias = (VmTypeAlias)type;
                if (alias.getModuleName().equals("pkl.base")) {
                    switch (alias.getSimpleName()) {
                        case "NonNull": {
                            return new TypeNode.NonNullTypeAliasTypeNode();
                        }
                        case "Int8": {
                            return new TypeNode.Int8TypeAliasTypeNode();
                        }
                        case "UInt8": {
                            return new TypeNode.UIntTypeAliasTypeNode(alias, 255L);
                        }
                        case "Int16": {
                            return new TypeNode.Int16TypeAliasTypeNode();
                        }
                        case "UInt16": {
                            return new TypeNode.UIntTypeAliasTypeNode(alias, 65535L);
                        }
                        case "Int32": {
                            return new TypeNode.Int32TypeAliasTypeNode();
                        }
                        case "UInt32": {
                            return new TypeNode.UIntTypeAliasTypeNode(alias, 0xFFFFFFFFL);
                        }
                        case "UInt": {
                            return new TypeNode.UIntTypeAliasTypeNode(alias, Long.MAX_VALUE);
                        }
                    }
                }
                return new TypeNode.TypeAliasTypeNode(this.sourceSection, alias, new TypeNode[0]);
            }
            VmTyped module = (VmTyped)type;
            assert (module.isModuleObject());
            VmClass clazz = module.getVmClass();
            if (!module.isPrototype()) {
                throw this.exceptionBuilder().evalError("notAModuleType", clazz.getModuleName()).build();
            }
            return TypeNode.forClass(this.sourceSection, module.getVmClass());
        }
    }

    public static final class StringLiteral
    extends UnresolvedTypeNode {
        private final String literal;

        public StringLiteral(SourceSection sourceSection, String literal) {
            super(sourceSection);
            this.literal = literal;
        }

        @Override
        public TypeNode execute(VirtualFrame frame) {
            CompilerDirectives.transferToInterpreter();
            return new TypeNode.StringLiteralTypeNode(this.sourceSection, this.literal);
        }
    }

    public static final class Module
    extends UnresolvedTypeNode {
        @Node.Child
        private ExpressionNode getModuleNode;

        public Module(SourceSection sourceSection) {
            super(sourceSection);
            this.getModuleNode = new GetModuleNode(sourceSection);
        }

        @Override
        public TypeNode execute(VirtualFrame frame) {
            CompilerDirectives.transferToInterpreter();
            VmTyped module = (VmTyped)this.getModuleNode.executeGeneric(frame);
            VmClass moduleClass = module.getVmClass();
            return moduleClass.isClosed() ? new TypeNode.FinalModuleTypeNode(this.sourceSection, moduleClass) : new TypeNode.NonFinalModuleTypeNode(this.sourceSection, moduleClass);
        }
    }

    public static final class Nothing
    extends UnresolvedTypeNode {
        public Nothing(SourceSection sourceSection) {
            super(sourceSection);
        }

        @Override
        public TypeNode execute(VirtualFrame frame) {
            CompilerDirectives.transferToInterpreter();
            return new TypeNode.NothingTypeNode(this.sourceSection);
        }
    }

    public static final class Unknown
    extends UnresolvedTypeNode {
        public Unknown(SourceSection sourceSection) {
            super(sourceSection);
        }

        @Override
        public TypeNode execute(VirtualFrame frame) {
            CompilerDirectives.transferToInterpreter();
            return new TypeNode.UnknownTypeNode(this.sourceSection);
        }
    }

    public static final class Constrained
    extends UnresolvedTypeNode {
        @Node.Child
        UnresolvedTypeNode childNode;
        TypeConstraintNode[] constraintCheckNodes;

        public Constrained(SourceSection sourceSection, UnresolvedTypeNode childNode, TypeConstraintNode[] constraintCheckNodes) {
            super(sourceSection);
            this.childNode = childNode;
            this.constraintCheckNodes = constraintCheckNodes;
        }

        @Override
        public TypeNode execute(VirtualFrame frame) {
            CompilerDirectives.transferToInterpreter();
            return new TypeNode.ConstrainedTypeNode(this.sourceSection, this.childNode.execute(frame), this.constraintCheckNodes);
        }
    }
}

