/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.lambda;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import org.pkl.core.ast.PklNode;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.VmCollection;
import org.pkl.core.runtime.VmFunction;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmPair;

public abstract class ApplyVmFunction2Node
extends PklNode {
    public abstract Object execute(VmFunction var1, Object var2, Object var3);

    public final boolean executeBoolean(VmFunction function, Object arg1, Object arg2) {
        Object result = this.execute(function, arg1, arg2);
        if (result instanceof Boolean) {
            Boolean b2 = (Boolean)result;
            return b2;
        }
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().typeMismatch(result, BaseModule.getBooleanClass()).build();
    }

    public final VmCollection executeCollection(VmFunction function, Object arg1, Object arg2) {
        Object result = this.execute(function, arg1, arg2);
        if (result instanceof VmCollection) {
            VmCollection collection = (VmCollection)result;
            return collection;
        }
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().typeMismatch(result, BaseModule.getCollectionClass()).build();
    }

    public final VmMap executeMap(VmFunction function, Object arg1, Object arg2) {
        Object result = this.execute(function, arg1, arg2);
        if (result instanceof VmMap) {
            VmMap map2 = (VmMap)result;
            return map2;
        }
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().typeMismatch(result, BaseModule.getMapClass()).build();
    }

    public final Long executeInt(VmFunction function, Object arg1, Object arg2) {
        Object result = this.execute(function, arg1, arg2);
        if (result instanceof Long) {
            Long l = (Long)result;
            return l;
        }
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().typeMismatch(result, BaseModule.getIntClass()).build();
    }

    public final VmPair executePair(VmFunction function, Object arg1, Object arg2) {
        Object result = this.execute(function, arg1, arg2);
        if (result instanceof VmPair) {
            VmPair pair = (VmPair)result;
            return pair;
        }
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().typeMismatch(result, BaseModule.getPairClass()).build();
    }

    @Specialization(guards={"function.getCallTarget() == cachedCallTarget"})
    protected Object evalDirect(VmFunction function, Object arg1, Object arg2, @Cached(value="function.getCallTarget()") RootCallTarget cachedCallTarget, @Cached(value="create(cachedCallTarget)") DirectCallNode callNode) {
        return callNode.call(new Object[]{function.getThisValue(), function, arg1, arg2});
    }

    @Specialization(replaces={"evalDirect"})
    protected Object eval(VmFunction function, Object arg1, Object arg2, @Cached(value="create()") IndirectCallNode callNode) {
        return callNode.call((CallTarget)function.getCallTarget(), new Object[]{function.getThisValue(), function, arg1, arg2});
    }
}

