/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.member;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.MemberLookupMode;
import org.pkl.core.ast.member.ClassProperty;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.Nullable;

@NodeInfo(shortName=".")
@ImportStatic(value={BaseModule.class})
@NodeChild(value="receiverNode", type=ExpressionNode.class)
public abstract class ReadPropertyNode
extends ExpressionNode {
    protected final Identifier propertyName;
    private final MemberLookupMode lookupMode;
    private final boolean needsConst;
    @CompilerDirectives.CompilationFinal
    private boolean isConstChecked;

    protected ReadPropertyNode(SourceSection sourceSection, Identifier propertyName, MemberLookupMode lookupMode, boolean needsConst) {
        super(sourceSection);
        this.propertyName = propertyName;
        this.lookupMode = lookupMode;
        this.needsConst = needsConst;
        assert (!propertyName.isLocalProp()) : "Must use ReadLocalPropertyNode for local properties.";
    }

    protected ReadPropertyNode(SourceSection sourceSection, Identifier propertyName, boolean needsConst) {
        this(sourceSection, propertyName, MemberLookupMode.EXPLICIT_RECEIVER, needsConst);
    }

    protected ReadPropertyNode(SourceSection sourceSection, Identifier propertyName) {
        this(sourceSection, propertyName, MemberLookupMode.EXPLICIT_RECEIVER, false);
    }

    @Specialization(guards={"receiver.getClass() == cachedClass"}, limit="99")
    protected Object evalObject(Object receiver, @Cached(value="getVmObjectSubclassOrNull(receiver)") Class<? extends VmObjectLike> cachedClass, @Cached(value="create()") IndirectCallNode callNode) {
        VmObjectLike object = cachedClass.cast(receiver);
        this.checkConst(object);
        Object result = VmUtils.readMemberOrNull(object, this.propertyName, true, callNode);
        if (result != null) {
            return result;
        }
        CompilerDirectives.transferToInterpreter();
        throw this.cannotFindProperty(object);
    }

    @Specialization(guards={"receiver.getClass() == cachedClass"}, limit="99")
    protected Object evalOther(Object receiver, @Cached(value="receiver.getClass()") Class<?> cachedClass, @Cached(value="resolveProperty(receiver)") ClassProperty resolvedProperty, @Cached(value="createCallNode(resolvedProperty)") DirectCallNode callNode) {
        return callNode.call(new Object[]{receiver, resolvedProperty.getOwner(), resolvedProperty.getName()});
    }

    @Nullable
    protected static Class<? extends VmObjectLike> getVmObjectSubclassOrNull(Object value2) {
        Class<?> clazz;
        if (value2 instanceof VmObjectLike) {
            VmObjectLike objectLike = (VmObjectLike)value2;
            clazz = objectLike.getClass();
        } else {
            clazz = null;
        }
        return clazz;
    }

    protected ClassProperty resolveProperty(Object value2) {
        VmClass clazz = VmUtils.getClass(value2);
        ClassProperty propertyDef = clazz.getProperty(this.propertyName);
        if (propertyDef != null) {
            return propertyDef;
        }
        CompilerDirectives.transferToInterpreter();
        throw this.cannotFindProperty(clazz.getPrototype());
    }

    protected static DirectCallNode createCallNode(ClassProperty resolvedProperty) {
        RootCallTarget callTarget = resolvedProperty.getInitializer().getCallTarget();
        return DirectCallNode.create((CallTarget)callTarget);
    }

    @CompilerDirectives.TruffleBoundary
    private VmException cannotFindProperty(VmObjectLike receiver) {
        return this.exceptionBuilder().cannotFindProperty(receiver, this.propertyName, true, this.lookupMode != MemberLookupMode.EXPLICIT_RECEIVER).build();
    }

    private void checkConst(VmObjectLike receiver) {
        if (this.needsConst && !this.isConstChecked) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            ClassProperty property = receiver.getVmClass().getProperty(this.propertyName);
            if (property == null) {
                return;
            }
            if (!property.isConst()) {
                throw this.exceptionBuilder().evalError("propertyMustBeConst", this.propertyName.toString()).build();
            }
            this.isConstChecked = true;
        }
    }
}

