/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.generator;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Map;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.expression.generator.GeneratorMemberNode;
import org.pkl.core.ast.member.ClassProperty;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmCollection;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmIntSeq;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmObject;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.MutableLong;

@ImportStatic(value={BaseModule.class})
public abstract class GeneratorSpreadNode
extends GeneratorMemberNode {
    @Node.Child
    private ExpressionNode iterableNode;
    private final boolean nullable;

    public GeneratorSpreadNode(SourceSection sourceSection, ExpressionNode iterableNode, boolean nullable2) {
        super(sourceSection);
        this.iterableNode = iterableNode;
        this.nullable = nullable2;
    }

    protected abstract void executeWithIterable(VirtualFrame var1, Object var2, GeneratorMemberNode.ObjectData var3, Object var4);

    @Override
    public final void execute(VirtualFrame frame, Object parent, GeneratorMemberNode.ObjectData data) {
        this.executeWithIterable(frame, parent, data, this.iterableNode.executeGeneric(frame));
    }

    @Specialization
    protected void eval(VmObject parent, GeneratorMemberNode.ObjectData data, VmNull iterable) {
        if (this.nullable) {
            return;
        }
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().evalError("cannotIterateOverThisValue", BaseModule.getNullClass()).withLocation(this.iterableNode).withHint("To guard against a nullable value, use `...?` instead of `...`.\nTry: `...?" + this.iterableNode.getSourceSection().getCharacters() + "`").build();
    }

    @Specialization(guards={"!iterable.isTyped()"})
    protected void eval(VmDynamic parent, GeneratorMemberNode.ObjectData data, VmObject iterable) {
        this.doEvalDynamic(data, iterable);
    }

    @Specialization(guards={"!iterable.isTyped()"})
    protected void eval(VmListing parent, GeneratorMemberNode.ObjectData data, VmObject iterable) {
        this.doEvalListing(data, iterable);
    }

    @Specialization(guards={"!iterable.isTyped()"})
    protected void eval(VmMapping parent, GeneratorMemberNode.ObjectData data, VmObject iterable) {
        this.doEvalMapping(data, iterable);
    }

    @Specialization(guards={"parent == getDynamicClass()", "!iterable.isTyped()"})
    protected void evalDynamicClass(VmClass parent, GeneratorMemberNode.ObjectData data, VmObject iterable) {
        this.doEvalDynamic(data, iterable);
    }

    @Specialization(guards={"parent == getListingClass()", "!iterable.isTyped()"})
    protected void evalListingClass(VmClass parent, GeneratorMemberNode.ObjectData data, VmObject iterable) {
        this.doEvalListing(data, iterable);
    }

    @Specialization(guards={"parent == getMappingClass()", "!iterable.isTyped()"})
    protected void evalMappingClass(VmClass parent, GeneratorMemberNode.ObjectData data, VmObject iterable) {
        this.doEvalMapping(data, iterable);
    }

    @Specialization(guards={"isTypedObjectClass(parent)", "!iterable.isTyped()"})
    protected void evalTypedClass(VmClass parent, GeneratorMemberNode.ObjectData data, VmObject iterable) {
        this.doEvalTyped(parent, data, iterable);
    }

    @Specialization(guards={"!iterable.isTyped()"})
    protected void eval(VmTyped parent, GeneratorMemberNode.ObjectData data, VmObject iterable) {
        this.doEvalTyped(parent.getVmClass(), data, iterable);
    }

    @Specialization
    protected void eval(VmObject parent, GeneratorMemberNode.ObjectData data, VmMap iterable) {
        this.doEvalMap(parent.getVmClass(), data, iterable);
    }

    @Specialization
    protected void eval(VmClass parent, GeneratorMemberNode.ObjectData data, VmMap iterable) {
        this.doEvalMap(parent, data, iterable);
    }

    @Specialization
    protected void eval(VmObject parent, GeneratorMemberNode.ObjectData data, VmCollection iterable) {
        this.doEvalCollection(parent.getVmClass(), data, iterable);
    }

    @Specialization
    protected void eval(VmClass parent, GeneratorMemberNode.ObjectData data, VmCollection iterable) {
        this.doEvalCollection(parent, data, iterable);
    }

    @Specialization
    protected void eval(VmObject parent, GeneratorMemberNode.ObjectData data, VmIntSeq iterable) {
        this.doEvalIntSeq(parent.getVmClass(), data, iterable);
    }

    @Specialization
    protected void eval(VmClass parent, GeneratorMemberNode.ObjectData data, VmIntSeq iterable) {
        this.doEvalIntSeq(parent, data, iterable);
    }

    @Fallback
    protected void fallback(VirtualFrame frame, Object parent, GeneratorMemberNode.ObjectData data, Object iterable) {
        VmObject vmObject;
        CompilerDirectives.transferToInterpreter();
        VmExceptionBuilder builder = this.exceptionBuilder().evalError("cannotIterateOverThisValue", VmUtils.getClass(iterable)).withLocation(this.iterableNode).withProgramValue("Value", iterable);
        if (iterable instanceof VmObject && (vmObject = (VmObject)iterable).isTyped()) {
            builder.withHint("`Typed` values are not iterable. If you mean to spread its members, convert it to `Dynamic` using `toDynamic()`.");
        }
        throw builder.build();
    }

    protected void doEvalDynamic(GeneratorMemberNode.ObjectData data, VmObject iterable) {
        MutableLong length2 = new MutableLong(data.length);
        iterable.forceAndIterateMemberValues((key2, member, value2) -> {
            if (member.isElement()) {
                EconomicMaps.put(data.members, length2.getAndIncrement(), this.createMember(member, value2));
            } else if (EconomicMaps.put(data.members, key2, this.createMember(member, value2)) != null) {
                this.duplicateMember(key2, member);
            }
            return true;
        });
        data.length = (int)length2.get();
    }

    private void doEvalMapping(GeneratorMemberNode.ObjectData data, VmObject iterable) {
        iterable.forceAndIterateMemberValues((key2, member, value2) -> {
            if (member.isElement() || member.isProp()) {
                this.cannotHaveMember(BaseModule.getMappingClass(), member);
            }
            if (EconomicMaps.put(data.members, key2, this.createMember(member, value2)) != null) {
                this.duplicateMember(key2, member);
            }
            return true;
        });
    }

    private void doEvalListing(GeneratorMemberNode.ObjectData data, VmObject iterable) {
        MutableLong length2 = new MutableLong(data.length);
        iterable.forceAndIterateMemberValues((key2, member, value2) -> {
            if (member.isEntry() || member.isProp()) {
                this.cannotHaveMember(BaseModule.getListingClass(), member);
            }
            EconomicMaps.put(data.members, length2.getAndIncrement(), this.createMember(member, value2));
            return true;
        });
        data.length = (int)length2.get();
    }

    private void doEvalTyped(VmClass clazz, GeneratorMemberNode.ObjectData data, VmObject iterable) {
        iterable.forceAndIterateMemberValues((key2, member, value2) -> {
            if (member.isElement() || member.isEntry()) {
                this.cannotHaveMember(clazz, member);
            }
            this.checkTypedProperty(clazz, member);
            if (EconomicMaps.put(data.members, key2, this.createMember(member, value2)) != null) {
                this.duplicateMember(key2, member);
            }
            return true;
        });
    }

    private void doEvalCollection(VmClass parent, GeneratorMemberNode.ObjectData data, VmCollection iterable) {
        if (GeneratorSpreadNode.isTypedObjectClass(parent) || parent == BaseModule.getMappingClass()) {
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().evalError("cannotSpreadObject", iterable.getVmClass(), parent).withHint("`List` and `Set` can only be spread into objects of type `Dynamic` and `Listing`.").withProgramValue("Value", iterable).build();
        }
        this.spreadIterable(data, iterable);
    }

    private void doEvalMap(VmClass parent, GeneratorMemberNode.ObjectData data, VmMap iterable) {
        if (GeneratorSpreadNode.isTypedObjectClass(parent) || parent == BaseModule.getListingClass()) {
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().evalError("cannotSpreadObject", iterable.getVmClass(), parent).withHint("`Map` can only be spread into objects of type `Dynamic` and `Mapping`.").withProgramValue("Value", iterable).build();
        }
        for (Map.Entry<Object, Object> entry : iterable) {
            ObjectMember member = VmUtils.createSyntheticObjectEntry("", VmUtils.getValue(entry));
            if (EconomicMaps.put(data.members, VmUtils.getKey(entry), member) == null) continue;
            this.duplicateMember(VmUtils.getKey(entry), member);
        }
    }

    private void doEvalIntSeq(VmClass parent, GeneratorMemberNode.ObjectData data, VmIntSeq iterable) {
        if (GeneratorSpreadNode.isTypedObjectClass(parent) || parent == BaseModule.getMappingClass()) {
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().evalError("cannotSpreadObject", iterable.getVmClass(), parent).withHint("`IntSeq` can only be spread into objects of type `Dynamic` and `Listing`.").withProgramValue("Value", iterable).build();
        }
        this.spreadIterable(data, iterable);
    }

    private void cannotHaveMember(VmClass clazz, ObjectMember member) {
        CompilerDirectives.transferToInterpreter();
        VmExceptionBuilder builder = this.exceptionBuilder();
        if (member.isEntry()) {
            builder.evalError("objectCannotHaveSpreadEntry", clazz);
        } else if (member.isElement()) {
            builder.evalError("objectCannotHaveSpreadElement", clazz);
        } else {
            builder.evalError("objectCannotHaveSpreadProperty", clazz);
        }
        VmException exception = builder.build();
        if (member.getHeaderSection().isAvailable()) {
            exception.getInsertedStackFrames().put((CallTarget)this.getRootNode().getCallTarget(), VmUtils.createStackFrame(member.getHeaderSection(), member.getQualifiedName()));
        }
        throw exception;
    }

    private void duplicateMember(Object key2, ObjectMember member) {
        CompilerDirectives.transferToInterpreter();
        VmException exception = this.exceptionBuilder().evalError(member.isProp() ? "objectSpreadDuplicateProperty" : "objectSpreadDuplicateEntry", key2 instanceof Identifier ? key2 : new VmException.ProgramValue("", key2)).build();
        if (member.getHeaderSection().isAvailable()) {
            exception.getInsertedStackFrames().put((CallTarget)this.getRootNode().getCallTarget(), VmUtils.createStackFrame(member.getHeaderSection(), member.getQualifiedName()));
        }
        throw exception;
    }

    private ObjectMember createMember(ObjectMember prototype, Object value2) {
        if (prototype.getConstantValue() == value2) {
            return prototype;
        }
        ObjectMember result = new ObjectMember(prototype.getSourceSection(), prototype.getHeaderSection(), prototype.getModifiers(), prototype.getNameOrNull(), prototype.getQualifiedName());
        result.initConstantValue(value2);
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    private void spreadIterable(GeneratorMemberNode.ObjectData data, Iterable<?> iterable) {
        int length2 = data.length;
        for (Object elem : iterable) {
            int index = length2++;
            ObjectMember member = VmUtils.createSyntheticObjectElement(String.valueOf(index), elem);
            EconomicMaps.put(data.members, Long.valueOf(index), member);
        }
        data.length = length2;
    }

    protected void checkTypedProperty(VmClass clazz, ObjectMember member) {
        if (member.isLocal()) {
            return;
        }
        Identifier memberName = member.getName();
        ClassProperty classProperty = clazz.getProperty(memberName);
        if (classProperty == null) {
            CompilerDirectives.transferToInterpreter();
            VmException exception = this.exceptionBuilder().cannotFindProperty(clazz.getPrototype(), memberName, false, false).build();
            if (member.getHeaderSection().isAvailable()) {
                exception.getInsertedStackFrames().put((CallTarget)this.getRootNode().getCallTarget(), VmUtils.createStackFrame(member.getHeaderSection(), member.getQualifiedName()));
            }
            throw exception;
        }
        if (classProperty.isConstOrFixed()) {
            CompilerDirectives.transferToInterpreter();
            String errMsg = classProperty.isConst() ? "cannotAssignConstProperty" : "cannotAssignFixedProperty";
            VmException exception = this.exceptionBuilder().evalError(errMsg, memberName).build();
            if (member.getHeaderSection().isAvailable()) {
                exception.getInsertedStackFrames().put((CallTarget)this.getRootNode().getCallTarget(), VmUtils.createStackFrame(member.getHeaderSection(), member.getQualifiedName()));
            }
            throw exception;
        }
    }
}

