/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.generator;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.UnmodifiableMapCursor;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.builder.SymbolTable;
import org.pkl.core.ast.expression.generator.GeneratorMemberNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmObject;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.EconomicSets;

public abstract class GeneratorPredicateMemberNode
extends GeneratorMemberNode {
    @Node.Child
    private ExpressionNode predicateNode;
    private final ObjectMember member;
    @CompilerDirectives.CompilationFinal
    private int customThisSlot = -1;

    protected GeneratorPredicateMemberNode(ExpressionNode predicateNode, ObjectMember member) {
        super(member.getSourceSection());
        this.predicateNode = predicateNode;
        this.member = member;
    }

    @Specialization
    protected void evalDynamic(VirtualFrame frame, VmDynamic parent, GeneratorMemberNode.ObjectData data) {
        this.addMembers(frame, parent, data);
    }

    @Specialization
    protected void evalMapping(VirtualFrame frame, VmMapping parent, GeneratorMemberNode.ObjectData data) {
        this.addMembers(frame, parent, data);
    }

    @Specialization
    protected void evalListing(VirtualFrame frame, VmListing parent, GeneratorMemberNode.ObjectData data) {
        this.addMembers(frame, parent, data);
    }

    @Fallback
    void fallback(Object parent, GeneratorMemberNode.ObjectData data) {
        if (parent == BaseModule.getDynamicClass() || parent == BaseModule.getMappingClass() || parent == BaseModule.getListingClass()) {
            return;
        }
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().evalError("objectCannotHavePredicateMember", parent instanceof VmClass ? parent : VmUtils.getClass(parent)).withLocation(this.predicateNode).build();
    }

    private void addMembers(VirtualFrame frame, VmObject parent, GeneratorMemberNode.ObjectData data) {
        this.initThisSlot(frame);
        Object previousValue = frame.getAuxiliarySlot(this.customThisSlot);
        EconomicSet visitedKeys = EconomicSets.create();
        for (VmObject owner = parent; owner != null; owner = owner.getParent()) {
            UnmodifiableMapCursor<Object, ObjectMember> entries2 = EconomicMaps.getEntries(owner.getMembers());
            while (entries2.advance()) {
                ObjectMember member;
                Object key2 = entries2.getKey();
                if (!EconomicSets.add(visitedKeys, key2) || (member = (ObjectMember)entries2.getValue()).isProp() || member.isLocal()) continue;
                Object value2 = owner.getCachedValue(key2);
                if (value2 == null) {
                    Object constantValue = member.getConstantValue();
                    if (constantValue != null) {
                        value2 = constantValue;
                    } else {
                        RootCallTarget callTarget = member.getCallTarget();
                        value2 = callTarget.call(new Object[]{parent, owner, key2});
                    }
                    owner.setCachedValue(key2, value2);
                }
                frame.setAuxiliarySlot(this.customThisSlot, value2);
                try {
                    boolean isApplicable = this.predicateNode.executeBoolean(frame);
                    if (!isApplicable) continue;
                    this.doAdd(key2, data);
                }
                catch (UnexpectedResultException e2) {
                    CompilerDirectives.transferToInterpreter();
                    throw this.exceptionBuilder().typeMismatch(e2.getResult(), BaseModule.getBooleanClass()).withLocation(this.predicateNode).build();
                }
            }
        }
        frame.setAuxiliarySlot(this.customThisSlot, previousValue);
    }

    private void initThisSlot(VirtualFrame frame) {
        if (this.customThisSlot == -1) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.customThisSlot = frame.getFrameDescriptor().findOrAddAuxiliarySlot(SymbolTable.CustomThisScope.FRAME_SLOT_ID);
        }
    }

    private void doAdd(Object key2, GeneratorMemberNode.ObjectData data) {
        if (EconomicMaps.put(data.members, key2, this.member) != null) {
            CompilerDirectives.transferToInterpreter();
            throw this.duplicateDefinition(key2, this.member);
        }
        data.persistForBindings(key2);
    }
}

