/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.expression.binary.BinaryExpressionNode;
import org.pkl.core.runtime.VmCollection;
import org.pkl.core.runtime.VmDataSize;
import org.pkl.core.runtime.VmDuration;
import org.pkl.core.runtime.VmMap;

@NodeInfo(shortName="+")
public abstract class AdditionNode
extends BinaryExpressionNode {
    protected AdditionNode(SourceSection sourceSection) {
        super(sourceSection);
    }

    @Specialization
    @CompilerDirectives.TruffleBoundary
    protected String eval(String left, String right) {
        return left + right;
    }

    @Specialization
    protected long eval(long left, long right) {
        try {
            return StrictMath.addExact(left, right);
        }
        catch (ArithmeticException e2) {
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().evalError("integerOverflow", new Object[0]).build();
        }
    }

    @Specialization
    protected double eval(long left, double right) {
        return (double)left + right;
    }

    @Specialization
    protected double eval(double left, long right) {
        return left + (double)right;
    }

    @Specialization
    protected double eval(double left, double right) {
        return left + right;
    }

    @Specialization
    protected VmDuration eval(VmDuration left, VmDuration right) {
        return left.add(right);
    }

    @Specialization
    protected VmDataSize eval(VmDataSize left, VmDataSize right) {
        return left.add(right);
    }

    @Specialization
    protected VmCollection eval(VmCollection left, VmCollection right) {
        return left.concatenate(right);
    }

    @Specialization
    protected VmMap eval(VmMap left, VmMap right) {
        return left.concatenate(right);
    }
}

