/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmStackOverflowException;
import org.pkl.core.runtime.VmTypes;
import org.pkl.core.util.Nullable;

@NodeInfo(language="Pkl")
@TypeSystemReference(value=VmTypes.class)
public abstract class PklRootNode
extends RootNode {
    protected PklRootNode(@Nullable VmLanguage language, FrameDescriptor descriptor) {
        super((TruffleLanguage)language, descriptor);
    }

    public abstract SourceSection getSourceSection();

    @Nullable
    public abstract String getName();

    protected final Object executeBody(VirtualFrame frame, ExpressionNode bodyNode) {
        try {
            return bodyNode.executeGeneric(frame);
        }
        catch (VmException e2) {
            CompilerDirectives.transferToInterpreter();
            throw e2;
        }
        catch (StackOverflowError e3) {
            CompilerDirectives.transferToInterpreter();
            throw new VmStackOverflowException(e3);
        }
        catch (Exception e4) {
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().bug(e4.getMessage(), new Object[0]).withCause(e4).build();
        }
    }

    protected VmExceptionBuilder exceptionBuilder() {
        return new VmExceptionBuilder().withLocation((Node)this);
    }
}

