/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.util;

import java.util.Arrays;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class StringSimilarity {
    private static final double DEFAULT_THRESHOLD = 0.7;
    private static final int THREE = 3;
    private static final double JW_COEF = 0.1;
    private final double threshold;

    public StringSimilarity() {
        this.threshold = 0.7;
    }

    public StringSimilarity(double threshold) {
        this.threshold = threshold;
    }

    public final double getThreshold() {
        return this.threshold;
    }

    public final double similarity(String s1, String s2) {
        double j;
        if (s1.equals(s2)) {
            return 1.0;
        }
        int[] mtp = this.matches(s1, s2);
        double m = mtp[0];
        if (m == 0.0) {
            return m;
        }
        double jw = j = (m / (double)s1.length() + m / (double)s2.length() + (m - (double)mtp[1]) / m) / 3.0;
        if (j > this.getThreshold()) {
            jw = j + Math.min(0.1, 1.0 / (double)mtp[3]) * (double)mtp[2] * (1.0 - j);
        }
        return jw;
    }

    public final double distance(String s1, String s2) {
        return 1.0 - this.similarity(s1, s2);
    }

    private int[] matches(String s1, String s2) {
        int i;
        String min2;
        String max2;
        if (s1.length() > s2.length()) {
            max2 = s1;
            min2 = s2;
        } else {
            max2 = s2;
            min2 = s1;
        }
        int range = Math.max(max2.length() / 2 - 1, 0);
        int[] matchIndexes = new int[min2.length()];
        Arrays.fill(matchIndexes, -1);
        boolean[] matchFlags = new boolean[max2.length()];
        int matches2 = 0;
        block0: for (int mi = 0; mi < min2.length(); ++mi) {
            char c1 = min2.charAt(mi);
            int xn = Math.min(mi + range + 1, max2.length());
            for (int xi = Math.max(mi - range, 0); xi < xn; ++xi) {
                if (matchFlags[xi] || c1 != max2.charAt(xi)) continue;
                matchIndexes[mi] = xi;
                matchFlags[xi] = true;
                ++matches2;
                continue block0;
            }
        }
        char[] ms1 = new char[matches2];
        char[] ms2 = new char[matches2];
        int si = 0;
        for (i = 0; i < min2.length(); ++i) {
            if (matchIndexes[i] == -1) continue;
            ms1[si] = min2.charAt(i);
            ++si;
        }
        si = 0;
        for (i = 0; i < max2.length(); ++i) {
            if (!matchFlags[i]) continue;
            ms2[si] = max2.charAt(i);
            ++si;
        }
        int transpositions = 0;
        for (int mi = 0; mi < ms1.length; ++mi) {
            if (ms1[mi] == ms2[mi]) continue;
            ++transpositions;
        }
        int prefix = 0;
        for (int mi = 0; mi < min2.length() && s1.charAt(mi) == s2.charAt(mi); ++mi) {
            ++prefix;
        }
        return new int[]{matches2, transpositions / 2, prefix, max2.length()};
    }
}

