/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import org.pkl.core.PNull;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmValue;
import org.pkl.core.runtime.VmValueConverter;
import org.pkl.core.runtime.VmValueVisitor;
import org.pkl.core.util.Nullable;

@CompilerDirectives.ValueType
public final class VmNull
extends VmValue {
    private static final VmNull WITHOUT_DEFAULT = new VmNull(null);
    @Nullable
    private final Object defaultValue;

    public static VmNull withoutDefault() {
        return WITHOUT_DEFAULT;
    }

    public static VmNull withDefault(@Nullable Object defaultValue) {
        return defaultValue == null ? VmNull.withoutDefault() : new VmNull(defaultValue);
    }

    public static Object lift(@Nullable Object nullable2) {
        return nullable2 == null ? VmNull.withoutDefault() : nullable2;
    }

    @Nullable
    public static Object unwrap(Object value2) {
        return value2 instanceof VmNull ? null : value2;
    }

    private VmNull(@Nullable Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Object getDefaultValue() {
        return this.defaultValue == null ? VmDynamic.empty() : this.defaultValue;
    }

    public boolean isMappingDefault() {
        return this.defaultValue instanceof VmMapping;
    }

    @Override
    public VmClass getVmClass() {
        return BaseModule.getNullClass();
    }

    @Override
    public void force(boolean allowUndefinedValues) {
    }

    @Override
    public Object export() {
        return PNull.getInstance();
    }

    @Override
    public void accept(VmValueVisitor visitor) {
        visitor.visitNull(this);
    }

    @Override
    public <T> T accept(VmValueConverter<T> converter, Iterable<Object> path) {
        return converter.convertNull(this, path);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return obj instanceof VmNull;
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return "null";
    }
}

