/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.Map;
import org.pkl.core.Duration;
import org.pkl.core.DurationUnit;
import org.pkl.core.Value;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmValue;
import org.pkl.core.runtime.VmValueConverter;
import org.pkl.core.runtime.VmValueVisitor;
import org.pkl.core.util.DurationUtils;
import org.pkl.core.util.Nullable;

@CompilerDirectives.ValueType
public final class VmDuration
extends VmValue
implements Comparable<VmDuration> {
    private static final Map<Identifier, DurationUnit> UNITS = Map.of(Identifier.NS, DurationUnit.NANOS, Identifier.US, DurationUnit.MICROS, Identifier.MS, DurationUnit.MILLIS, Identifier.S, DurationUnit.SECONDS, Identifier.MIN, DurationUnit.MINUTES, Identifier.H, DurationUnit.HOURS, Identifier.D, DurationUnit.DAYS);
    private final double value;
    private final DurationUnit unit;

    public VmDuration(double value2, DurationUnit unit2) {
        this.value = value2;
        this.unit = unit2;
    }

    @Nullable
    public static DurationUnit toUnit(Identifier identifier) {
        return UNITS.get(identifier);
    }

    @Override
    public VmClass getVmClass() {
        return BaseModule.getDurationClass();
    }

    public VmDuration add(VmDuration other) {
        if (this.unit.ordinal() <= other.unit.ordinal()) {
            return new VmDuration(this.getValue(other.unit) + other.value, other.unit);
        }
        return new VmDuration(this.value + other.getValue(this.unit), this.unit);
    }

    public VmDuration subtract(VmDuration other) {
        if (this.unit.ordinal() <= other.unit.ordinal()) {
            return new VmDuration(this.getValue(other.unit) - other.value, other.unit);
        }
        return new VmDuration(this.value - other.getValue(this.unit), this.unit);
    }

    public double getValue() {
        return this.value;
    }

    public double getValue(DurationUnit other) {
        return this.value * (double)this.unit.getNanos() / (double)other.getNanos();
    }

    public DurationUnit getUnit() {
        return this.unit;
    }

    public VmDuration multiply(double num) {
        return new VmDuration(this.value * num, this.unit);
    }

    public VmDuration divide(double num) {
        return new VmDuration(this.value / num, this.unit);
    }

    public double divide(VmDuration other) {
        if (this.unit.ordinal() <= other.unit.ordinal()) {
            return this.getValue(other.unit) / other.value;
        }
        return this.value / other.getValue(this.unit);
    }

    public VmDuration remainder(double num) {
        return new VmDuration(this.value % num, this.unit);
    }

    public VmDuration pow(double num) {
        return new VmDuration(StrictMath.pow(this.value, num), this.unit);
    }

    public VmDuration round() {
        return new VmDuration(StrictMath.rint(this.value), this.unit);
    }

    public VmDuration convertTo(DurationUnit unit2) {
        return new VmDuration(this.getValue(unit2), unit2);
    }

    @Override
    public void force(boolean allowUndefinedValues) {
    }

    @Override
    public Value export() {
        return new Duration(this.value, this.unit);
    }

    @Override
    public void accept(VmValueVisitor visitor) {
        visitor.visitDuration(this);
    }

    @Override
    public <T> T accept(VmValueConverter<T> converter, Iterable<Object> path) {
        return converter.convertDuration(this, path);
    }

    @Override
    public int compareTo(VmDuration other) {
        if (this.unit.ordinal() <= other.unit.ordinal()) {
            return Double.compare(this.getValue(other.unit), other.value);
        }
        return Double.compare(this.value, other.getValue(this.unit));
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VmDuration)) {
            return false;
        }
        VmDuration other = (VmDuration)obj;
        return this.getValue(DurationUnit.NANOS) == other.getValue(DurationUnit.NANOS);
    }

    public int hashCode() {
        return Double.hashCode(this.getValue(DurationUnit.NANOS));
    }

    public String toString() {
        return DurationUtils.toPklString(this.value, this.unit);
    }
}

