/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.ConnectException;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManagerFactory;
import org.pkl.core.http.HttpClient;
import org.pkl.core.http.HttpClientInitException;
import org.pkl.core.util.ErrorMessages;
import org.pkl.core.util.Exceptions;

@ThreadSafe
final class JdkHttpClient
implements HttpClient {
    final java.net.http.HttpClient underlying;
    private static final MethodHandle closeMethod;

    JdkHttpClient(List<Path> certificateFiles, List<ByteBuffer> certificateBytes, Duration connectTimeout, ProxySelector proxySelector) {
        this.underlying = java.net.http.HttpClient.newBuilder().sslContext(JdkHttpClient.createSslContext(certificateFiles, certificateBytes)).connectTimeout(connectTimeout).proxy(proxySelector).followRedirects(HttpClient.Redirect.NORMAL).build();
    }

    @Override
    public <T> HttpResponse<T> send(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) throws IOException {
        try {
            return this.underlying.send(request, responseBodyHandler);
        }
        catch (ConnectException e2) {
            throw new ConnectException(ErrorMessages.create("errorConnectingToHost", request.uri().getHost()));
        }
        catch (SSLHandshakeException e3) {
            throw new SSLHandshakeException(ErrorMessages.create("errorSslHandshake", request.uri().getHost(), Exceptions.getRootReason(e3)));
        }
        catch (SSLException e4) {
            throw new SSLException(Exceptions.getRootReason(e4));
        }
        catch (InterruptedException e5) {
            Thread.currentThread().interrupt();
            throw new IOException(e5);
        }
    }

    @Override
    public void close() {
        try {
            closeMethod.invoke(this.underlying);
        }
        catch (Error | RuntimeException e2) {
            throw e2;
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    private static SSLContext createSslContext(List<Path> certificateFiles, List<ByteBuffer> certificateBytes) {
        try {
            if (certificateFiles.isEmpty() && certificateBytes.isEmpty()) {
                return SSLContext.getDefault();
            }
            CertPathBuilder certPathBuilder = CertPathBuilder.getInstance("PKIX");
            PKIXRevocationChecker revocationChecker = (PKIXRevocationChecker)certPathBuilder.getRevocationChecker();
            revocationChecker.setOptions(Set.of());
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            Set<TrustAnchor> trustAnchors = JdkHttpClient.createTrustAnchors(certFactory, certificateFiles, certificateBytes);
            PKIXBuilderParameters pkixParameters = new PKIXBuilderParameters(trustAnchors, (CertSelector)new X509CertSelector());
            pkixParameters.setRevocationEnabled(true);
            pkixParameters.addCertPathChecker(revocationChecker);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
            trustManagerFactory.init(new CertPathTrustManagerParameters(pkixParameters));
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustManagerFactory.getTrustManagers(), new SecureRandom());
            return sslContext;
        }
        catch (GeneralSecurityException e2) {
            throw new HttpClientInitException(ErrorMessages.create("cannotInitHttpClient", Exceptions.getRootReason(e2)), e2);
        }
    }

    private static Set<TrustAnchor> createTrustAnchors(CertificateFactory factory, List<Path> certificateFiles, List<ByteBuffer> certificateBytes) {
        InputStream stream;
        HashSet<TrustAnchor> anchors = new HashSet<TrustAnchor>();
        for (Path file : certificateFiles) {
            try {
                stream = Files.newInputStream(file, new OpenOption[0]);
                try {
                    JdkHttpClient.collectTrustAnchors(anchors, factory, stream, file);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (NoSuchFileException e2) {
                throw new HttpClientInitException(ErrorMessages.create("cannotFindCertFile", file));
            }
            catch (IOException e3) {
                throw new HttpClientInitException(ErrorMessages.create("cannotReadCertFile", Exceptions.getRootReason(e3)));
            }
        }
        for (ByteBuffer byteBuffer : certificateBytes) {
            stream = new ByteArrayInputStream(byteBuffer.array());
            JdkHttpClient.collectTrustAnchors(anchors, factory, stream, "<unavailable>");
        }
        return anchors;
    }

    private static void collectTrustAnchors(Collection<TrustAnchor> anchors, CertificateFactory factory, InputStream stream, Object source) {
        Collection<? extends Certificate> certificates;
        try {
            certificates = factory.generateCertificates(stream);
        }
        catch (CertificateException e2) {
            throw new HttpClientInitException(ErrorMessages.create("cannotParseCertFile", source, Exceptions.getRootReason(e2)));
        }
        if (certificates.isEmpty()) {
            throw new HttpClientInitException(ErrorMessages.create("emptyCertFile", source));
        }
        for (X509Certificate x509Certificate : certificates) {
            anchors.add(new TrustAnchor(x509Certificate, null));
        }
    }

    static {
        MethodHandle result;
        MethodType methodType = MethodType.methodType(Void.TYPE, java.net.http.HttpClient.class);
        try {
            result = MethodHandles.publicLookup().findVirtual(java.net.http.HttpClient.class, "close", methodType);
        }
        catch (IllegalAccessException | NoSuchMethodException e2) {
            result = MethodHandles.empty(methodType);
        }
        closeMethod = result;
    }
}

