/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.primary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.ConstantValueNode;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.MemberLookupMode;
import org.pkl.core.ast.builder.ConstLevel;
import org.pkl.core.ast.expression.member.ReadLocalPropertyNode;
import org.pkl.core.ast.expression.member.ReadPropertyNodeGen;
import org.pkl.core.ast.expression.primary.GetEnclosingReceiverNode;
import org.pkl.core.ast.expression.primary.GetReceiverNode;
import org.pkl.core.ast.frame.ReadAuxiliarySlotNode;
import org.pkl.core.ast.frame.ReadEnclosingAuxiliarySlotNode;
import org.pkl.core.ast.frame.ReadEnclosingFrameSlotNodeGen;
import org.pkl.core.ast.frame.ReadFrameSlotNodeGen;
import org.pkl.core.ast.member.Member;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;

public final class ResolveVariableNode
extends ExpressionNode {
    private final Identifier variableName;
    private final boolean isBaseModule;
    private final boolean isCustomThisScope;
    private final ConstLevel constLevel;
    private final int constDepth;

    public ResolveVariableNode(SourceSection sourceSection, Identifier variableName, boolean isBaseModule, boolean isCustomThisScope, ConstLevel constLevel, int constDepth) {
        super(sourceSection);
        this.variableName = variableName;
        this.isBaseModule = isBaseModule;
        this.isCustomThisScope = isCustomThisScope;
        this.constLevel = constLevel;
        this.constDepth = constDepth;
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        return ((ExpressionNode)this.replace(this.doResolve(frame))).executeGeneric(frame);
    }

    private ExpressionNode doResolve(VirtualFrame frame) {
        CompilerDirectives.transferToInterpreter();
        Identifier localPropertyName = this.variableName.toLocalProperty();
        int variableSlot = VmUtils.findAuxiliarySlot(frame, localPropertyName);
        if (variableSlot == -1) {
            variableSlot = VmUtils.findAuxiliarySlot(frame, this.variableName);
        }
        if (variableSlot != -1) {
            return new ReadAuxiliarySlotNode(this.getSourceSection(), variableSlot);
        }
        variableSlot = VmUtils.findSlot(frame, localPropertyName);
        if (variableSlot == -1) {
            variableSlot = VmUtils.findSlot(frame, this.variableName);
        }
        if (variableSlot != -1) {
            return ReadFrameSlotNodeGen.create(this.getSourceSection(), variableSlot);
        }
        VirtualFrame currFrame = frame;
        VmObjectLike currOwner = VmUtils.getOwner((Frame)currFrame);
        int levelsUp = 0;
        do {
            int parameterSlot;
            if ((parameterSlot = VmUtils.findSlot(currFrame, this.variableName)) == -1) {
                parameterSlot = VmUtils.findSlot(currFrame, localPropertyName);
            }
            if (parameterSlot != -1) {
                return levelsUp == 0 ? ReadFrameSlotNodeGen.create(this.getSourceSection(), parameterSlot) : ReadEnclosingFrameSlotNodeGen.create(this.getSourceSection(), parameterSlot, levelsUp);
            }
            int auxiliarySlot = VmUtils.findAuxiliarySlot(currFrame, this.variableName);
            if (auxiliarySlot == -1) {
                auxiliarySlot = VmUtils.findAuxiliarySlot(currFrame, localPropertyName);
            }
            if (auxiliarySlot != -1) {
                return levelsUp == 0 ? new ReadAuxiliarySlotNode(this.getSourceSection(), auxiliarySlot) : new ReadEnclosingAuxiliarySlotNode(this.getSourceSection(), auxiliarySlot, levelsUp);
            }
            ObjectMember localMember = currOwner.getMember(localPropertyName);
            if (localMember != null) {
                assert (localMember.isLocal());
                this.checkConst(currOwner, localMember, levelsUp);
                Object value2 = localMember.getConstantValue();
                if (value2 != null) {
                    return new ConstantValueNode(this.sourceSection, value2);
                }
                return new ReadLocalPropertyNode(this.sourceSection, localMember, levelsUp);
            }
            ObjectMember member = currOwner.getMember(this.variableName);
            if (member != null) {
                assert (!member.isLocal());
                this.checkConst(currOwner, member, levelsUp);
                return ReadPropertyNodeGen.create(this.sourceSection, this.variableName, MemberLookupMode.IMPLICIT_LEXICAL, false, levelsUp == 0 ? new GetReceiverNode() : new GetEnclosingReceiverNode(levelsUp));
            }
            currFrame = currOwner.getEnclosingFrame();
            currOwner = VmUtils.getOwnerOrNull((Frame)currFrame);
            ++levelsUp;
        } while (currOwner != null);
        if (!this.isBaseModule) {
            VmTyped baseModule = BaseModule.getModule();
            Object cachedValue = baseModule.getCachedValue(this.variableName);
            if (cachedValue != null) {
                return new ConstantValueNode(this.sourceSection, cachedValue);
            }
            ObjectMember member = baseModule.getMember(this.variableName);
            if (member != null) {
                Object constantValue = member.getConstantValue();
                if (constantValue != null) {
                    baseModule.setCachedValue(this.variableName, constantValue);
                    return new ConstantValueNode(this.sourceSection, constantValue);
                }
                Object computedValue = member.getCallTarget().call(new Object[]{baseModule, baseModule});
                baseModule.setCachedValue(this.variableName, computedValue);
                return new ConstantValueNode(this.sourceSection, computedValue);
            }
        }
        boolean needsConst = this.constLevel == ConstLevel.ALL && this.constDepth == -1 && !this.isCustomThisScope;
        return ReadPropertyNodeGen.create(this.sourceSection, this.variableName, MemberLookupMode.IMPLICIT_THIS, needsConst, VmUtils.createThisNode(VmUtils.unavailableSourceSection(), this.isCustomThisScope));
    }

    private void checkConst(VmObjectLike currOwner, Member member, int levelsUp) {
        boolean invalid;
        if (!this.constLevel.isConst()) {
            return;
        }
        boolean memberIsOutsideConstScope = levelsUp > this.constDepth;
        switch (this.constLevel) {
            case ALL: {
                boolean bl;
                if (memberIsOutsideConstScope && !member.isConst()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case MODULE: {
                boolean bl;
                if (currOwner.isModuleObject() && !member.isConst()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                boolean bl = invalid = false;
            }
        }
        if (invalid) {
            throw this.exceptionBuilder().evalError("propertyMustBeConst", this.variableName.toString()).build();
        }
    }
}

