/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.util.yaml;

import org.pkl.core.util.IoUtils;
import org.pkl.core.util.yaml.YamlEmitter;

public class Yaml12Emitter
extends YamlEmitter {
    public Yaml12Emitter(StringBuilder builder, String indent) {
        super(builder, indent);
    }

    @Override
    protected boolean isReservedWord(String str) {
        if (str.length() > 5) {
            return false;
        }
        switch (str) {
            case "": 
            case "~": 
            case "null": 
            case "Null": 
            case "NULL": 
            case ".nan": 
            case ".NaN": 
            case ".NAN": 
            case ".inf": 
            case ".Inf": 
            case ".INF": 
            case "+.inf": 
            case "+.Inf": 
            case "+.INF": 
            case "-.inf": 
            case "-.Inf": 
            case "-.INF": 
            case "true": 
            case "True": 
            case "TRUE": 
            case "false": 
            case "False": 
            case "FALSE": {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isNumber(String str, int colonIndex) {
        int length2 = str.length();
        assert (length2 > 0);
        if (length2 == 1) {
            return IoUtils.isDecimalDigit(str.charAt(0));
        }
        switch (str.charAt(0)) {
            case '0': {
                switch (str.charAt(1)) {
                    case 'o': {
                        return Yaml12Emitter.isOctalNumber(str, 2, length2);
                    }
                    case 'x': {
                        return Yaml12Emitter.isHexadecimalNumber(str, 2, length2);
                    }
                }
            }
            case '+': 
            case '-': {
                return Yaml12Emitter.isDecimalNumber(str, 1, length2);
            }
        }
        return Yaml12Emitter.isDecimalNumber(str, 0, length2);
    }

    static boolean isOctalNumber(String str, int start2, int length2) {
        if (start2 == length2) {
            return false;
        }
        for (int i = start2; i < length2; ++i) {
            char ch = str.charAt(i);
            if (IoUtils.isOctalDigit(ch)) continue;
            return false;
        }
        return true;
    }

    static boolean isHexadecimalNumber(String str, int start2, int length2) {
        if (start2 == length2) {
            return false;
        }
        for (int i = start2; i < length2; ++i) {
            char ch = str.charAt(i);
            if (IoUtils.isHexDigit(ch)) continue;
            return false;
        }
        return true;
    }

    static boolean isDecimalNumber(String str, int start2, int length2) {
        int index;
        char ch = '\u0000';
        for (index = start2; index < length2 && IoUtils.isDecimalDigit(ch = str.charAt(index)); ++index) {
        }
        if (index == length2) {
            return true;
        }
        if (ch == '.') {
            ++index;
            while (index < length2 && IoUtils.isDecimalDigit(ch = str.charAt(index))) {
                ++index;
            }
            if (index == length2) {
                return true;
            }
        }
        if (ch == 'e' || ch == 'E') {
            if (++index == length2) {
                return false;
            }
            ch = str.charAt(index);
            if ((ch == '-' || ch == '+') && ++index == length2) {
                return false;
            }
            while (index < length2 && IoUtils.isDecimalDigit(ch = str.charAt(index))) {
                ++index;
            }
        }
        return index == length2;
    }
}

