/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.util.json;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.pkl.core.Version;
import org.pkl.core.util.ErrorMessages;
import org.pkl.core.util.Nullable;
import org.pkl.core.util.json.JsonHandler;
import org.pkl.core.util.json.JsonParser;
import org.pkl.core.util.json.ParseException;

public class Json {
    public static JsObject parseObject(String input) throws JsonParseException {
        Handler handler = new Handler();
        JsonParser parser = new JsonParser(handler);
        try {
            parser.parse(input);
        }
        catch (ParseException e2) {
            throw new MalformedJsonException(e2, input);
        }
        Object ret = handler.value;
        if (!(ret instanceof JsObject)) {
            throw new FormatException("object", ret.getClass());
        }
        return (JsObject)ret;
    }

    public static class JsArray
    implements List<Object> {
        private final List<Object> delegate;

        public JsArray() {
            this.delegate = new ArrayList<Object>();
        }

        public JsArray(int size) {
            this.delegate = new ArrayList<Object>(size);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public Iterator<Object> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.delegate.toArray(a);
        }

        @Override
        public boolean add(Object o) {
            return this.delegate.add(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.delegate.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.delegate.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<?> c) {
            return this.delegate.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<?> c) {
            return this.delegate.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.delegate.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.delegate.retainAll(c);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public @Nullable Object get(int index) {
            return this.delegate.get(index);
        }

        @Override
        public Object set(int index, Object element) {
            return this.delegate.set(index, element);
        }

        @Override
        public void add(int index, Object element) {
            this.delegate.add(index, element);
        }

        @Override
        public Object remove(int index) {
            return this.delegate.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.delegate.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.delegate.lastIndexOf(o);
        }

        @Override
        public ListIterator<Object> listIterator() {
            return this.delegate.listIterator();
        }

        @Override
        public ListIterator<Object> listIterator(int index) {
            return this.delegate.listIterator(index);
        }

        @Override
        public List<Object> subList(int fromIndex, int toIndex) {
            return this.delegate.subList(fromIndex, toIndex);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    public static class JsObject
    implements Map<String, Object> {
        private final Map<String, Object> delegate;

        public JsObject() {
            this.delegate = new HashMap<String, Object>();
        }

        public JsObject(int size) {
            this.delegate = new HashMap<String, Object>(size);
        }

        public <T> T get(String key2, Mapper<T> mapper) throws JsonParseException {
            Object ret = this.get(key2);
            if (ret == null) {
                throw new MissingFieldException(this, key2);
            }
            try {
                return mapper.apply(ret);
            }
            catch (Exception e2) {
                throw new MappingException(key2, e2);
            }
        }

        public <T> @Nullable T getNullable(String key2, Mapper<T> mapper) throws JsonParseException {
            Object ret = this.get(key2);
            if (ret == null) {
                return null;
            }
            return this.get(key2, mapper);
        }

        public boolean getBoolean(String key2) throws JsonParseException {
            Object ret = this.get(key2);
            if (ret == null) {
                throw new MissingFieldException(this, key2);
            }
            if (!(ret instanceof Boolean)) {
                throw new FormatException(key2, "boolean", ret.getClass());
            }
            return (Boolean)ret;
        }

        public int getInt(String key2) throws JsonParseException {
            Object ret = this.get(key2);
            if (ret == null) {
                throw new MissingFieldException(this, key2);
            }
            if (!(ret instanceof Integer)) {
                throw new FormatException(key2, "integer", ret.getClass());
            }
            return (Integer)ret;
        }

        public String getString(String key2) throws JsonParseException {
            String ret = this.getStringOrNull(key2);
            if (ret == null) {
                throw new MissingFieldException(this, key2);
            }
            return ret;
        }

        public @Nullable String getStringOrNull(String key2) throws JsonParseException {
            Object ret = this.get(key2);
            if (ret == null) {
                return null;
            }
            if (!(ret instanceof String)) {
                throw new FormatException(key2, "string", ret.getClass());
            }
            return (String)ret;
        }

        public JsObject getObject(String key2) throws JsonParseException {
            Object ret = this.get(key2);
            if (ret == null) {
                throw new MissingFieldException(this, key2);
            }
            if (!(ret instanceof JsObject)) {
                throw new FormatException(key2, "object", ret.getClass());
            }
            return (JsObject)ret;
        }

        public JsArray getArray(String key2) throws JsonParseException {
            Object ret = this.get(key2);
            if (ret == null) {
                throw new MissingFieldException(this, key2);
            }
            if (!(ret instanceof JsArray)) {
                throw new FormatException(key2, "array", ret.getClass());
            }
            return (JsArray)ret;
        }

        public Version getVersion(String key2) throws JsonParseException {
            String versionStr = this.getString(key2);
            try {
                return Version.parse(versionStr);
            }
            catch (IllegalArgumentException e2) {
                throw new MappingException(key2, e2);
            }
        }

        public URI getURI(String key2) throws JsonParseException {
            URI result = this.getURIOrNull(key2);
            if (result == null) {
                throw new MissingFieldException(this, key2);
            }
            return result;
        }

        public @Nullable URI getURIOrNull(String key2) throws JsonParseException {
            String uriStr = this.getStringOrNull(key2);
            if (uriStr == null) {
                return null;
            }
            try {
                return new URI(uriStr);
            }
            catch (URISyntaxException e2) {
                throw new MappingException(key2, e2);
            }
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean containsKey(Object key2) {
            return this.delegate.containsKey(key2);
        }

        @Override
        public boolean containsValue(Object value2) {
            return this.delegate.containsValue(value2);
        }

        @Override
        public @Nullable Object get(Object key2) {
            return this.delegate.get(key2);
        }

        @Override
        public Object put(String key2, Object value2) {
            return this.delegate.put(key2, value2);
        }

        @Override
        public Object remove(Object key2) {
            return this.delegate.remove(key2);
        }

        @Override
        public void putAll(Map<? extends String, ?> m) {
            this.delegate.putAll(m);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public Set<String> keySet() {
            return this.delegate.keySet();
        }

        @Override
        public Collection<Object> values() {
            return this.delegate.values();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.delegate.entrySet();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    private static class Handler
    extends JsonHandler<JsArray, JsObject> {
        Object value;

        private Handler() {
        }

        @Override
        public void endString(String string) {
            this.value = string;
        }

        @Override
        public void endNull() {
            this.value = null;
        }

        @Override
        public void endBoolean(boolean value2) {
            this.value = value2;
        }

        @Override
        public void endNumber(String string) {
            try {
                this.value = Integer.valueOf(string);
            }
            catch (NumberFormatException e2) {
                this.value = Double.valueOf(string);
            }
        }

        @Override
        public JsArray startArray() {
            return new JsArray();
        }

        @Override
        public void endArrayValue(JsArray array) {
            array.add(this.value);
        }

        @Override
        public void endArray(JsArray array) {
            this.value = array;
        }

        @Override
        public JsObject startObject() {
            return new JsObject();
        }

        @Override
        public void endObjectValue(JsObject object, String name) {
            object.put(name, this.value);
        }

        @Override
        public void endObject(JsObject object) {
            this.value = object;
        }
    }

    public static class MissingFieldException
    extends JsonParseException {
        private final Object object;
        private final String key;

        public MissingFieldException(Object object, String key2) {
            this.object = object;
            this.key = key2;
        }

        @Override
        public String getMessage() {
            return ErrorMessages.create("badJsonMissingField", this.key, this.object);
        }
    }

    public static class MappingException
    extends JsonParseException {
        private final String message;

        public MappingException(String key2, Exception e2) {
            this.message = ErrorMessages.create("badJsonInvalidMapping", key2, e2.getMessage());
            this.initCause(e2);
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    public static class FormatException
    extends JsonParseException {
        private final String message;

        public FormatException(String expected, Class<?> actual) {
            this.message = ErrorMessages.create("badJsonFormat1", expected, actual.getSimpleName());
        }

        public FormatException(String key2, String expected, Class<?> actual) {
            this.message = ErrorMessages.create("badJsonFormat2", expected, key2, actual);
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    public static class MalformedJsonException
    extends JsonParseException {
        private final String message;

        public MalformedJsonException(ParseException e2, String inputString) {
            this.message = ErrorMessages.create("malformedJson", e2.getMessage(), inputString);
            this.initCause(e2);
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    public static abstract class JsonParseException
    extends Exception {
    }

    @FunctionalInterface
    public static interface Mapper<R> {
        public R apply(Object var1) throws Exception;
    }
}

