/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.util;

import org.pkl.core.DurationUnit;
import org.pkl.core.util.MathUtils;

public strictfp final class DurationUtils {
    private DurationUtils() {
    }

    public static String toPklString(double value2, DurationUnit unit2) {
        return MathUtils.isMathematicalInteger(value2) ? (long)value2 + "." + unit2 : value2 + "." + unit2;
    }

    public static String toIsoString(double value2, DurationUnit unit2) {
        double totalSeconds = value2 * ((double)unit2.getNanos() / 1.0E9);
        if (!Double.isFinite(totalSeconds)) {
            throw new ArithmeticException("Cannot convert Pkl duration `" + DurationUtils.toPklString(value2, unit2) + "` to ISO 8601 duration.");
        }
        double absoluteSeconds = Math.abs(totalSeconds);
        long hours = (long)(absoluteSeconds / 3600.0);
        long minutes = (long)(absoluteSeconds / 60.0) % 60L;
        long seconds = (long)(absoluteSeconds % 60.0);
        long nanos = (long)(absoluteSeconds * 1.0E9 - Math.floor(absoluteSeconds) * 1.0E9);
        StringBuilder builder = new StringBuilder();
        if (totalSeconds < 0.0) {
            builder.append('-');
        }
        builder.append("PT");
        if (hours != 0L) {
            builder.append(hours);
            builder.append('H');
        }
        if (minutes != 0L) {
            builder.append(minutes);
            builder.append('M');
        }
        if (seconds != 0L || nanos != 0L || totalSeconds == 0.0) {
            builder.append(seconds);
            if (nanos != 0L) {
                builder.append('.');
                String nanosString = String.valueOf(nanos);
                builder.append("0".repeat(9 - nanosString.length()));
                for (int i = nanosString.length(); i >= 0; --i) {
                    if (nanosString.charAt(i - 1) == '0') continue;
                    nanosString = nanosString.substring(0, i);
                    break;
                }
                builder.append(nanosString);
            }
            builder.append('S');
        }
        return builder.toString();
    }
}

