/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.util;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.concurrent.ConcurrentHashMap;

public class CollectionUtils {
    private static final float LOAD_FACTOR = 0.75f;

    private CollectionUtils() {
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> HashSet<T> newHashSet() {
        return new HashSet();
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> HashSet<T> newHashSet(int expectedSize) {
        return new HashSet((int)((float)expectedSize / 0.75f) + 1, 0.75f);
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> LinkedHashSet<T> newLinkedHashSet(int expectedSize) {
        return new LinkedHashSet((int)((float)expectedSize / 0.75f) + 1, 0.75f);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> HashMap<K, V> newHashMap(int expectedSize) {
        return new HashMap((int)((float)expectedSize / 0.75f) + 1, 0.75f);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(int expectedSize) {
        return new LinkedHashMap((int)((float)expectedSize / 0.75f) + 1, 0.75f);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(int expectedSize) {
        return new ConcurrentHashMap((int)((float)expectedSize / 0.75f) + 1, 0.75f);
    }
}

