/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.util;

import java.util.PrimitiveIterator;
import java.util.Set;
import org.pkl.core.PClassInfo;
import org.pkl.core.PType;
import org.pkl.core.util.Nullable;

public final class CodeGeneratorUtils {
    private static final int UNDERSCORE = 95;

    private CodeGeneratorUtils() {
    }

    public static boolean isRepresentableAsEnum(PType type, @Nullable Set<String> collector) {
        if (type instanceof PType.StringLiteral) {
            if (collector != null) {
                collector.add(((PType.StringLiteral)type).getLiteral());
            }
            return true;
        }
        if (type instanceof PType.Alias) {
            return CodeGeneratorUtils.isRepresentableAsEnum(((PType.Alias)type).getAliasedType(), collector);
        }
        if (type instanceof PType.Union) {
            for (PType elementType : ((PType.Union)type).getElementTypes()) {
                if (CodeGeneratorUtils.isRepresentableAsEnum(elementType, collector)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isRepresentableAsString(PType type) {
        if (type instanceof PType.StringLiteral) {
            return true;
        }
        if (type instanceof PType.Class) {
            return ((PType.Class)type).getPClass().getInfo() == PClassInfo.String;
        }
        if (type instanceof PType.Alias) {
            return CodeGeneratorUtils.isRepresentableAsString(((PType.Alias)type).getAliasedType());
        }
        if (type instanceof PType.Union) {
            for (PType elementType : ((PType.Union)type).getElementTypes()) {
                if (CodeGeneratorUtils.isRepresentableAsString(elementType)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static @Nullable String toEnumConstantName(String pklStringLiteral) {
        if (pklStringLiteral.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int firstCodePoint = pklStringLiteral.codePointAt(0);
        if (Character.getType(firstCodePoint) == 9) {
            builder.appendCodePoint(95);
        }
        PrimitiveIterator.OfInt iterator = pklStringLiteral.codePoints().iterator();
        boolean seenPotentialWordEnd = false;
        while (iterator.hasNext()) {
            int codePoint = iterator.nextInt();
            int category = Character.getType(codePoint);
            if (CodeGeneratorUtils.isPunctuationOrSpacing(category)) {
                builder.appendCodePoint(95);
                seenPotentialWordEnd = false;
                continue;
            }
            if (!CodeGeneratorUtils.isValidIdentifierPart(codePoint, category)) {
                return null;
            }
            boolean isUpperCase = Character.isUpperCase(codePoint);
            if (seenPotentialWordEnd && isUpperCase) {
                builder.appendCodePoint(95).appendCodePoint(codePoint);
                seenPotentialWordEnd = false;
                continue;
            }
            builder.appendCodePoint(isUpperCase ? codePoint : Character.toUpperCase(codePoint));
            seenPotentialWordEnd = !isUpperCase;
        }
        return builder.toString();
    }

    private static boolean isValidIdentifierPart(int codePoint, int category) {
        switch (category) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return codePoint == 95;
    }

    private static boolean isPunctuationOrSpacing(int category) {
        switch (category) {
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 30: {
                return true;
            }
        }
        return false;
    }
}

