/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.math;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import org.pkl.core.runtime.VmSafeMath;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.stdlib.ExternalMethod1Node;
import org.pkl.core.stdlib.ExternalMethod2Node;
import org.pkl.core.stdlib.ExternalPropertyNode;
import org.pkl.core.util.MathUtils;

public final class MathNodes {
    private static final double LN_2 = StrictMath.log(2.0);

    private MathNodes() {
    }

    public static abstract class max
    extends ExternalMethod2Node {
        @Specialization
        protected long eval(VmTyped self, long x, long y) {
            return StrictMath.max(x, y);
        }

        @Specialization
        protected double eval(VmTyped self, long x, double y) {
            return StrictMath.max((double)x, y);
        }

        @Specialization
        protected double eval(VmTyped self, double x, long y) {
            return StrictMath.max(x, (double)y);
        }

        @Specialization
        protected double eval(VmTyped self, double x, double y) {
            return StrictMath.max(x, y);
        }
    }

    public static abstract class min
    extends ExternalMethod2Node {
        @Specialization
        protected long eval(VmTyped self, long x, long y) {
            return StrictMath.min(x, y);
        }

        @Specialization
        protected double eval(VmTyped self, long x, double y) {
            return StrictMath.min((double)x, y);
        }

        @Specialization
        protected double eval(VmTyped self, double x, long y) {
            return StrictMath.min(x, (double)y);
        }

        @Specialization
        protected double eval(VmTyped self, double x, double y) {
            return StrictMath.min(x, y);
        }
    }

    public static abstract class isPowerOfTwo
    extends ExternalMethod1Node {
        @Specialization
        protected boolean eval(VmTyped self, long x) {
            return MathUtils.isPowerOfTwo(x);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected boolean eval(VmTyped self, double x) {
            return MathUtils.isPowerOfTwo(x);
        }
    }

    public strictfp static abstract class lcm
    extends ExternalMethod2Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected long eval(VmTyped self, long x, long y) {
            VmUtils.checkPositive(x);
            VmUtils.checkPositive(y);
            if (x == 0L || y == 0L) {
                return 0L;
            }
            return VmSafeMath.abs(VmSafeMath.multiply(x / MathUtils.gcd(x, y), y));
        }
    }

    public static abstract class gcd
    extends ExternalMethod2Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected long eval(VmTyped self, long x, long y) {
            VmUtils.checkPositive(x);
            VmUtils.checkPositive(y);
            return MathUtils.gcd(x, y);
        }
    }

    public static abstract class atan
    extends ExternalMethod1Node {
        @Specialization
        protected double eval(VmTyped self, long x) {
            return StrictMath.atan(x);
        }

        @Specialization
        protected double eval(VmTyped self, double x) {
            return StrictMath.atan(x);
        }
    }

    public static abstract class acos
    extends ExternalMethod1Node {
        @Specialization
        protected double eval(VmTyped self, long x) {
            return StrictMath.acos(x);
        }

        @Specialization
        protected double eval(VmTyped self, double x) {
            return StrictMath.acos(x);
        }
    }

    public static abstract class asin
    extends ExternalMethod1Node {
        @Specialization
        protected double eval(VmTyped self, long x) {
            return StrictMath.asin(x);
        }

        @Specialization
        protected double eval(VmTyped self, double x) {
            return StrictMath.asin(x);
        }
    }

    public static abstract class tan
    extends ExternalMethod1Node {
        @Specialization
        protected double eval(VmTyped self, long x) {
            return StrictMath.tan(x);
        }

        @Specialization
        protected double eval(VmTyped self, double x) {
            return StrictMath.tan(x);
        }
    }

    public static abstract class cos
    extends ExternalMethod1Node {
        @Specialization
        protected double eval(VmTyped self, long x) {
            return StrictMath.cos(x);
        }

        @Specialization
        protected double eval(VmTyped self, double x) {
            return StrictMath.cos(x);
        }
    }

    public static abstract class sin
    extends ExternalMethod1Node {
        @Specialization
        protected double eval(VmTyped self, long x) {
            return StrictMath.sin(x);
        }

        @Specialization
        protected double eval(VmTyped self, double x) {
            return StrictMath.sin(x);
        }
    }

    public static abstract class log10
    extends ExternalMethod1Node {
        @Specialization
        protected double eval(VmTyped self, long x) {
            return StrictMath.log10(x);
        }

        @Specialization
        protected double eval(VmTyped self, double x) {
            return StrictMath.log10(x);
        }
    }

    public strictfp static abstract class log2
    extends ExternalMethod1Node {
        @Specialization
        protected double eval(VmTyped self, long x) {
            return StrictMath.log(x) / LN_2;
        }

        @Specialization
        protected double eval(VmTyped self, double x) {
            return StrictMath.log(x) / LN_2;
        }
    }

    public static abstract class log
    extends ExternalMethod1Node {
        @Specialization
        protected double eval(VmTyped self, long x) {
            return StrictMath.log(x);
        }

        @Specialization
        protected double eval(VmTyped self, double x) {
            return StrictMath.log(x);
        }
    }

    public static abstract class cbrt
    extends ExternalMethod1Node {
        @Specialization
        protected double eval(VmTyped self, long x) {
            return StrictMath.cbrt(x);
        }

        @Specialization
        protected double eval(VmTyped self, double x) {
            return StrictMath.cbrt(x);
        }
    }

    public static abstract class sqrt
    extends ExternalMethod1Node {
        @Specialization
        protected double eval(VmTyped self, long x) {
            return StrictMath.sqrt(x);
        }

        @Specialization
        protected double eval(VmTyped self, double x) {
            return StrictMath.sqrt(x);
        }
    }

    public static abstract class exp
    extends ExternalMethod1Node {
        @Specialization
        protected double eval(VmTyped self, long x) {
            return StrictMath.exp(x);
        }

        @Specialization
        protected double eval(VmTyped self, double x) {
            return StrictMath.exp(x);
        }
    }

    public static abstract class pi
    extends ExternalPropertyNode {
        @Specialization
        protected double eval(VmTyped self) {
            return Math.PI;
        }
    }

    public static abstract class e
    extends ExternalPropertyNode {
        @Specialization
        protected double eval(VmTyped self) {
            return Math.E;
        }
    }

    public static abstract class minPositiveFloat
    extends ExternalPropertyNode {
        @Specialization
        protected double eval(VmTyped self) {
            return Double.MIN_VALUE;
        }
    }

    public static abstract class maxFiniteFloat
    extends ExternalPropertyNode {
        @Specialization
        protected double eval(VmTyped self) {
            return Double.MAX_VALUE;
        }
    }

    public static abstract class minFiniteFloat
    extends ExternalPropertyNode {
        @Specialization
        protected double eval(VmTyped self) {
            return -1.7976931348623157E308;
        }
    }

    public static abstract class maxUInt32
    extends ExternalPropertyNode {
        @Specialization
        protected long eval(VmTyped self) {
            return 0xFFFFFFFFL;
        }
    }

    public static abstract class maxUInt16
    extends ExternalPropertyNode {
        @Specialization
        protected long eval(VmTyped self) {
            return 65535L;
        }
    }

    public static abstract class maxUInt8
    extends ExternalPropertyNode {
        @Specialization
        protected long eval(VmTyped self) {
            return 255L;
        }
    }

    public static abstract class maxUInt
    extends ExternalPropertyNode {
        @Specialization
        protected long eval(VmTyped self) {
            return Long.MAX_VALUE;
        }
    }

    public static abstract class maxInt32
    extends ExternalPropertyNode {
        @Specialization
        protected long eval(VmTyped self) {
            return Integer.MAX_VALUE;
        }
    }

    public static abstract class minInt32
    extends ExternalPropertyNode {
        @Specialization
        protected long eval(VmTyped self) {
            return Integer.MIN_VALUE;
        }
    }

    public static abstract class maxInt16
    extends ExternalPropertyNode {
        @Specialization
        protected long eval(VmTyped self) {
            return 32767L;
        }
    }

    public static abstract class minInt16
    extends ExternalPropertyNode {
        @Specialization
        protected long eval(VmTyped self) {
            return -32768L;
        }
    }

    public static abstract class maxInt8
    extends ExternalPropertyNode {
        @Specialization
        protected long eval(VmTyped self) {
            return 127L;
        }
    }

    public static abstract class minInt8
    extends ExternalPropertyNode {
        @Specialization
        protected long eval(VmTyped self) {
            return -128L;
        }
    }

    public static abstract class maxInt
    extends ExternalPropertyNode {
        @Specialization
        protected long eval(VmTyped self) {
            return Long.MAX_VALUE;
        }
    }

    public static abstract class minInt
    extends ExternalPropertyNode {
        @Specialization
        protected long eval(VmTyped self) {
            return Long.MIN_VALUE;
        }
    }
}

