/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib;

import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmCollection;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmFunction;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmSet;
import org.pkl.core.runtime.VmTypeAlias;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUndefinedValueException;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.runtime.VmValue;
import org.pkl.core.runtime.VmValueConverter;
import org.pkl.core.runtime.VmValueVisitor;
import org.pkl.core.stdlib.PklConverter;
import org.pkl.core.util.LateInit;
import org.pkl.core.util.MutableBoolean;
import org.pkl.core.util.Nullable;

public abstract class AbstractRenderer
implements VmValueVisitor {
    protected static final char LINE_BREAK = '\n';
    protected final String name;
    protected final StringBuilder builder;
    protected final String indent;
    protected final PklConverter converter;
    private final boolean skipNullProperties;
    private final boolean skipNullEntries;
    @LateInit
    protected Deque<Object> currPath;
    protected @Nullable VmValue enclosingValue;
    @LateInit
    private Object topLevelValue;
    protected StringBuilder currIndent = new StringBuilder();
    protected @Nullable SourceSection currSourceSection = null;

    public AbstractRenderer(String name, StringBuilder builder, String indent, PklConverter converter, boolean skipNullProperties, boolean skipNullEntries) {
        this.name = name;
        this.builder = builder;
        this.indent = indent;
        this.converter = converter;
        this.skipNullProperties = skipNullProperties;
        this.skipNullEntries = skipNullEntries;
    }

    public final void renderDocument(Object value2) {
        this.currPath = new ArrayDeque<Object>();
        this.currPath.push(VmValueConverter.TOP_LEVEL_VALUE);
        Object converted = this.converter.convert(value2, this.currPath);
        this.topLevelValue = converted;
        try {
            this.visitDocument(converted);
        }
        catch (VmException err) {
            if (converted != value2) {
                err.setHint(String.format("This value was converted during rendering. Previous: %s. After: %s.", new VmException.ProgramValue("before", value2), new VmException.ProgramValue("after", converted)));
                throw err;
            }
            throw err;
        }
    }

    public final void renderValue(Object value2) {
        this.currPath = new ArrayDeque<Object>();
        this.currPath.push(VmValueConverter.TOP_LEVEL_VALUE);
        Object converted = this.converter.convert(value2, this.currPath);
        this.topLevelValue = converted;
        this.visitTopLevelValue(converted);
    }

    @Override
    public void visit(Object value2) {
        try {
            VmValueVisitor.super.visit(value2);
        }
        catch (VmUndefinedValueException e2) {
            if (e2.getReceiver() == value2) {
                throw e2.fillInHint(this.currPath, this.topLevelValue);
            }
            throw e2;
        }
    }

    protected abstract void visitDocument(Object var1);

    protected abstract void visitTopLevelValue(Object var1);

    protected abstract void visitRenderDirective(VmTyped var1);

    protected abstract void startDynamic(VmDynamic var1);

    protected abstract void startTyped(VmTyped var1);

    protected abstract void startListing(VmListing var1);

    protected abstract void startMapping(VmMapping var1);

    protected abstract void startList(VmList var1);

    protected abstract void startSet(VmSet var1);

    protected abstract void startMap(VmMap var1);

    protected abstract void visitElement(long var1, Object var3, boolean var4);

    protected abstract void visitEntryKey(Object var1, boolean var2);

    protected abstract void visitEntryValue(Object var1);

    protected abstract void visitProperty(Identifier var1, Object var2, boolean var3);

    protected abstract void endDynamic(VmDynamic var1, boolean var2);

    protected abstract void endTyped(VmTyped var1, boolean var2);

    protected abstract void endListing(VmListing var1, boolean var2);

    protected abstract void endMapping(VmMapping var1, boolean var2);

    protected abstract void endList(VmList var1);

    protected abstract void endSet(VmSet var1);

    protected abstract void endMap(VmMap var1);

    private void doVisitProperty(Identifier name, Object value2, SourceSection sourceSection, MutableBoolean isFirst) {
        SourceSection prevSourceSection = this.currSourceSection;
        this.currSourceSection = sourceSection;
        this.currPath.push(name);
        Object convertedValue = this.converter.convert(value2, this.currPath);
        if (!this.skipNullProperties || !(convertedValue instanceof VmNull)) {
            this.visitProperty(name, convertedValue, isFirst.getAndSetFalse());
        }
        this.currPath.pop();
        this.currSourceSection = prevSourceSection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doVisitEntry(Object key2, Object value2, @Nullable SourceSection sourceSection, MutableBoolean isFirst) {
        SourceSection prevSourceSection = this.currSourceSection;
        if (sourceSection != null) {
            this.currSourceSection = sourceSection;
        }
        Deque<Object> valuePath = this.currPath;
        try {
            Object convertedKey = this.converter.convert(key2, List.of());
            valuePath.push(convertedKey);
            Object convertedValue = this.converter.convert(value2, valuePath);
            if (this.skipNullEntries && convertedValue instanceof VmNull) {
                return;
            }
            this.currPath = new ArrayDeque<Object>();
            this.visitEntryKey(convertedKey, isFirst.getAndSetFalse());
            this.currPath = valuePath;
            this.visitEntryValue(convertedValue);
        }
        finally {
            valuePath.pop();
            this.currSourceSection = prevSourceSection;
        }
    }

    private void doVisitElement(long index, Object value2, @Nullable SourceSection sourceSection, boolean isFirst) {
        SourceSection prevSourceSection = this.currSourceSection;
        if (sourceSection != null) {
            this.currSourceSection = sourceSection;
        }
        this.currPath.push(index);
        Object convertedValue = this.converter.convert(value2, this.currPath);
        this.visitElement(index, convertedValue, isFirst);
        this.currPath.pop();
        this.currSourceSection = prevSourceSection;
    }

    @Override
    public void visitTyped(VmTyped value2) {
        if (VmUtils.isRenderDirective(value2)) {
            this.visitRenderDirective(value2);
            return;
        }
        this.startTyped(value2);
        VmValue prevEnclosingValue = this.enclosingValue;
        this.enclosingValue = value2;
        MutableBoolean isFirst = new MutableBoolean(true);
        value2.forceAndIterateMemberValues((memberKey, member, memberValue) -> {
            if (member.isClass() || member.isTypeAlias()) {
                return true;
            }
            assert (member.isProp());
            this.doVisitProperty((Identifier)memberKey, memberValue, member.getSourceSection(), isFirst);
            return true;
        });
        this.enclosingValue = prevEnclosingValue;
        this.endTyped(value2, isFirst.get());
    }

    @Override
    public final void visitDynamic(VmDynamic value2) {
        this.startDynamic(value2);
        VmValue prevEnclosingValue = this.enclosingValue;
        this.enclosingValue = value2;
        MutableBoolean isFirst = new MutableBoolean(true);
        boolean canRenderPropertyOrEntry = this.canRenderPropertyOrEntryOf(value2);
        value2.forceAndIterateMemberValues((memberKey, member, memberValue) -> {
            SourceSection sourceSection = member.getSourceSection();
            if (member.isProp()) {
                if (!canRenderPropertyOrEntry) {
                    this.cannotRenderObjectWithElementsAndOtherMembers(value2);
                }
                this.doVisitProperty((Identifier)memberKey, memberValue, sourceSection, isFirst);
            } else if (member.isEntry()) {
                if (!canRenderPropertyOrEntry) {
                    this.cannotRenderObjectWithElementsAndOtherMembers(value2);
                }
                this.doVisitEntry(memberKey, memberValue, sourceSection, isFirst);
            } else {
                this.doVisitElement((Long)memberKey, memberValue, sourceSection, isFirst.getAndSetFalse());
            }
            return true;
        });
        this.enclosingValue = prevEnclosingValue;
        this.endDynamic(value2, isFirst.get());
    }

    protected boolean canRenderPropertyOrEntryOf(VmDynamic object) {
        return !object.hasElements();
    }

    private void cannotRenderObjectWithElementsAndOtherMembers(VmDynamic object) {
        throw new VmExceptionBuilder().evalError("cannotRenderObjectWithElementsAndOtherMembers", this.name).withProgramValue("Object", object).build();
    }

    @Override
    public final void visitListing(VmListing value2) {
        this.startListing(value2);
        VmValue prevEnclosingValue = this.enclosingValue;
        this.enclosingValue = value2;
        MutableBoolean isFirst = new MutableBoolean(true);
        value2.forceAndIterateMemberValues((memberKey, member, memberValue) -> {
            assert (member.isElement());
            this.doVisitElement((Long)memberKey, memberValue, member.getSourceSection(), isFirst.getAndSetFalse());
            return true;
        });
        this.enclosingValue = prevEnclosingValue;
        this.endListing(value2, isFirst.get());
    }

    @Override
    public final void visitMapping(VmMapping value2) {
        this.startMapping(value2);
        VmValue prevEnclosingValue = this.enclosingValue;
        this.enclosingValue = value2;
        MutableBoolean isFirst = new MutableBoolean(true);
        value2.forceAndIterateMemberValues((memberKey, member, memberValue) -> {
            assert (member.isEntry());
            this.doVisitEntry(memberKey, memberValue, member.getSourceSection(), isFirst);
            return true;
        });
        this.enclosingValue = prevEnclosingValue;
        this.endMapping(value2, isFirst.get());
    }

    @Override
    public final void visitList(VmList value2) {
        this.startList(value2);
        this.doVisitCollectionElements(value2);
        this.endList(value2);
    }

    @Override
    public final void visitSet(VmSet value2) {
        this.startSet(value2);
        this.doVisitCollectionElements(value2);
        this.endSet(value2);
    }

    private void doVisitCollectionElements(VmCollection value2) {
        VmValue prevEnclosingValue = this.enclosingValue;
        this.enclosingValue = value2;
        long index = 0L;
        for (Object elem : value2) {
            this.doVisitElement(index, elem, null, index == 0L);
            ++index;
        }
        this.enclosingValue = prevEnclosingValue;
    }

    @Override
    public final void visitMap(VmMap value2) {
        this.startMap(value2);
        VmValue prevEnclosingValue = this.enclosingValue;
        this.enclosingValue = value2;
        MutableBoolean isFirst = new MutableBoolean(true);
        for (Map.Entry<Object, Object> entry : value2) {
            this.doVisitEntry(entry.getKey(), entry.getValue(), null, isFirst);
        }
        this.enclosingValue = prevEnclosingValue;
        this.endMap(value2);
    }

    @Override
    public final void visitTypeAlias(VmTypeAlias value2) {
        this.cannotRenderTypeAddConverter(value2);
    }

    @Override
    public final void visitClass(VmClass value2) {
        this.cannotRenderTypeAddConverter(value2);
    }

    @Override
    public final void visitFunction(VmFunction value2) {
        this.cannotRenderTypeAddConverter(value2);
    }

    protected void cannotRenderTypeAddConverter(VmValue value2) {
        VmExceptionBuilder builder = new VmExceptionBuilder().evalError("cannotRenderTypeAddConverter", value2.getVmClass(), this.name).withProgramValue("Value", value2);
        if (this.currSourceSection != null) {
            builder.withSourceSection(this.currSourceSection);
        }
        throw builder.build();
    }

    protected void cannotRenderNonStringKey(Object key2) {
        assert (this.enclosingValue != null);
        boolean isMap = this.enclosingValue instanceof VmMap;
        throw new VmExceptionBuilder().evalError(isMap ? "cannotRenderNonStringMap" : "cannotRenderObjectWithNonStringKey", this.name).withProgramValue(isMap ? "Map" : "Object", this.enclosingValue).withProgramValue("Key", key2).build();
    }

    protected void increaseIndent() {
        this.currIndent.append(this.indent);
    }

    protected void decreaseIndent() {
        this.currIndent.setLength(this.currIndent.length() - this.indent.length());
    }
}

