/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.service;

import java.nio.file.Path;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.pkl.core.Evaluator;
import org.pkl.core.EvaluatorBuilder;
import org.pkl.core.ModuleSource;
import org.pkl.core.PklException;
import org.pkl.core.Release;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagers;
import org.pkl.core.StackFrameTransformer;
import org.pkl.core.StackFrameTransformers;
import org.pkl.core.module.ModuleKeyFactories;
import org.pkl.core.module.ModulePathResolver;
import org.pkl.core.project.Project;
import org.pkl.core.resource.ResourceReaders;
import org.pkl.executor.spi.v1.ExecutorSpi;
import org.pkl.executor.spi.v1.ExecutorSpiException;
import org.pkl.executor.spi.v1.ExecutorSpiOptions;

public class ExecutorSpiImpl
implements ExecutorSpi {
    private final String pklVersion = Release.current().version().toString();

    public String getPklVersion() {
        return this.pklVersion;
    }

    public String evaluatePath(Path modulePath, ExecutorSpiOptions options) {
        List<Pattern> allowedModules = options.getAllowedModules().stream().map(Pattern::compile).collect(Collectors.toList());
        List<Pattern> allowedResources = options.getAllowedResources().stream().map(Pattern::compile).collect(Collectors.toList());
        SecurityManager securityManager = SecurityManagers.standard(allowedModules, allowedResources, SecurityManagers.defaultTrustLevels, options.getRootDir());
        StackFrameTransformer transformer = StackFrameTransformers.defaultTransformer;
        if (options.getRootDir() != null) {
            transformer = transformer.andThen(StackFrameTransformers.relativizeModuleUri(options.getRootDir().toUri()));
        }
        ModulePathResolver resolver = new ModulePathResolver(options.getModulePath());
        EvaluatorBuilder builder = EvaluatorBuilder.unconfigured().setStackFrameTransformer(transformer).setSecurityManager(securityManager).addResourceReader(ResourceReaders.environmentVariable()).addResourceReader(ResourceReaders.externalProperty()).addResourceReader(ResourceReaders.modulePath(resolver)).addResourceReader(ResourceReaders.pkg()).addResourceReader(ResourceReaders.projectpackage()).addResourceReader(ResourceReaders.file()).addResourceReader(ResourceReaders.http()).addResourceReader(ResourceReaders.https()).addModuleKeyFactory(ModuleKeyFactories.standardLibrary).addModuleKeyFactories(ModuleKeyFactories.fromServiceProviders()).addModuleKeyFactory(ModuleKeyFactories.modulePath(resolver)).addModuleKeyFactory(ModuleKeyFactories.pkg).addModuleKeyFactory(ModuleKeyFactories.projectpackage).addModuleKeyFactory(ModuleKeyFactories.file).addModuleKeyFactory(ModuleKeyFactories.genericUrl).setEnvironmentVariables(options.getEnvironmentVariables()).setExternalProperties(options.getExternalProperties()).setTimeout(options.getTimeout()).setOutputFormat(options.getOutputFormat()).setModuleCacheDir(options.getModuleCacheDir());
        if (options.getProjectDir() != null) {
            Project project = Project.loadFromPath(options.getProjectDir().resolve("PklProject"));
            builder.setProjectDependencies(project.getDependencies());
        }
        try {
            Evaluator evaluator = builder.build();
            try {
                String string = evaluator.evaluateOutputText(ModuleSource.path(modulePath));
                if (evaluator != null) {
                    evaluator.close();
                }
                return string;
            }
            catch (Throwable throwable) {
                try {
                    if (evaluator != null) {
                        try {
                            evaluator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (PklException e2) {
                    throw new ExecutorSpiException(e2.getMessage(), e2.getCause());
                }
            }
        }
        finally {
            ModuleKeyFactories.closeQuietly(builder.getModuleKeyFactories());
        }
    }
}

