/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import java.util.Objects;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmDataSize;
import org.pkl.core.runtime.VmDuration;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmFunction;
import org.pkl.core.runtime.VmIntSeq;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmPair;
import org.pkl.core.runtime.VmRegex;
import org.pkl.core.runtime.VmSet;
import org.pkl.core.runtime.VmTypeAlias;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmValue;

public interface VmValueVisitor {
    public void visitString(String var1);

    public void visitBoolean(Boolean var1);

    public void visitInt(Long var1);

    public void visitFloat(Double var1);

    public void visitDuration(VmDuration var1);

    public void visitDataSize(VmDataSize var1);

    public void visitIntSeq(VmIntSeq var1);

    public void visitList(VmList var1);

    public void visitSet(VmSet var1);

    public void visitMap(VmMap var1);

    public void visitTyped(VmTyped var1);

    public void visitDynamic(VmDynamic var1);

    public void visitListing(VmListing var1);

    public void visitMapping(VmMapping var1);

    public void visitClass(VmClass var1);

    public void visitTypeAlias(VmTypeAlias var1);

    public void visitPair(VmPair var1);

    public void visitRegex(VmRegex var1);

    public void visitNull(VmNull var1);

    public void visitFunction(VmFunction var1);

    default public void visit(Object value2) {
        Objects.requireNonNull(value2, "Value to be visited must be non-null.");
        if (value2 instanceof VmValue) {
            ((VmValue)value2).accept(this);
        } else if (value2 instanceof String) {
            this.visitString((String)value2);
        } else if (value2 instanceof Boolean) {
            this.visitBoolean((Boolean)value2);
        } else if (value2 instanceof Long) {
            this.visitInt((Long)value2);
        } else if (value2 instanceof Double) {
            this.visitFloat((Double)value2);
        } else {
            throw new IllegalArgumentException("Unknown VM value type: " + value2.getClass().getName());
        }
    }
}

