/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import java.net.URI;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.StdLibModule;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;

public final class ReleaseModule
extends StdLibModule {
    private static final VmTyped instance = VmUtils.createEmptyModule();

    public static VmTyped getModule() {
        return instance;
    }

    public static VmClass getReleaseClass() {
        return ReleaseClass.instance;
    }

    public static VmClass getSourceCodeClass() {
        return SourceCodeClass.instance;
    }

    public static VmClass getDocumentationClass() {
        return DocumentationClass.instance;
    }

    public static VmClass getStandardLibraryClass() {
        return StandardLibraryClass.instance;
    }

    @CompilerDirectives.TruffleBoundary
    private static VmClass loadClass(String className) {
        VmTyped theModule = ReleaseModule.getModule();
        return (VmClass)VmUtils.readMember(theModule, Identifier.get(className));
    }

    static {
        ReleaseModule.loadModule(URI.create("pkl:release"), instance);
    }

    private static final class StandardLibraryClass {
        static final VmClass instance = ReleaseModule.loadClass("StandardLibrary");

        private StandardLibraryClass() {
        }
    }

    private static final class DocumentationClass {
        static final VmClass instance = ReleaseModule.loadClass("Documentation");

        private DocumentationClass() {
        }
    }

    private static final class SourceCodeClass {
        static final VmClass instance = ReleaseModule.loadClass("SourceCode");

        private SourceCodeClass() {
        }
    }

    private static final class ReleaseClass {
        static final VmClass instance = ReleaseModule.loadClass("Release");

        private ReleaseClass() {
        }
    }
}

