/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.pkl.core.ValueFormatter;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.util.Nullable;
import org.pkl.core.util.StringSimilarity;

public class KeyLookupSuggestions {
    private static final StringSimilarity STRING_SIMILARITY = new StringSimilarity();
    private static final double SIMILARITY_THRESHOLD = 0.77;

    public static List<Candidate> forMap(VmMap map2, String key2) {
        ArrayList<Candidate> candidates = new ArrayList<Candidate>();
        map2.forEach(entry -> {
            if (!(entry.getKey() instanceof String)) {
                return;
            }
            String entryKey = (String)entry.getKey();
            double similarity = STRING_SIMILARITY.similarity(entryKey, key2);
            if (similarity >= 0.77) {
                candidates.add(new Candidate(entryKey, similarity));
            }
        });
        candidates.sort(Comparator.naturalOrder());
        return candidates;
    }

    public static List<Candidate> forObject(VmObjectLike object, String key2) {
        ArrayList<Candidate> candidates = new ArrayList<Candidate>();
        object.iterateMemberValues((memberKey, member, value2) -> {
            if (!(memberKey instanceof String)) {
                return true;
            }
            String stringKey = (String)memberKey;
            double similarity = STRING_SIMILARITY.similarity(stringKey, key2);
            if (similarity >= 0.77) {
                candidates.add(new Candidate(stringKey, similarity));
            }
            return true;
        });
        candidates.sort(Comparator.naturalOrder());
        return candidates;
    }

    public static final class Candidate
    implements Comparable<Candidate> {
        private final String key;
        private final double similarity;

        public Candidate(String key2, double similarity) {
            this.key = key2;
            this.similarity = similarity;
        }

        @Override
        public int compareTo(Candidate other) {
            return Double.compare(other.similarity, this.similarity);
        }

        public boolean equals(@Nullable Object obj) {
            return obj instanceof Candidate && ((Candidate)obj).key.equals(this.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return ValueFormatter.basic().formatStringValue(this.key, "");
        }
    }
}

