/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class CertificateUtils {
    public static void setupAllX509CertificatesGlobally(List<Object> certs) {
        try {
            ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>(certs.size());
            for (Object cert : certs) {
                InputStream input = CertificateUtils.toInputStream(cert);
                try {
                    certificates.addAll(CertificateUtils.generateCertificates(input));
                }
                finally {
                    if (input == null) continue;
                    input.close();
                }
            }
            CertificateUtils.setupX509CertificatesGlobally(certificates);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    private static InputStream toInputStream(Object cert) throws IOException {
        if (cert instanceof Path) {
            Path pathCert = (Path)cert;
            return Files.newInputStream(pathCert, new OpenOption[0]);
        }
        if (cert instanceof InputStream) {
            return (InputStream)cert;
        }
        throw new IllegalArgumentException("Unknown class for certificate: " + cert.getClass() + ". Valid types: java.nio.Path, java.io.InputStream");
    }

    private static Collection<X509Certificate> generateCertificates(InputStream inputStream) throws CertificateException {
        return CertificateFactory.getInstance("X.509").generateCertificates(inputStream);
    }

    private static void setupX509CertificatesGlobally(Collection<X509Certificate> certs) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException, KeyManagementException {
        System.setProperty("com.sun.net.ssl.checkRevocation", "true");
        Security.setProperty("ocsp.enable", "true");
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        keystore.load(null);
        int count2 = 1;
        for (X509Certificate cert : certs) {
            keystore.setCertificateEntry("Certificate" + count2++, cert);
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keystore);
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, tmf.getTrustManagers(), new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }
}

