/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.resource;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.module.FileResolver;
import org.pkl.core.module.ModulePathResolver;
import org.pkl.core.module.PathElement;
import org.pkl.core.module.ProjectDependenciesManager;
import org.pkl.core.packages.Dependency;
import org.pkl.core.packages.PackageAssetUri;
import org.pkl.core.packages.PackageResolver;
import org.pkl.core.resource.Resource;
import org.pkl.core.resource.ResourceReader;
import org.pkl.core.runtime.VmContext;
import org.pkl.core.util.ErrorMessages;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.Nullable;

public final class ResourceReaders {
    private ResourceReaders() {
    }

    public static ResourceReader environmentVariable() {
        return EnvironmentVariable.INSTANCE;
    }

    public static ResourceReader externalProperty() {
        return ExternalProperty.INSTANCE;
    }

    public static ResourceReader file() {
        return FileResource.INSTANCE;
    }

    public static ResourceReader http() {
        return HttpResource.INSTANCE;
    }

    public static ResourceReader https() {
        return HttpsResource.INSTANCE;
    }

    public static ResourceReader classPath(ClassLoader classLoader) {
        return new ClassPathResource(classLoader);
    }

    public static ResourceReader modulePath(ModulePathResolver resolver) {
        return new ModulePathResource(resolver);
    }

    public static ResourceReader pkg() {
        return PackageResource.INSTANCE;
    }

    public static ResourceReader projectpackage() {
        return ProjectPackageResource.INSTANCE;
    }

    public static List<ResourceReader> fromServiceProviders() {
        return FromServiceProviders.INSTANCE;
    }

    private static class FromServiceProviders {
        private static final List<ResourceReader> INSTANCE;

        private FromServiceProviders() {
        }

        static {
            ServiceLoader<ResourceReader> loader = IoUtils.createServiceLoader(ResourceReader.class);
            ArrayList readers = new ArrayList();
            loader.forEach(readers::add);
            INSTANCE = Collections.unmodifiableList(readers);
        }
    }

    private static final class ProjectPackageResource
    implements ResourceReader {
        static final ProjectPackageResource INSTANCE = new ProjectPackageResource();

        private ProjectPackageResource() {
        }

        @Override
        public String getUriScheme() {
            return "projectpackage";
        }

        @Override
        public Optional<Object> read(URI uri) throws IOException, URISyntaxException, SecurityManagerException {
            PackageAssetUri assetUri = new PackageAssetUri(uri);
            Dependency dependency = this.getProjectDepsResolver().getResolvedDependency(assetUri.getPackageUri());
            Path path = this.getLocalPath(dependency, assetUri);
            if (path != null) {
                URL url = path.toUri().toURL();
                byte[] bytes = IoUtils.readBytes(url);
                return Optional.of(new Resource(uri, bytes));
            }
            Dependency.RemoteDependency remoteDep = (Dependency.RemoteDependency)dependency;
            byte[] bytes = this.getPackageResolver().getBytes(assetUri, true, remoteDep.getChecksums());
            return Optional.of(new Resource(uri, bytes));
        }

        @Override
        public boolean hasHierarchicalUris() {
            return true;
        }

        @Override
        public boolean isGlobbable() {
            return true;
        }

        @Override
        public boolean hasFragmentPaths() {
            return true;
        }

        @Override
        public List<PathElement> listElements(SecurityManager securityManager, URI baseUri) throws IOException, SecurityManagerException {
            securityManager.checkResolveResource(baseUri);
            PackageAssetUri packageAssetUri = PackageAssetUri.create(baseUri);
            Dependency dependency = this.getProjectDepsResolver().getResolvedDependency(packageAssetUri.getPackageUri());
            Path path = this.getLocalPath(dependency, packageAssetUri);
            if (path != null) {
                return FileResolver.listElements(path);
            }
            Dependency.RemoteDependency remoteDep = (Dependency.RemoteDependency)dependency;
            return this.getPackageResolver().listElements(PackageAssetUri.create(baseUri), remoteDep.getChecksums());
        }

        @Override
        public boolean hasElement(SecurityManager securityManager, URI elementUri) throws IOException, SecurityManagerException {
            securityManager.checkResolveResource(elementUri);
            PackageAssetUri packageAssetUri = PackageAssetUri.create(elementUri);
            Dependency dependency = this.getProjectDepsResolver().getResolvedDependency(packageAssetUri.getPackageUri());
            Path path = this.getLocalPath(dependency, packageAssetUri);
            if (path != null) {
                return FileResolver.hasElement(path);
            }
            Dependency.RemoteDependency remoteDep = (Dependency.RemoteDependency)dependency;
            return this.getPackageResolver().hasElement(PackageAssetUri.create(elementUri), remoteDep.getChecksums());
        }

        private PackageResolver getPackageResolver() {
            PackageResolver packageResolver = VmContext.get(null).getPackageResolver();
            assert (packageResolver != null);
            return packageResolver;
        }

        private ProjectDependenciesManager getProjectDepsResolver() {
            ProjectDependenciesManager projectDepsManager = VmContext.get(null).getProjectDependenciesManager();
            assert (projectDepsManager != null);
            return projectDepsManager;
        }

        private @Nullable Path getLocalPath(Dependency dependency, PackageAssetUri packageAssetUri) {
            if (!(dependency instanceof Dependency.LocalDependency)) {
                return null;
            }
            return ((Dependency.LocalDependency)dependency).resolveAssetPath(this.getProjectDepsResolver().getProjectDir(), packageAssetUri);
        }
    }

    private static final class PackageResource
    implements ResourceReader {
        static final PackageResource INSTANCE = new PackageResource();

        private PackageResource() {
        }

        @Override
        public String getUriScheme() {
            return "package";
        }

        @Override
        public Optional<Object> read(URI uri) throws IOException, URISyntaxException, SecurityManagerException {
            PackageAssetUri assetUri = new PackageAssetUri(uri);
            byte[] bytes = this.getPackageResolver().getBytes(assetUri, true, null);
            return Optional.of(new Resource(uri, bytes));
        }

        @Override
        public boolean hasHierarchicalUris() {
            return true;
        }

        @Override
        public boolean isGlobbable() {
            return true;
        }

        @Override
        public boolean hasFragmentPaths() {
            return true;
        }

        @Override
        public List<PathElement> listElements(SecurityManager securityManager, URI baseUri) throws IOException, SecurityManagerException {
            securityManager.checkResolveResource(baseUri);
            PackageAssetUri packageAssetUri = PackageAssetUri.create(baseUri);
            return this.getPackageResolver().listElements(packageAssetUri, packageAssetUri.getPackageUri().getChecksums());
        }

        @Override
        public boolean hasElement(SecurityManager securityManager, URI elementUri) throws IOException, SecurityManagerException {
            securityManager.checkResolveResource(elementUri);
            PackageAssetUri packageAssetUri = PackageAssetUri.create(elementUri);
            return this.getPackageResolver().hasElement(packageAssetUri, packageAssetUri.getPackageUri().getChecksums());
        }

        private PackageResolver getPackageResolver() {
            PackageResolver packageResolver = VmContext.get(null).getPackageResolver();
            assert (packageResolver != null);
            return packageResolver;
        }
    }

    private static final class ModulePathResource
    implements ResourceReader {
        private final ModulePathResolver resolver;

        public ModulePathResource(ModulePathResolver resolver) {
            this.resolver = resolver;
        }

        @Override
        public String getUriScheme() {
            return "modulepath";
        }

        @Override
        public Optional<Object> read(URI uri) throws IOException, URISyntaxException {
            assert (uri.getScheme().equals("modulepath"));
            if (uri.getPath() == null) {
                throw new URISyntaxException(uri.toString(), ErrorMessages.create("invalidModuleUriMissingSlash", uri, "modulepath"));
            }
            try {
                Path path = this.resolver.resolve(uri);
                byte[] content = Files.readAllBytes(path);
                return Optional.of(new Resource(uri, content));
            }
            catch (FileNotFoundException e2) {
                return Optional.empty();
            }
        }

        @Override
        public boolean hasHierarchicalUris() {
            return true;
        }

        @Override
        public boolean isGlobbable() {
            return false;
        }

        @Override
        public boolean hasElement(SecurityManager securityManager, URI elementUri) throws SecurityManagerException {
            securityManager.checkResolveResource(elementUri);
            return this.resolver.hasElement(elementUri);
        }
    }

    private static final class ClassPathResource
    implements ResourceReader {
        private final ClassLoader classLoader;

        public ClassPathResource(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public String getUriScheme() {
            return "modulepath";
        }

        @Override
        public Optional<Object> read(URI uri) throws URISyntaxException {
            Optional<Object> optional;
            block10: {
                assert (uri.getScheme().equals("modulepath"));
                if (uri.getPath() == null) {
                    throw new URISyntaxException(uri.toString(), ErrorMessages.create("invalidModuleUriMissingSlash", uri, "modulepath"));
                }
                String path = ClassPathResource.getResourcePath(uri);
                InputStream stream = this.classLoader.getResourceAsStream(path);
                try {
                    Optional<Object> optional2 = optional = stream == null ? Optional.empty() : Optional.of(new Resource(uri, stream.readAllBytes()));
                    if (stream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e2) {
                        return Optional.empty();
                    }
                }
                stream.close();
            }
            return optional;
        }

        private static String getResourcePath(URI uri) {
            String path = uri.getPath();
            assert (path.charAt(0) == '/');
            return path.substring(1);
        }

        @Override
        public boolean hasHierarchicalUris() {
            return true;
        }

        @Override
        public boolean isGlobbable() {
            return false;
        }

        @Override
        public boolean hasElement(SecurityManager manager, URI uri) throws SecurityManagerException {
            manager.checkResolveResource(uri);
            String uriPath = uri.getPath();
            assert (uriPath.charAt(0) == '/');
            return this.classLoader.getResource(uriPath.substring(1)) != null;
        }
    }

    private static abstract class UrlResource
    implements ResourceReader {
        private UrlResource() {
        }

        @Override
        public Optional<Object> read(URI uri) throws IOException {
            try {
                URL url = IoUtils.toUrl(uri);
                byte[] content = IoUtils.readBytes(url);
                return Optional.of(new Resource(uri, content));
            }
            catch (FileNotFoundException e2) {
                return Optional.empty();
            }
        }

        @Override
        public boolean hasHierarchicalUris() {
            return true;
        }

        @Override
        public boolean isGlobbable() {
            return false;
        }
    }

    private static final class HttpsResource
    extends UrlResource {
        static final ResourceReader INSTANCE = new HttpsResource();

        private HttpsResource() {
        }

        @Override
        public String getUriScheme() {
            return "https";
        }

        @Override
        public boolean hasHierarchicalUris() {
            return true;
        }

        @Override
        public boolean isGlobbable() {
            return false;
        }
    }

    private static final class HttpResource
    extends UrlResource {
        static final ResourceReader INSTANCE = new HttpResource();

        private HttpResource() {
        }

        @Override
        public String getUriScheme() {
            return "http";
        }

        @Override
        public boolean hasHierarchicalUris() {
            return true;
        }

        @Override
        public boolean isGlobbable() {
            return false;
        }
    }

    private static final class FileResource
    extends UrlResource {
        static final ResourceReader INSTANCE = new FileResource();

        private FileResource() {
        }

        @Override
        public String getUriScheme() {
            return "file";
        }

        @Override
        public boolean hasHierarchicalUris() {
            return true;
        }

        @Override
        public boolean isGlobbable() {
            return true;
        }

        @Override
        public boolean hasElement(SecurityManager securityManager, URI elementUri) throws SecurityManagerException {
            securityManager.checkResolveResource(elementUri);
            return FileResolver.hasElement(elementUri);
        }

        @Override
        public List<PathElement> listElements(SecurityManager securityManager, URI baseUri) throws IOException, SecurityManagerException {
            securityManager.checkResolveResource(baseUri);
            return FileResolver.listElements(baseUri);
        }
    }

    private static final class ExternalProperty
    implements ResourceReader {
        static final ResourceReader INSTANCE = new ExternalProperty();

        private ExternalProperty() {
        }

        @Override
        public String getUriScheme() {
            return "prop";
        }

        @Override
        public Optional<Object> read(URI uri) {
            assert (uri.getScheme().equals("prop"));
            VmContext context = VmContext.get(null);
            String value2 = context.getExternalProperties().get(uri.getSchemeSpecificPart());
            return Optional.ofNullable(value2);
        }

        @Override
        public boolean hasHierarchicalUris() {
            return false;
        }

        @Override
        public boolean isGlobbable() {
            return true;
        }

        @Override
        public List<PathElement> listElements(SecurityManager securityManager, URI baseUri) throws SecurityManagerException {
            securityManager.checkResolveResource(baseUri);
            VmContext context = VmContext.get(null);
            ArrayList<PathElement> ret = new ArrayList<PathElement>();
            for (String propName : context.getExternalProperties().keySet()) {
                ret.add(PathElement.opaque(propName));
            }
            return ret;
        }
    }

    private static final class EnvironmentVariable
    implements ResourceReader {
        static final ResourceReader INSTANCE = new EnvironmentVariable();

        private EnvironmentVariable() {
        }

        @Override
        public String getUriScheme() {
            return "env";
        }

        @Override
        public Optional<Object> read(URI uri) {
            assert (uri.getScheme().equals("env"));
            VmContext context = VmContext.get(null);
            String value2 = context.getEnvironmentVariables().get(uri.getSchemeSpecificPart());
            return Optional.ofNullable(value2);
        }

        @Override
        public boolean hasHierarchicalUris() {
            return false;
        }

        @Override
        public boolean isGlobbable() {
            return true;
        }

        @Override
        public List<PathElement> listElements(SecurityManager securityManager, URI baseUri) throws SecurityManagerException {
            securityManager.checkResolveResource(baseUri);
            VmContext context = VmContext.get(null);
            ArrayList<PathElement> ret = new ArrayList<PathElement>();
            for (String envVarName : context.getEnvironmentVariables().keySet()) {
                ret.add(PathElement.opaque(envVarName));
            }
            return ret;
        }
    }
}

