/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.type;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.type.TypeNode;
import org.pkl.core.ast.type.UnresolvedTypeNode;
import org.pkl.core.ast.type.VmTypeMismatchException;
import org.pkl.core.util.LateInit;

public final class TypeCastNode
extends ExpressionNode {
    @Node.Child
    private ExpressionNode valueNode;
    @Node.Child
    private UnresolvedTypeNode unresolvedTypeNode;
    @Node.Child
    @LateInit
    private TypeNode typeNode;

    public TypeCastNode(SourceSection sourceSection, ExpressionNode valueNode, UnresolvedTypeNode unresolvedTypeNode) {
        super(sourceSection);
        this.valueNode = valueNode;
        this.unresolvedTypeNode = unresolvedTypeNode;
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        if (this.typeNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.typeNode = (TypeNode)this.insert(this.unresolvedTypeNode.execute(frame));
            this.unresolvedTypeNode = null;
        }
        Object value2 = this.valueNode.executeGeneric(frame);
        try {
            this.typeNode.execute(frame, value2);
            return value2;
        }
        catch (VmTypeMismatchException e2) {
            CompilerDirectives.transferToInterpreter();
            throw e2.toVmException();
        }
    }
}

