/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.frame;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.ExpressionNode;

@NodeChild(value="valueNode", type=ExpressionNode.class)
public abstract class WriteFrameSlotNode
extends ExpressionNode {
    private final int slot;

    public WriteFrameSlotNode(SourceSection sourceSection, int slot) {
        super(sourceSection);
        this.slot = slot;
    }

    public abstract void executeWithValue(VirtualFrame var1, Object var2);

    @Specialization(guards={"isIntOrIllegal(frame)"})
    protected long evalInt(VirtualFrame frame, long value2) {
        frame.getFrameDescriptor().setSlotKind(this.slot, FrameSlotKind.Long);
        frame.setLong(this.slot, value2);
        return value2;
    }

    @Specialization(guards={"isFloatOrIllegal(frame)"})
    protected double evalFloat(VirtualFrame frame, double value2) {
        frame.getFrameDescriptor().setSlotKind(this.slot, FrameSlotKind.Double);
        frame.setDouble(this.slot, value2);
        return value2;
    }

    @Specialization(guards={"isBooleanOrIllegal(frame)"})
    protected boolean evalBoolean(VirtualFrame frame, boolean value2) {
        frame.getFrameDescriptor().setSlotKind(this.slot, FrameSlotKind.Boolean);
        frame.setBoolean(this.slot, value2);
        return value2;
    }

    @Specialization(replaces={"evalInt", "evalFloat", "evalBoolean"})
    protected Object evalGeneric(VirtualFrame frame, Object value2) {
        frame.getFrameDescriptor().setSlotKind(this.slot, FrameSlotKind.Object);
        frame.setObject(this.slot, value2);
        return value2;
    }

    protected final boolean isIntOrIllegal(VirtualFrame frame) {
        FrameSlotKind kind = frame.getFrameDescriptor().getSlotKind(this.slot);
        return kind == FrameSlotKind.Long || kind == FrameSlotKind.Illegal;
    }

    protected final boolean isFloatOrIllegal(VirtualFrame frame) {
        FrameSlotKind kind = frame.getFrameDescriptor().getSlotKind(this.slot);
        return kind == FrameSlotKind.Double || kind == FrameSlotKind.Illegal;
    }

    protected final boolean isBooleanOrIllegal(VirtualFrame frame) {
        FrameSlotKind kind = frame.getFrameDescriptor().getSlotKind(this.slot);
        return kind == FrameSlotKind.Boolean || kind == FrameSlotKind.Illegal;
    }
}

