/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.frame;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.ExpressionNode;

public abstract class ReadFrameSlotNode
extends ExpressionNode {
    private final int slot;

    protected ReadFrameSlotNode(SourceSection sourceSection, int slot) {
        super(sourceSection);
        this.slot = slot;
    }

    @Specialization(rewriteOn={FrameSlotTypeException.class})
    protected long evalInt(VirtualFrame frame) throws FrameSlotTypeException {
        return frame.getLong(this.slot);
    }

    @Specialization(rewriteOn={FrameSlotTypeException.class})
    protected double evalFloat(VirtualFrame frame) throws FrameSlotTypeException {
        return frame.getDouble(this.slot);
    }

    @Specialization(rewriteOn={FrameSlotTypeException.class})
    protected boolean evalBoolean(VirtualFrame frame) throws FrameSlotTypeException {
        return frame.getBoolean(this.slot);
    }

    @Specialization(rewriteOn={FrameSlotTypeException.class})
    protected Object evalObject(VirtualFrame frame) throws FrameSlotTypeException {
        return frame.getObject(this.slot);
    }

    @Specialization(replaces={"evalInt", "evalFloat", "evalBoolean", "evalObject"})
    protected Object evalGeneric(VirtualFrame frame) {
        return frame.getValue(this.slot);
    }
}

