/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.unary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import java.net.URI;
import org.pkl.core.ast.expression.unary.UnaryExpressionNode;
import org.pkl.core.runtime.VmContext;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.LateInit;

public class StaticReadNode
extends UnaryExpressionNode {
    private final URI resourceUri;
    @CompilerDirectives.CompilationFinal
    @LateInit
    private Object readResult;

    public StaticReadNode(URI resourceUri) {
        super(VmUtils.unavailableSourceSection());
        assert (resourceUri.isAbsolute());
        this.resourceUri = resourceUri;
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        if (this.readResult == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            VmContext context = VmContext.get(this);
            this.readResult = context.getResourceManager().read(this.resourceUri, this).orElse(null);
            if (this.readResult == null) {
                throw this.exceptionBuilder().evalError("cannotFindResource", this.resourceUri).build();
            }
        }
        return this.readResult;
    }
}

