/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.unary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.source.SourceSection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.expression.unary.StaticReadNode;
import org.pkl.core.ast.expression.unary.UnaryExpressionNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.ast.member.UntypedObjectMemberNode;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.VmContext;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.GlobResolver;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.LateInit;

@NodeInfo(shortName="read*")
public abstract class ReadGlobNode
extends UnaryExpressionNode {
    private final VmLanguage language;
    private final ModuleKey currentModule;
    @CompilerDirectives.CompilationFinal
    @LateInit
    VmMapping readResult;

    protected ReadGlobNode(VmLanguage language, SourceSection sourceSection, ModuleKey currentModule) {
        super(sourceSection);
        this.currentModule = currentModule;
        this.language = language;
    }

    @CompilerDirectives.TruffleBoundary
    private URI doResolveUri(String globExpression) {
        try {
            URI globUri = IoUtils.toUri(globExpression);
            String tripleDotImport = IoUtils.parseTripleDotPath(globUri);
            if (tripleDotImport != null) {
                throw this.exceptionBuilder().evalError("cannotGlobTripleDots", new Object[0]).build();
            }
            return globUri;
        }
        catch (URISyntaxException e2) {
            throw this.exceptionBuilder().evalError("invalidResourceUri", globExpression).withHint(e2.getReason()).build();
        }
    }

    @CompilerDirectives.TruffleBoundary
    private EconomicMap<Object, ObjectMember> buildMembers(FrameDescriptor frameDescriptor, List<GlobResolver.ResolvedGlobElement> uris) {
        EconomicMap members = EconomicMaps.create();
        for (GlobResolver.ResolvedGlobElement entry : uris) {
            StaticReadNode readNode = new StaticReadNode(entry.getUri());
            ObjectMember member = new ObjectMember(VmUtils.unavailableSourceSection(), VmUtils.unavailableSourceSection(), 1024, null, "");
            UntypedObjectMemberNode memberNode = new UntypedObjectMemberNode(this.language, frameDescriptor, member, (ExpressionNode)readNode);
            member.initMemberNode(memberNode);
            EconomicMaps.put(members, entry.getPath(), member);
        }
        return members;
    }

    @Specialization
    public Object read(VirtualFrame frame, String globPattern) {
        if (this.readResult == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            VmContext context = VmContext.get(this);
            URI resolvedUri = this.doResolveUri(globPattern);
            List<GlobResolver.ResolvedGlobElement> uris = context.getResourceManager().resolveGlob(resolvedUri, this.currentModule.getUri(), this.currentModule, this, globPattern);
            EconomicMap<Object, ObjectMember> members = this.buildMembers(frame.getFrameDescriptor(), uris);
            this.readResult = new VmMapping(frame.materialize(), BaseModule.getMappingClass().getPrototype(), (UnmodifiableEconomicMap<Object, ObjectMember>)members);
        }
        return this.readResult;
    }
}

