/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.unary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.source.SourceSection;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.expression.unary.AbstractImportNode;
import org.pkl.core.ast.expression.unary.ImportNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.ast.member.UntypedObjectMemberNode;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.module.ResolvedModuleKey;
import org.pkl.core.packages.PackageLoadError;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.VmContext;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.GlobResolver;
import org.pkl.core.util.LateInit;

@NodeInfo(shortName="import*")
public class ImportGlobNode
extends AbstractImportNode {
    private final VmLanguage language;
    private final ResolvedModuleKey currentModule;
    private final String globPattern;
    @CompilerDirectives.CompilationFinal
    @LateInit
    private VmMapping importedMapping;

    public ImportGlobNode(VmLanguage language, SourceSection sourceSection, ResolvedModuleKey currentModule, URI importUri, String globPattern) {
        super(sourceSection, importUri);
        this.language = language;
        this.currentModule = currentModule;
        this.globPattern = globPattern;
    }

    @CompilerDirectives.TruffleBoundary
    private EconomicMap<Object, ObjectMember> buildMembers(FrameDescriptor frameDescriptor, List<GlobResolver.ResolvedGlobElement> uris) {
        EconomicMap members = EconomicMaps.create();
        for (GlobResolver.ResolvedGlobElement entry : uris) {
            ImportNode readNode = new ImportNode(this.language, VmUtils.unavailableSourceSection(), this.currentModule, entry.getUri());
            ObjectMember member = new ObjectMember(VmUtils.unavailableSourceSection(), VmUtils.unavailableSourceSection(), 1024, null, "");
            UntypedObjectMemberNode memberNode = new UntypedObjectMemberNode(this.language, frameDescriptor, member, (ExpressionNode)readNode);
            member.initMemberNode(memberNode);
            EconomicMaps.put(members, entry.getPath(), member);
        }
        return members;
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        if (this.importedMapping == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            VmContext context = VmContext.get(this);
            try {
                ModuleKey moduleKey = context.getModuleResolver().resolve(this.importUri);
                SecurityManager securityManager = VmContext.get(this).getSecurityManager();
                if (!moduleKey.isGlobbable()) {
                    throw this.exceptionBuilder().evalError("cannotGlobUri", this.importUri, this.importUri.getScheme()).build();
                }
                List<GlobResolver.ResolvedGlobElement> uris = GlobResolver.resolveGlob(securityManager, moduleKey, this.currentModule.getOriginal(), this.currentModule.getUri(), this.globPattern);
                EconomicMap<Object, ObjectMember> members = this.buildMembers(frame.getFrameDescriptor(), uris);
                this.importedMapping = new VmMapping(frame.materialize(), BaseModule.getMappingClass().getPrototype(), (UnmodifiableEconomicMap<Object, ObjectMember>)members);
            }
            catch (IOException e2) {
                throw this.exceptionBuilder().evalError("ioErrorResolvingGlob", this.importUri).withCause(e2).build();
            }
            catch (SecurityManagerException e3) {
                throw this.exceptionBuilder().withCause(e3).build();
            }
            catch (PackageLoadError e4) {
                throw this.exceptionBuilder().adhocEvalError(e4.getMessage(), new Object[0]).build();
            }
            catch (GlobResolver.InvalidGlobPatternException e5) {
                throw this.exceptionBuilder().evalError("invalidGlobPattern", this.globPattern).withHint(e5.getMessage()).build();
            }
        }
        return this.importedMapping;
    }
}

