/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.member;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmFunction;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmUtils;

public final class ReadSuperPropertyNode
extends ExpressionNode {
    private final Identifier propertyName;
    private final boolean needsConst;
    @Node.Child
    private IndirectCallNode callNode = IndirectCallNode.create();

    public ReadSuperPropertyNode(SourceSection sourceSection, Identifier propertyName, boolean needsConst) {
        super(sourceSection);
        this.propertyName = propertyName;
        this.needsConst = needsConst;
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        VmObjectLike receiver = VmUtils.getObjectReceiver((Frame)frame);
        VmObjectLike initialOwner = VmUtils.getOwner((Frame)frame);
        while (initialOwner instanceof VmFunction) {
            initialOwner = initialOwner.getEnclosingOwner();
        }
        assert (initialOwner != null) : "VmFunction always has a parent";
        for (VmObjectLike owner = initialOwner = initialOwner.getParent(); owner != null; owner = owner.getParent()) {
            ObjectMember property = owner.getMember(this.propertyName);
            if (property == null) continue;
            if (this.needsConst && !property.isConst()) {
                CompilerDirectives.transferToInterpreter();
                throw this.exceptionBuilder().evalError("propertyMustBeConst", this.propertyName.toString()).build();
            }
            Object constantValue = property.getConstantValue();
            if (constantValue != null) {
                return constantValue;
            }
            return this.callNode.call((CallTarget)property.getCallTarget(), new Object[]{receiver, owner, this.propertyName, VmUtils.SKIP_TYPECHECK_MARKER});
        }
        return VmDynamic.empty();
    }
}

