/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.member;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.member.ClassMethod;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmUtils;

public abstract class InvokeSuperMethodNode
extends ExpressionNode {
    private final Identifier methodName;
    @Node.Children
    private final ExpressionNode[] argumentNodes;
    private final boolean needsConst;

    protected InvokeSuperMethodNode(SourceSection sourceSection, Identifier methodName, ExpressionNode[] argumentNodes, boolean needsConst) {
        super(sourceSection);
        this.needsConst = needsConst;
        assert (!methodName.isLocalMethod());
        this.methodName = methodName;
        this.argumentNodes = argumentNodes;
    }

    @ExplodeLoop
    @Specialization
    protected Object eval(VirtualFrame frame, @Cached(value="findSupermethod(frame)") ClassMethod supermethod, @Cached(value="create(supermethod.getCallTarget(sourceSection))") DirectCallNode callNode) {
        if (this.needsConst && !supermethod.isConst()) {
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().evalError("methodMustBeConst", this.methodName.toString()).build();
        }
        Object[] args = new Object[2 + this.argumentNodes.length];
        args[0] = VmUtils.getReceiverOrNull((Frame)frame);
        args[1] = supermethod.getOwner();
        for (int i = 0; i < this.argumentNodes.length; ++i) {
            args[2 + i] = this.argumentNodes[i].executeGeneric(frame);
        }
        return callNode.call(args);
    }

    protected ClassMethod findSupermethod(VirtualFrame frame) {
        VmObjectLike owner = VmUtils.getOwner((Frame)frame);
        assert (owner.isPrototype());
        VmClass superclass = owner.getVmClass().getSuperclass();
        assert (superclass != null);
        ClassMethod supermethod = superclass.getMethod(this.methodName);
        if (supermethod != null) {
            return supermethod;
        }
        CompilerDirectives.transferToInterpreter();
        VmObjectLike parent = owner.getParent();
        assert (parent != null);
        throw this.exceptionBuilder().cannotFindMethod(parent, this.methodName, this.argumentNodes.length, false).build();
    }
}

