/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.source.SourceSection;
import java.math.RoundingMode;
import org.pkl.core.ast.expression.binary.BinaryExpressionNode;
import org.pkl.core.runtime.VmDataSize;
import org.pkl.core.runtime.VmDuration;
import org.pkl.core.runtime.VmException;
import org.pkl.core.util.MathUtils;

@NodeInfo(shortName="~/")
public abstract class TruncatingDivisionNode
extends BinaryExpressionNode {
    protected TruncatingDivisionNode(SourceSection sourceSection) {
        super(sourceSection);
    }

    @Specialization
    protected long eval(long left, long right) {
        if (right == 0L) {
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().evalError("divisionByZero", new Object[0]).build();
        }
        long result = left / right;
        if ((left & right & result) < 0L) {
            CompilerDirectives.transferToInterpreter();
            assert (left == Long.MIN_VALUE && right == -1L);
            throw this.exceptionBuilder().evalError("integerOverflow", new Object[0]).build();
        }
        return result;
    }

    @Specialization
    protected long eval(long left, double right) {
        return this.doTruncatingDivide(left, right);
    }

    @Specialization
    protected long eval(double left, long right) {
        return this.doTruncatingDivide(left, right);
    }

    @Specialization
    protected long eval(double left, double right) {
        return this.doTruncatingDivide(left, right);
    }

    @Specialization
    protected VmDuration eval(VmDuration left, long right) {
        long newValue = this.doTruncatingDivide(left.getValue(), right);
        return new VmDuration(newValue, left.getUnit());
    }

    @Specialization
    protected VmDuration eval(VmDuration left, double right) {
        long newValue = this.doTruncatingDivide(left.getValue(), right);
        return new VmDuration(newValue, left.getUnit());
    }

    @Specialization
    protected long eval(VmDuration left, VmDuration right) {
        if (left.getUnit().ordinal() <= right.getUnit().ordinal()) {
            return this.doTruncatingDivide(left.getValue(right.getUnit()), right.getValue());
        }
        return this.doTruncatingDivide(left.getValue(), right.getValue(left.getUnit()));
    }

    @Specialization
    protected VmDataSize eval(VmDataSize left, long right) {
        long value2 = this.doTruncatingDivide(left.getValue(), right);
        return new VmDataSize(value2, left.getUnit());
    }

    @Specialization
    protected VmDataSize eval(VmDataSize left, double right) {
        long newValue = this.doTruncatingDivide(left.getValue(), right);
        return new VmDataSize(newValue, left.getUnit());
    }

    @Specialization
    protected long eval(VmDataSize left, VmDataSize right) {
        if (left.getUnit().ordinal() <= right.getUnit().ordinal()) {
            double leftValue = left.convertTo(right.getUnit()).getValue();
            return this.doTruncatingDivide(leftValue, right.getValue());
        }
        double rightValue = right.convertTo(left.getUnit()).getValue();
        return this.doTruncatingDivide(left.getValue(), rightValue);
    }

    private long doTruncatingDivide(double x, double y) {
        try {
            return MathUtils.roundToLong(x / y, RoundingMode.DOWN);
        }
        catch (ArithmeticException e2) {
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().evalError(Double.isFinite(x) ? "cannotConvertLargeFloat" : "cannotConvertNonFiniteFloat", new VmException.ProgramValue("Float", x)).build();
        }
    }
}

