/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.builder;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.graalvm.collections.EconomicMap;
import org.pkl.core.DataSizeUnit;
import org.pkl.core.DurationUnit;
import org.pkl.core.PClassInfo;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.TypeParameter;
import org.pkl.core.ast.ConstantNode;
import org.pkl.core.ast.ConstantValueNode;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.MemberLookupMode;
import org.pkl.core.ast.MemberNode;
import org.pkl.core.ast.PklRootNode;
import org.pkl.core.ast.VmModifier;
import org.pkl.core.ast.builder.AbstractAstBuilder;
import org.pkl.core.ast.builder.CannotInvokeAbstractFunctionNode;
import org.pkl.core.ast.builder.CannotInvokeAbstractPropertyNode;
import org.pkl.core.ast.builder.ConstLevel;
import org.pkl.core.ast.builder.SymbolTable;
import org.pkl.core.ast.expression.binary.AdditionNodeGen;
import org.pkl.core.ast.expression.binary.DivisionNodeGen;
import org.pkl.core.ast.expression.binary.EqualNodeGen;
import org.pkl.core.ast.expression.binary.ExponentiationNodeGen;
import org.pkl.core.ast.expression.binary.GreaterThanNodeGen;
import org.pkl.core.ast.expression.binary.GreaterThanOrEqualNodeGen;
import org.pkl.core.ast.expression.binary.LessThanNodeGen;
import org.pkl.core.ast.expression.binary.LessThanOrEqualNodeGen;
import org.pkl.core.ast.expression.binary.LetExprNode;
import org.pkl.core.ast.expression.binary.LogicalAndNodeGen;
import org.pkl.core.ast.expression.binary.LogicalOrNodeGen;
import org.pkl.core.ast.expression.binary.MultiplicationNodeGen;
import org.pkl.core.ast.expression.binary.NotEqualNodeGen;
import org.pkl.core.ast.expression.binary.NullCoalescingNodeGen;
import org.pkl.core.ast.expression.binary.PipeNodeGen;
import org.pkl.core.ast.expression.binary.RemainderNodeGen;
import org.pkl.core.ast.expression.binary.SubscriptNodeGen;
import org.pkl.core.ast.expression.binary.SubtractionNodeGen;
import org.pkl.core.ast.expression.binary.TruncatingDivisionNodeGen;
import org.pkl.core.ast.expression.generator.GeneratorElementNode;
import org.pkl.core.ast.expression.generator.GeneratorElementNodeGen;
import org.pkl.core.ast.expression.generator.GeneratorEntryNodeGen;
import org.pkl.core.ast.expression.generator.GeneratorForNode;
import org.pkl.core.ast.expression.generator.GeneratorForNodeGen;
import org.pkl.core.ast.expression.generator.GeneratorMemberNode;
import org.pkl.core.ast.expression.generator.GeneratorObjectLiteralNode;
import org.pkl.core.ast.expression.generator.GeneratorObjectLiteralNodeGen;
import org.pkl.core.ast.expression.generator.GeneratorPredicateMemberNodeGen;
import org.pkl.core.ast.expression.generator.GeneratorPropertyNode;
import org.pkl.core.ast.expression.generator.GeneratorPropertyNodeGen;
import org.pkl.core.ast.expression.generator.GeneratorSpreadNodeGen;
import org.pkl.core.ast.expression.generator.GeneratorWhenNode;
import org.pkl.core.ast.expression.generator.WriteForVariablesNode;
import org.pkl.core.ast.expression.literal.AmendModuleNode;
import org.pkl.core.ast.expression.literal.AmendModuleNodeGen;
import org.pkl.core.ast.expression.literal.CheckIsAnnotationClassNode;
import org.pkl.core.ast.expression.literal.ConstantEntriesLiteralNodeGen;
import org.pkl.core.ast.expression.literal.ElementsEntriesLiteralNodeGen;
import org.pkl.core.ast.expression.literal.ElementsLiteralNodeGen;
import org.pkl.core.ast.expression.literal.EmptyObjectLiteralNodeGen;
import org.pkl.core.ast.expression.literal.EntriesLiteralNodeGen;
import org.pkl.core.ast.expression.literal.FalseLiteralNode;
import org.pkl.core.ast.expression.literal.FloatLiteralNode;
import org.pkl.core.ast.expression.literal.FunctionLiteralNode;
import org.pkl.core.ast.expression.literal.IntLiteralNode;
import org.pkl.core.ast.expression.literal.InterpolatedStringLiteralNode;
import org.pkl.core.ast.expression.literal.ListLiteralNode;
import org.pkl.core.ast.expression.literal.MapLiteralNode;
import org.pkl.core.ast.expression.literal.PropertiesLiteralNodeGen;
import org.pkl.core.ast.expression.literal.SetLiteralNode;
import org.pkl.core.ast.expression.literal.TrueLiteralNode;
import org.pkl.core.ast.expression.member.InferParentWithinMethodNode;
import org.pkl.core.ast.expression.member.InferParentWithinObjectMethodNode;
import org.pkl.core.ast.expression.member.InferParentWithinPropertyNodeGen;
import org.pkl.core.ast.expression.member.InvokeMethodVirtualNodeGen;
import org.pkl.core.ast.expression.member.InvokeSuperMethodNodeGen;
import org.pkl.core.ast.expression.member.ReadPropertyNodeGen;
import org.pkl.core.ast.expression.member.ReadSuperEntryNode;
import org.pkl.core.ast.expression.member.ReadSuperPropertyNode;
import org.pkl.core.ast.expression.member.ResolveMethodNode;
import org.pkl.core.ast.expression.primary.GetEnclosingOwnerNode;
import org.pkl.core.ast.expression.primary.GetEnclosingReceiverNode;
import org.pkl.core.ast.expression.primary.GetMemberKeyNode;
import org.pkl.core.ast.expression.primary.GetModuleNode;
import org.pkl.core.ast.expression.primary.GetOwnerNode;
import org.pkl.core.ast.expression.primary.GetReceiverNode;
import org.pkl.core.ast.expression.primary.OuterNode;
import org.pkl.core.ast.expression.primary.ResolveVariableNode;
import org.pkl.core.ast.expression.primary.ThisNode;
import org.pkl.core.ast.expression.ternary.IfElseNode;
import org.pkl.core.ast.expression.unary.AbstractImportNode;
import org.pkl.core.ast.expression.unary.ImportGlobNode;
import org.pkl.core.ast.expression.unary.ImportNode;
import org.pkl.core.ast.expression.unary.LogicalNotNodeGen;
import org.pkl.core.ast.expression.unary.NonNullNode;
import org.pkl.core.ast.expression.unary.NullPropagatingOperationNode;
import org.pkl.core.ast.expression.unary.PropagateNullReceiverNodeGen;
import org.pkl.core.ast.expression.unary.ReadGlobNodeGen;
import org.pkl.core.ast.expression.unary.ReadNodeGen;
import org.pkl.core.ast.expression.unary.ReadOrNullNodeGen;
import org.pkl.core.ast.expression.unary.ThrowNodeGen;
import org.pkl.core.ast.expression.unary.TraceNode;
import org.pkl.core.ast.expression.unary.UnaryMinusNodeGen;
import org.pkl.core.ast.internal.GetBaseModuleClassNode;
import org.pkl.core.ast.internal.GetClassNodeGen;
import org.pkl.core.ast.internal.ToStringNodeGen;
import org.pkl.core.ast.lambda.ApplyVmFunction1NodeGen;
import org.pkl.core.ast.member.ClassNode;
import org.pkl.core.ast.member.Lambda;
import org.pkl.core.ast.member.ModuleNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.ast.member.ObjectMethodNode;
import org.pkl.core.ast.member.TypeAliasNode;
import org.pkl.core.ast.member.UnresolvedFunctionNode;
import org.pkl.core.ast.member.UnresolvedMethodNode;
import org.pkl.core.ast.member.UnresolvedPropertyNode;
import org.pkl.core.ast.member.UntypedObjectMemberNode;
import org.pkl.core.ast.type.GetParentForTypeNode;
import org.pkl.core.ast.type.ResolveDeclaredTypeNode;
import org.pkl.core.ast.type.ResolveQualifiedDeclaredTypeNode;
import org.pkl.core.ast.type.ResolveSimpleDeclaredTypeNode;
import org.pkl.core.ast.type.TypeCastNode;
import org.pkl.core.ast.type.TypeConstraintNode;
import org.pkl.core.ast.type.TypeConstraintNodeGen;
import org.pkl.core.ast.type.TypeTestNode;
import org.pkl.core.ast.type.UnresolvedTypeNode;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.module.ModuleKeys;
import org.pkl.core.module.ResolvedModuleKey;
import org.pkl.core.packages.PackageLoadError;
import org.pkl.core.parser.antlr.PklParser;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.ModuleInfo;
import org.pkl.core.runtime.ModuleResolver;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmContext;
import org.pkl.core.runtime.VmDataSize;
import org.pkl.core.runtime.VmDuration;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmSet;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.stdlib.LanguageAwareNode;
import org.pkl.core.stdlib.registry.ExternalMemberRegistry;
import org.pkl.core.stdlib.registry.MemberRegistryFactory;
import org.pkl.core.util.CollectionUtils;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.Nullable;
import org.pkl.core.util.Pair;

public final class AstBuilder
extends AbstractAstBuilder<Object> {
    private final VmLanguage language;
    private final ModuleInfo moduleInfo;
    private final ModuleKey moduleKey;
    private final ModuleResolver moduleResolver;
    private final boolean isBaseModule;
    private final boolean isStdLibModule;
    private final ExternalMemberRegistry externalMemberRegistry;
    private final SymbolTable symbolTable;
    private final boolean isMethodReturnTypeChecked;

    public AstBuilder(Source source, VmLanguage language, ModuleInfo moduleInfo, ModuleResolver moduleResolver) {
        super(source);
        this.language = language;
        this.moduleInfo = moduleInfo;
        this.moduleKey = moduleInfo.getModuleKey();
        this.moduleResolver = moduleResolver;
        this.isBaseModule = ModuleKeys.isBaseModule(this.moduleKey);
        this.isStdLibModule = ModuleKeys.isStdLibModule(this.moduleKey);
        this.externalMemberRegistry = MemberRegistryFactory.get(this.moduleKey);
        this.symbolTable = new SymbolTable(moduleInfo);
        this.isMethodReturnTypeChecked = !this.isStdLibModule || IoUtils.isTestMode();
    }

    public static AstBuilder create(Source source, VmLanguage language, PklParser.ModuleContext ctx, ModuleKey moduleKey, ResolvedModuleKey resolvedModuleKey, ModuleResolver moduleResolver) {
        ModuleInfo moduleInfo;
        SourceSection docComment;
        PklParser.ModuleDeclContext moduleDecl = ctx.moduleDecl();
        PklParser.ModuleHeaderContext moduleHeader = moduleDecl != null ? moduleDecl.moduleHeader() : null;
        SourceSection sourceSection = AstBuilder.createSourceSection(source, ctx);
        SourceSection headerSection = moduleHeader != null ? AstBuilder.createSourceSection(source, moduleHeader) : source.createSection(0, 0);
        SourceSection sourceSection2 = docComment = moduleDecl != null ? AstBuilder.createSourceSection(source, moduleDecl.t) : null;
        if (moduleDecl == null) {
            String moduleName = IoUtils.inferModuleName(moduleKey);
            moduleInfo = new ModuleInfo(sourceSection, headerSection, null, moduleName, moduleKey, resolvedModuleKey, false);
        } else {
            PklParser.QualifiedIdentifierContext declaredModuleName = moduleDecl.moduleHeader().qualifiedIdentifier();
            String moduleName = declaredModuleName != null ? declaredModuleName.getText() : IoUtils.inferModuleName(moduleKey);
            PklParser.ModuleExtendsOrAmendsClauseContext clause = moduleDecl.moduleHeader().moduleExtendsOrAmendsClause();
            boolean isAmend = clause != null && clause.t.getType() == 2;
            moduleInfo = new ModuleInfo(sourceSection, headerSection, docComment, moduleName, moduleKey, resolvedModuleKey, isAmend);
        }
        return new AstBuilder(source, language, moduleInfo, moduleResolver);
    }

    @Override
    public PklRootNode visitModule(PklParser.ModuleContext ctx) {
        int modifiers;
        ExpressionNode[] annotationNodes;
        PklParser.ModuleDeclContext moduleDecl = ctx.moduleDecl();
        PklParser.ModuleHeaderContext moduleHeader = moduleDecl != null ? moduleDecl.moduleHeader() : null;
        ExpressionNode[] expressionNodeArray = annotationNodes = moduleDecl != null ? this.doVisitAnnotations(moduleDecl.annotation()) : new ExpressionNode[]{};
        if (moduleHeader == null) {
            modifiers = 0;
        } else {
            List<? extends PklParser.ModifierContext> modifierCtxs = moduleHeader.modifier();
            modifiers = this.doVisitModifiers(modifierCtxs, 3, "invalidModuleModifier");
            if (this.moduleInfo.isAmend()) {
                modifiers = this.doVisitModifiers(modifierCtxs, 0, "invalidAmendingModuleModifier");
            }
        }
        PklParser.ModuleExtendsOrAmendsClauseContext extendsOrAmendsClause = moduleHeader != null ? moduleHeader.moduleExtendsOrAmendsClause() : null;
        ExpressionNode supermoduleNode = extendsOrAmendsClause == null ? this.resolveBaseModuleClass(Identifier.MODULE, BaseModule::getModuleClass) : this.doVisitImport(15, extendsOrAmendsClause, extendsOrAmendsClause.stringConstant());
        HashSet<String> propertyNames = CollectionUtils.newHashSet(ctx.is.size() + ctx.cs.size() + ctx.ts.size() + ctx.ps.size());
        if (!this.moduleInfo.isAmend()) {
            UnresolvedTypeNode.Declared supertypeNode = new UnresolvedTypeNode.Declared(supermoduleNode.getSourceSection(), supermoduleNode);
            EconomicMap<Object, ObjectMember> moduleProperties = this.doVisitModuleProperties(ctx.is, ctx.cs, ctx.ts, List.of(), propertyNames, this.moduleInfo);
            UnresolvedPropertyNode[] unresolvedPropertyNodes = this.doVisitClassProperties(ctx.ps, propertyNames);
            ClassNode classNode = new ClassNode(this.moduleInfo.getSourceSection(), this.moduleInfo.getHeaderSection(), this.moduleInfo.getDocComment(), annotationNodes, modifiers, PClassInfo.forModuleClass(this.moduleInfo.getModuleName(), this.moduleInfo.getModuleKey().getUri()), List.of(), this.moduleInfo, supertypeNode, moduleProperties, unresolvedPropertyNodes, this.doVisitMethodDefs(ctx.ms));
            return new ModuleNode(this.language, this.moduleInfo.getSourceSection(), this.moduleInfo.getModuleName(), classNode);
        }
        EconomicMap<Object, ObjectMember> moduleProperties = this.doVisitModuleProperties(ctx.is, ctx.cs, ctx.ts, ctx.ps, propertyNames, this.moduleInfo);
        for (PklParser.ClassMethodContext methodCtx : ctx.ms) {
            ObjectMember localMethod = this.doVisitObjectMethod(methodCtx.methodHeader(), methodCtx.expr(), true);
            EconomicMaps.put(moduleProperties, localMethod.getName(), localMethod);
        }
        AmendModuleNode moduleNode = AmendModuleNodeGen.create(this.moduleInfo.getSourceSection(), this.language, annotationNodes, moduleProperties, this.moduleInfo, supermoduleNode);
        return new ModuleNode(this.language, this.moduleInfo.getSourceSection(), this.moduleInfo.getModuleName(), moduleNode);
    }

    @Override
    public ObjectMember visitClazz(PklParser.ClazzContext ctx) {
        PklParser.ClassHeaderContext headerCtx = ctx.classHeader();
        SourceSection sourceSection = this.createSourceSection(ctx);
        SourceSection headerSection = this.createSourceSection(headerCtx);
        PklParser.ClassBodyContext bodyCtx = ctx.classBody();
        if (bodyCtx != null) {
            this.checkClosingDelimiter(bodyCtx.err, "}", bodyCtx.stop);
        }
        Object typeParameters = this.visitTypeParameterList(headerCtx.typeParameterList());
        List<Object> propertyCtxs = bodyCtx == null ? List.of() : bodyCtx.ps;
        List<Object> methodCtxs = bodyCtx == null ? List.of() : bodyCtx.ms;
        int modifiers = this.doVisitModifiers(headerCtx.modifier(), 23, "invalidClassModifier") | 0x100;
        Identifier className = Identifier.property(headerCtx.Identifier().getText(), VmModifier.isLocal(modifiers));
        return this.symbolTable.enterClass(className, (List<TypeParameter>)typeParameters, arg_0 -> this.lambda$visitClazz$0(headerCtx, className, propertyCtxs, sourceSection, headerSection, ctx, modifiers, (List)typeParameters, methodCtxs, arg_0));
    }

    @Override
    public ObjectMember visitTypeAlias(PklParser.TypeAliasContext ctx) {
        PklParser.TypeAliasHeaderContext headerCtx = ctx.typeAliasHeader();
        SourceSection sourceSection = this.createSourceSection(ctx);
        SourceSection headerSection = this.createSourceSection(headerCtx);
        int modifiers = this.doVisitModifiers(headerCtx.modifier(), 20, "invalidTypeAliasModifier") | 0x200;
        boolean isLocal = VmModifier.isLocal(modifiers);
        Identifier name = Identifier.property(headerCtx.Identifier().getText(), isLocal);
        Object typeParameters = this.visitTypeParameterList(headerCtx.typeParameterList());
        return this.symbolTable.enterTypeAlias(name, (List<TypeParameter>)typeParameters, arg_0 -> this.lambda$visitTypeAlias$1(sourceSection, headerSection, ctx, modifiers, (List)typeParameters, isLocal, arg_0));
    }

    @Override
    public UnresolvedTypeNode[] visitTypeArgumentList( @Nullable PklParser.TypeArgumentListContext ctx) {
        if (ctx == null) {
            return new UnresolvedTypeNode[0];
        }
        this.checkCommaSeparatedElements(ctx, ctx.ts, ctx.errs);
        this.checkClosingDelimiter(ctx.err, ">", ctx.stop);
        UnresolvedTypeNode[] result = new UnresolvedTypeNode[ctx.ts.size()];
        for (int i = 0; i < ctx.ts.size(); ++i) {
            result[i] = (UnresolvedTypeNode)((Object)ctx.ts.get(i).accept(this));
        }
        return result;
    }

    @Override
    public List<TypeParameter> visitTypeParameterList( @Nullable PklParser.TypeParameterListContext ctx) {
        if (ctx == null) {
            return List.of();
        }
        this.checkCommaSeparatedElements(ctx, ctx.ts, ctx.errs);
        this.checkClosingDelimiter(ctx.err, ">", ctx.stop);
        if (!(ctx.parent instanceof PklParser.TypeAliasHeaderContext) && !this.isStdLibModule) {
            throw this.exceptionBuilder().evalError("cannotDeclareTypeParameter", new Object[0]).withSourceSection(this.createSourceSection(ctx.ts.get(0))).build();
        }
        int size = ctx.ts.size();
        ArrayList<TypeParameter> result = new ArrayList<TypeParameter>(size);
        for (int i = 0; i < size; ++i) {
            TypeParameter.Variance variance;
            PklParser.TypeParameterContext paramCtx = ctx.ts.get(i);
            if (paramCtx.t == null) {
                variance = TypeParameter.Variance.INVARIANT;
            } else if (paramCtx.t.getType() == 17) {
                variance = TypeParameter.Variance.CONTRAVARIANT;
            } else {
                assert (paramCtx.t.getType() == 26);
                variance = TypeParameter.Variance.COVARIANT;
            }
            String parameterName = paramCtx.Identifier().getText();
            if (result.stream().anyMatch(it -> it.getName().equals(parameterName))) {
                throw this.exceptionBuilder().evalError("duplicateTypeParameter", parameterName).withSourceSection(this.createSourceSection(paramCtx)).build();
            }
            result.add(new TypeParameter(variance, parameterName, i));
        }
        return result;
    }

    @Override
    public @Nullable UnresolvedTypeNode visitTypeAnnotation( @Nullable PklParser.TypeAnnotationContext ctx) {
        return ctx == null ? null : (UnresolvedTypeNode)((Object)ctx.type().accept(this));
    }

    @Override
    public Object visitNewExpr(PklParser.NewExprContext ctx) {
        PklParser.TypeContext typeCtx = ctx.type();
        return typeCtx != null ? this.doVisitNewExprWithExplicitParent(ctx, typeCtx) : this.doVisitNewExprWithInferredParent(ctx);
    }

    private Object doVisitNewExprWithExplicitParent(PklParser.NewExprContext ctx, PklParser.TypeContext typeCtx) {
        return this.doVisitObjectBody(ctx.objectBody(), (ExpressionNode)new GetParentForTypeNode(this.createSourceSection(ctx), this.visitType(typeCtx), this.symbolTable.getCurrentScope().getQualifiedName()));
    }

    private Object doVisitNewExprWithInferredParent(PklParser.NewExprContext ctx) {
        ExpressionNode inferredParentNode;
        PklParser.NewExprContext child = ctx;
        ParserRuleContext parent = ctx.getParent();
        SymbolTable.Scope scope = this.symbolTable.getCurrentScope();
        int levelsUp = 0;
        while (parent instanceof PklParser.IfExprContext || parent instanceof PklParser.TraceExprContext || parent instanceof PklParser.LetExprContext && ((PklParser.LetExprContext)parent).r == child) {
            if (parent instanceof PklParser.LetExprContext) {
                assert (scope != null);
                scope = scope.getParent();
                ++levelsUp;
            }
            child = parent;
            parent = parent.getParent();
        }
        assert (scope != null);
        if (parent instanceof PklParser.ClassPropertyContext || parent instanceof PklParser.ObjectPropertyContext) {
            inferredParentNode = InferParentWithinPropertyNodeGen.create(this.createSourceSection(ctx.t), scope.getName(), levelsUp == 0 ? new GetOwnerNode() : new GetEnclosingOwnerNode(levelsUp));
        } else if (parent instanceof PklParser.ObjectElementContext || parent instanceof PklParser.ObjectEntryContext && ((PklParser.ObjectEntryContext)parent).v == child) {
            inferredParentNode = ApplyVmFunction1NodeGen.create(ReadPropertyNodeGen.create(this.createSourceSection(ctx.t), Identifier.DEFAULT, levelsUp == 0 ? new GetReceiverNode() : new GetEnclosingReceiverNode(levelsUp)), new GetMemberKeyNode());
        } else if (parent instanceof PklParser.ClassMethodContext || parent instanceof PklParser.ObjectMethodContext) {
            boolean isObjectMethod = parent instanceof PklParser.ObjectMethodContext || parent.getParent() instanceof PklParser.ModuleContext && this.moduleInfo.isAmend();
            Identifier scopeName = scope.getName();
            inferredParentNode = isObjectMethod ? new InferParentWithinObjectMethodNode(this.createSourceSection(ctx.t), this.language, scopeName, levelsUp == 0 ? new GetOwnerNode() : new GetEnclosingOwnerNode(levelsUp)) : new InferParentWithinMethodNode(this.createSourceSection(ctx.t), this.language, scopeName, levelsUp == 0 ? new GetOwnerNode() : new GetEnclosingOwnerNode(levelsUp));
        } else {
            if (parent instanceof PklParser.LetExprContext && ((PklParser.LetExprContext)parent).l == child) {
                throw this.exceptionBuilder().evalError("cannotInferParent", new Object[0]).withSourceSection(this.createSourceSection(ctx.t)).build();
            }
            throw this.exceptionBuilder().evalError("cannotInferParent", new Object[0]).withSourceSection(this.createSourceSection(ctx.t)).build();
        }
        return this.doVisitObjectBody(ctx.objectBody(), inferredParentNode);
    }

    @Override
    public Object visitAmendExpr(PklParser.AmendExprContext ctx) {
        PklParser.ExprContext parentExpr = ctx.expr();
        if (!(parentExpr instanceof PklParser.NewExprContext || parentExpr instanceof PklParser.AmendExprContext || parentExpr instanceof PklParser.ParenthesizedExprContext)) {
            throw this.exceptionBuilder().evalError("unexpectedCurlyProbablyAmendsExpression", parentExpr.getText()).withSourceSection(this.createSourceSection(ctx.objectBody().start)).build();
        }
        return this.doVisitObjectBody(ctx.objectBody(), this.visitExpr(parentExpr));
    }

    @Override
    public UnresolvedPropertyNode visitClassProperty(PklParser.ClassPropertyContext ctx) {
        SourceSection docComment = this.createSourceSection(ctx.t);
        ExpressionNode[] annotationNodes = this.doVisitAnnotations(ctx.annotation());
        List<? extends PklParser.ModifierContext> modifierCtxs = ctx.modifier();
        TerminalNode identifier = ctx.Identifier();
        PklParser.TypeAnnotationContext typeAnnCtx = ctx.typeAnnotation();
        SourceSection sourceSection = this.createSourceSection(ctx);
        Token identifierSymbol = identifier.getSymbol();
        SourceSection headerSection = this.createSourceSection(!modifierCtxs.isEmpty() ? modifierCtxs.get((int)0).start : identifierSymbol, typeAnnCtx != null ? typeAnnCtx.getStop() : identifierSymbol);
        int modifiers = this.doVisitModifiers(ctx.modifier(), 125, "invalidPropertyModifier");
        boolean isLocal = VmModifier.isLocal(modifiers);
        Identifier propertyName = Identifier.property(identifier.getText(), isLocal);
        return this.symbolTable.enterProperty(propertyName, this.getConstLevel(modifiers), scope -> {
            ExpressionNode bodyNode;
            PklParser.ExprContext exprCtx = ctx.expr();
            List<? extends PklParser.ObjectBodyContext> objBodyCtx = ctx.objectBody();
            if (exprCtx != null) {
                if (VmModifier.isExternal(modifiers)) {
                    throw this.exceptionBuilder().evalError("externalMemberCannotHaveBody", new Object[0]).withSourceSection(headerSection).build();
                }
                if (VmModifier.isAbstract(modifiers)) {
                    throw this.exceptionBuilder().evalError("abstractMemberCannotHaveBody", new Object[0]).withSourceSection(headerSection).build();
                }
                bodyNode = this.visitExpr(exprCtx);
            } else if (objBodyCtx != null && !objBodyCtx.isEmpty()) {
                if (typeAnnCtx != null) {
                    throw this.exceptionBuilder().evalError("cannotAmendPropertyDefinition", new Object[0]).withSourceSection(this.createSourceSection(ctx)).build();
                }
                bodyNode = this.doVisitObjectBody(objBodyCtx, (ExpressionNode)new ReadSuperPropertyNode(AstBuilder.unavailableSourceSection(), scope.getName(), scope.getConstLevel() == ConstLevel.ALL));
            } else {
                if (isLocal) {
                    assert (typeAnnCtx != null);
                    throw this.missingLocalPropertyValue(typeAnnCtx);
                }
                if (VmModifier.isExternal(modifiers)) {
                    bodyNode = this.externalMemberRegistry.getPropertyBody(scope.getQualifiedName(), headerSection);
                    if (bodyNode instanceof LanguageAwareNode) {
                        ((LanguageAwareNode)((Object)bodyNode)).initLanguage(this.language);
                    }
                } else {
                    bodyNode = VmModifier.isAbstract(modifiers) ? new CannotInvokeAbstractPropertyNode(headerSection, scope.getQualifiedName()) : null;
                }
            }
            UnresolvedTypeNode typeAnnNode = this.visitTypeAnnotation(typeAnnCtx);
            return new UnresolvedPropertyNode(this.language, sourceSection, headerSection, this.createSourceSection(identifier), scope.buildFrameDescriptor(), docComment, annotationNodes, modifiers, scope.getName(), scope.getQualifiedName(), typeAnnNode, bodyNode);
        });
    }

    private VmException missingLocalPropertyValue(PklParser.TypeAnnotationContext typeAnnCtx) {
        int stop = typeAnnCtx.stop.getStopIndex();
        return this.exceptionBuilder().evalError("missingLocalPropertyValue", new Object[0]).withSourceSection(this.source.createSection(stop + 1, 0)).build();
    }

    private ObjectMember doVisitObjectProperty(PklParser.ObjectPropertyContext ctx) {
        return this.doVisitObjectProperty(ctx, ctx.modifier(), ctx.Identifier(), ctx.typeAnnotation(), ctx.expr(), ctx.objectBody());
    }

    private ObjectMember doVisitObjectMethod(PklParser.ObjectMethodContext ctx) {
        return this.doVisitObjectMethod(ctx.methodHeader(), ctx.expr(), false);
    }

    private ObjectMember doVisitObjectMethod(PklParser.MethodHeaderContext headerCtx, PklParser.ExprContext exprCtx, boolean isModuleMethod) {
        int modifiers = this.doVisitModifiers(headerCtx.modifier(), 4, "invalidObjectMemberModifier");
        if (!VmModifier.isLocal(modifiers)) {
            throw this.exceptionBuilder().evalError(isModuleMethod ? "moduleMethodMustBeLocal" : "objectMethodMustBeLocal", new Object[0]).withSourceSection(this.createSourceSection(headerCtx)).build();
        }
        Identifier methodName = Identifier.method(headerCtx.Identifier().getText(), true);
        PklParser.ParameterListContext paramListCtx = headerCtx.parameterList();
        FrameDescriptor.Builder frameDescriptorBuilder = this.createFrameDescriptorBuilder(paramListCtx);
        return this.symbolTable.enterMethod(methodName, this.getConstLevel(modifiers), frameDescriptorBuilder, List.of(), scope -> {
            if (headerCtx.typeParameterList() != null) {
                throw this.exceptionBuilder().evalError("cannotDeclareTypeParameter", new Object[0]).withSourceSection(this.createSourceSection(headerCtx.typeParameterList())).build();
            }
            ObjectMember member = new ObjectMember(this.createSourceSection(headerCtx.getParent()), this.createSourceSection(headerCtx), modifiers, scope.getName(), scope.getQualifiedName());
            ExpressionNode body = this.visitExpr(exprCtx);
            ObjectMethodNode node = new ObjectMethodNode(this.language, scope.buildFrameDescriptor(), member, body, paramListCtx.ts.size(), this.doVisitParameterTypes(paramListCtx), this.visitTypeAnnotation(headerCtx.typeAnnotation()));
            member.initMemberNode(node);
            return member;
        });
    }

    private ObjectMember doVisitObjectProperty(ParserRuleContext ctx, List<? extends PklParser.ModifierContext> modifierCtxs, TerminalNode propertyName,  @Nullable PklParser.TypeAnnotationContext typeAnnCtx,  @Nullable PklParser.ExprContext exprCtx, @Nullable List<? extends PklParser.ObjectBodyContext> bodyCtx) {
        return this.doVisitObjectProperty(this.createSourceSection(ctx), this.createSourceSection(propertyName), this.doVisitModifiers(modifierCtxs, 4, "invalidObjectMemberModifier"), propertyName.getText(), typeAnnCtx, exprCtx, bodyCtx);
    }

    private ObjectMember doVisitObjectProperty(SourceSection sourceSection, SourceSection headerSection, int modifiers, String propertyName,  @Nullable PklParser.TypeAnnotationContext typeAnnCtx,  @Nullable PklParser.ExprContext exprCtx, @Nullable List<? extends PklParser.ObjectBodyContext> bodyCtx) {
        boolean isLocal = VmModifier.isLocal(modifiers);
        Identifier identifier = Identifier.property(propertyName, isLocal);
        return this.symbolTable.enterProperty(identifier, this.getConstLevel(modifiers), scope -> {
            ExpressionNode bodyNode;
            if (isLocal) {
                if (exprCtx == null && typeAnnCtx != null) {
                    throw this.missingLocalPropertyValue(typeAnnCtx);
                }
            } else if (typeAnnCtx != null) {
                throw this.exceptionBuilder().evalError("nonLocalObjectPropertyCannotHaveTypeAnnotation", new Object[0]).withSourceSection(this.createSourceSection(typeAnnCtx.type())).build();
            }
            if (bodyCtx != null && !bodyCtx.isEmpty()) {
                if (isLocal) {
                    throw this.exceptionBuilder().evalError("cannotAmendLocalPropertyDefinition", new Object[0]).withSourceSection(this.createSourceSection(((PklParser.ObjectBodyContext)((Object)((Object)bodyCtx.get((int)0)))).start)).build();
                }
                bodyNode = this.doVisitObjectBody(bodyCtx, (ExpressionNode)new ReadSuperPropertyNode(AstBuilder.unavailableSourceSection(), scope.getName(), false));
            } else {
                assert (exprCtx != null);
                bodyNode = this.visitExpr(exprCtx);
            }
            return isLocal ? VmUtils.createLocalObjectProperty(this.language, sourceSection, headerSection, scope.getName(), scope.getQualifiedName(), scope.buildFrameDescriptor(), modifiers, bodyNode, this.visitTypeAnnotation(typeAnnCtx)) : VmUtils.createObjectProperty(this.language, sourceSection, headerSection, scope.getName(), scope.getQualifiedName(), scope.buildFrameDescriptor(), modifiers, bodyNode, null);
        });
    }

    private GeneratorMemberNode[] doVisitGeneratorMemberNodes(List<? extends PklParser.ObjectMemberContext> memberCtxs) {
        GeneratorMemberNode[] result = new GeneratorMemberNode[memberCtxs.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (GeneratorMemberNode)((Object)memberCtxs.get(i).accept(this));
        }
        return result;
    }

    private GeneratorObjectLiteralNode doVisitGeneratorObjectBody(PklParser.ObjectBodyContext ctx, ExpressionNode parentNode) {
        FrameDescriptor.Builder parametersDescriptor = this.createFrameDescriptorBuilder(ctx);
        UnresolvedTypeNode[] parameterTypes = this.doVisitParameterTypes(ctx);
        GeneratorMemberNode[] memberNodes = this.doVisitGeneratorMemberNodes(ctx.objectMember());
        SymbolTable.Scope currentScope = this.symbolTable.getCurrentScope();
        return GeneratorObjectLiteralNodeGen.create(this.createSourceSection(ctx.getParent()), this.language, currentScope.getQualifiedName(), currentScope.isCustomThisScope(), parametersDescriptor == null ? null : parametersDescriptor.build(), parameterTypes, memberNodes, parentNode);
    }

    @Override
    public GeneratorPropertyNode visitObjectProperty(PklParser.ObjectPropertyContext ctx) {
        this.checkHasNoForGenerator(ctx, "forGeneratorCannotGenerateProperties");
        ObjectMember member = this.doVisitObjectProperty(ctx);
        return GeneratorPropertyNodeGen.create(member);
    }

    @Override
    public GeneratorMemberNode visitObjectMethod(PklParser.ObjectMethodContext ctx) {
        this.checkHasNoForGenerator(ctx, "forGeneratorCannotGenerateMethods");
        ObjectMember member = this.doVisitObjectMethod(ctx);
        return GeneratorPropertyNodeGen.create(member);
    }

    private void checkHasNoForGenerator(ParserRuleContext ctx, String errorMessageKey) {
        if (this.symbolTable.getCurrentScope().getForGeneratorVariables().isEmpty()) {
            return;
        }
        ParserRuleContext forExprCtx = ctx.getParent();
        while (forExprCtx.getClass() != PklParser.ForGeneratorContext.class) {
            forExprCtx = forExprCtx.getParent();
        }
        throw this.exceptionBuilder().evalError(errorMessageKey, new Object[0]).withSourceSection(this.createSourceSection(((PklParser.ForGeneratorContext)forExprCtx).FOR())).build();
    }

    @Override
    public GeneratorMemberNode visitMemberPredicate(PklParser.MemberPredicateContext ctx) {
        Pair<ExpressionNode, ObjectMember> keyNodeAndMember = this.doVisitMemberPredicate(ctx);
        ExpressionNode keyNode = (ExpressionNode)((Object)keyNodeAndMember.first);
        ObjectMember member = (ObjectMember)keyNodeAndMember.second;
        this.insertWriteForGeneratorVarsToFrameSlotsNode(member.getMemberNode());
        return GeneratorPredicateMemberNodeGen.create(keyNode, member);
    }

    @Override
    public GeneratorMemberNode visitObjectEntry(PklParser.ObjectEntryContext ctx) {
        Pair<ExpressionNode, ObjectMember> keyNodeAndMember = this.doVisitObjectEntry(ctx);
        ExpressionNode keyNode = (ExpressionNode)((Object)keyNodeAndMember.first);
        ObjectMember member = (ObjectMember)keyNodeAndMember.second;
        this.insertWriteForGeneratorVarsToFrameSlotsNode(member.getMemberNode());
        return GeneratorEntryNodeGen.create(keyNode, member);
    }

    @Override
    public GeneratorMemberNode visitObjectSpread(PklParser.ObjectSpreadContext ctx) {
        return GeneratorSpreadNodeGen.create(this.createSourceSection(ctx), this.visitExpr(ctx.expr()), ctx.QSPREAD() != null);
    }

    private void insertWriteForGeneratorVarsToFrameSlotsNode(@Nullable MemberNode memberNode) {
        if (memberNode == null) {
            return;
        }
        FrameDescriptor descriptor = memberNode.getFrameDescriptor();
        Deque<Identifier> forGeneratorVars = this.symbolTable.getCurrentScope().getForGeneratorVariables();
        if (forGeneratorVars.isEmpty()) {
            return;
        }
        int[] slots = new int[forGeneratorVars.size()];
        int i = 0;
        for (Identifier variable : forGeneratorVars) {
            slots[i] = descriptor.findOrAddAuxiliarySlot((Object)variable);
            ++i;
        }
        memberNode.replaceBody(bodyNode -> new WriteForVariablesNode(slots, (ExpressionNode)((Object)bodyNode)));
    }

    @Override
    public GeneratorElementNode visitObjectElement(PklParser.ObjectElementContext ctx) {
        ObjectMember member = this.doVisitObjectElement(ctx);
        this.insertWriteForGeneratorVarsToFrameSlotsNode(member.getMemberNode());
        return GeneratorElementNodeGen.create(member);
    }

    private GeneratorMemberNode[] doVisitForWhenBody(PklParser.ObjectBodyContext ctx) {
        if (!ctx.ps.isEmpty()) {
            throw this.exceptionBuilder().evalError("forWhenBodyCannotHaveParameters", new Object[0]).withSourceSection(this.createSourceSection(ctx.ps.get(0))).build();
        }
        return this.doVisitGeneratorMemberNodes(ctx.objectMember());
    }

    @Override
    public GeneratorWhenNode visitWhenGenerator(PklParser.WhenGeneratorContext ctx) {
        this.checkClosingDelimiter(ctx.err, ")", ctx.e.stop);
        SourceSection sourceSection = this.createSourceSection(ctx);
        GeneratorMemberNode[] thenNodes = this.doVisitForWhenBody(ctx.b1);
        GeneratorMemberNode[] elseNodes = ctx.b2 == null ? new GeneratorMemberNode[]{} : this.doVisitForWhenBody(ctx.b2);
        return new GeneratorWhenNode(sourceSection, this.visitExpr(ctx.e), thenNodes, elseNodes);
    }

    private int pushForGeneratorVariableContext(PklParser.ParameterContext ctx) {
        SymbolTable.Scope currentScope = this.symbolTable.getCurrentScope();
        int slot = currentScope.pushForGeneratorVariableContext(ctx);
        if (slot == -1) {
            throw this.exceptionBuilder().evalError("duplicateDefinition", ctx.typedIdentifier().Identifier().getText()).withSourceSection(this.createSourceSection(ctx)).build();
        }
        return slot;
    }

    private static boolean isIgnored( @Nullable PklParser.ParameterContext param) {
        return param != null && param.UNDERSCORE() != null;
    }

    @Override
    public GeneratorForNode visitForGenerator(PklParser.ForGeneratorContext ctx) {
        UnresolvedTypeNode unresolvedValueTypeNode;
        UnresolvedTypeNode unresolvedKeyTypeNode;
        int valueVariableSlot;
        int keyVariableSlot;
        boolean ignoreT2;
        this.checkClosingDelimiter(ctx.err, ")", ctx.e.stop);
        SourceSection sourceSection = this.createSourceSection(ctx);
        SymbolTable.Scope currentScope = this.symbolTable.getCurrentScope();
        boolean ignoreT1 = AstBuilder.isIgnored(ctx.t1);
        boolean bl = ignoreT2 = ctx.t2 == null ? ignoreT1 : AstBuilder.isIgnored(ctx.t2);
        if (ctx.t2 != null) {
            keyVariableSlot = ignoreT1 ? -1 : this.pushForGeneratorVariableContext(ctx.t1);
            valueVariableSlot = ignoreT2 ? -1 : this.pushForGeneratorVariableContext(ctx.t2);
            unresolvedKeyTypeNode = ignoreT1 ? null : this.visitTypeAnnotation(ctx.t1.typedIdentifier().typeAnnotation());
            unresolvedValueTypeNode = ignoreT2 ? null : this.visitTypeAnnotation(ctx.t2.typedIdentifier().typeAnnotation());
        } else {
            keyVariableSlot = -1;
            valueVariableSlot = ignoreT1 ? -1 : this.pushForGeneratorVariableContext(ctx.t1);
            unresolvedKeyTypeNode = null;
            unresolvedValueTypeNode = ignoreT1 ? null : this.visitTypeAnnotation(ctx.t1.typedIdentifier().typeAnnotation());
        }
        ExpressionNode iterableNode = this.visitExpr(ctx.e);
        GeneratorMemberNode[] memberNodes = this.doVisitForWhenBody(ctx.objectBody());
        if (keyVariableSlot != -1) {
            currentScope.popForGeneratorVariable();
        }
        if (valueVariableSlot != -1) {
            currentScope.popForGeneratorVariable();
        }
        return GeneratorForNodeGen.create(sourceSection, keyVariableSlot, valueVariableSlot, iterableNode, unresolvedKeyTypeNode, unresolvedValueTypeNode, memberNodes, ctx.t2 != null && !ignoreT1, !ignoreT2);
    }

    private void checkSpaceSeparatedObjectMembers(PklParser.ObjectBodyContext objectBodyContext) {
        assert (objectBodyContext.objectMember() != null);
        if (objectBodyContext.objectMember().size() < 2) {
            return;
        }
        PklParser.ObjectMemberContext prevMember = null;
        for (PklParser.ObjectMemberContext objectMemberContext : objectBodyContext.objectMember()) {
            int prevStopIndex;
            if (prevMember == null) {
                prevMember = objectMemberContext;
                continue;
            }
            int startIndex = objectMemberContext.getStart().getStartIndex();
            if (startIndex - (prevStopIndex = prevMember.getStop().getStopIndex()) != 1) continue;
            throw this.exceptionBuilder().evalError("unseparatedObjectMembers", new Object[0]).withSourceSection(this.createSourceSection(objectMemberContext)).build();
        }
    }

    private ExpressionNode doVisitObjectBody(List<? extends PklParser.ObjectBodyContext> ctxs, ExpressionNode parentNode) {
        for (PklParser.ObjectBodyContext objectBodyContext : ctxs) {
            parentNode = this.doVisitObjectBody(objectBodyContext, parentNode);
        }
        return parentNode;
    }

    private ExpressionNode doVisitObjectBody(PklParser.ObjectBodyContext ctx, ExpressionNode parentNode) {
        this.checkClosingDelimiter(ctx.err, "}", ctx.stop);
        return this.symbolTable.enterObjectScope(scope -> {
            FrameDescriptor frameDescriptor;
            List<? extends PklParser.ObjectMemberContext> objectMemberCtx = ctx.objectMember();
            if (objectMemberCtx.isEmpty()) {
                return EmptyObjectLiteralNodeGen.create(this.createSourceSection(ctx.getParent()), parentNode);
            }
            SourceSection sourceSection = this.createSourceSection(ctx.getParent());
            FrameDescriptor.Builder parametersDescriptorBuilder = this.createFrameDescriptorBuilder(ctx);
            UnresolvedTypeNode[] parameterTypes = this.doVisitParameterTypes(ctx);
            EconomicMap members = EconomicMaps.create();
            ArrayList<ObjectMember> elements = new ArrayList<ObjectMember>();
            ArrayList<ExpressionNode> keyNodes = new ArrayList<ExpressionNode>();
            ArrayList<ObjectMember> values2 = new ArrayList<ObjectMember>();
            boolean isConstantKeyNodes = true;
            this.checkSpaceSeparatedObjectMembers(ctx);
            for (PklParser.ObjectMemberContext objectMemberContext : objectMemberCtx) {
                if (objectMemberContext instanceof PklParser.ObjectPropertyContext) {
                    PklParser.ObjectPropertyContext propertyCtx = (PklParser.ObjectPropertyContext)objectMemberContext;
                    this.addProperty(members, this.doVisitObjectProperty(propertyCtx));
                    continue;
                }
                if (objectMemberContext instanceof PklParser.ObjectEntryContext) {
                    PklParser.ObjectEntryContext entryCtx = (PklParser.ObjectEntryContext)objectMemberContext;
                    Pair<ExpressionNode, ObjectMember> keyAndValue = this.doVisitObjectEntry(entryCtx);
                    ExpressionNode key2 = (ExpressionNode)((Object)((Object)keyAndValue.first));
                    keyNodes.add(key2);
                    isConstantKeyNodes = isConstantKeyNodes && key2 instanceof ConstantNode;
                    values2.add((ObjectMember)keyAndValue.second);
                    continue;
                }
                if (objectMemberContext instanceof PklParser.ObjectElementContext) {
                    PklParser.ObjectElementContext elementCtx = (PklParser.ObjectElementContext)objectMemberContext;
                    ObjectMember element = this.doVisitObjectElement(elementCtx);
                    elements.add(element);
                    continue;
                }
                if (objectMemberContext instanceof PklParser.ObjectMethodContext) {
                    PklParser.ObjectMethodContext methodCtx = (PklParser.ObjectMethodContext)objectMemberContext;
                    this.addProperty(members, this.doVisitObjectMethod(methodCtx));
                    continue;
                }
                assert (objectMemberContext instanceof PklParser.ForGeneratorContext || objectMemberContext instanceof PklParser.WhenGeneratorContext || objectMemberContext instanceof PklParser.MemberPredicateContext || objectMemberContext instanceof PklParser.ObjectSpreadContext);
                return this.doVisitGeneratorObjectBody(ctx, parentNode);
            }
            SymbolTable.Scope currentScope = this.symbolTable.getCurrentScope();
            FrameDescriptor frameDescriptor2 = frameDescriptor = parametersDescriptorBuilder == null ? null : parametersDescriptorBuilder.build();
            if (!elements.isEmpty()) {
                if (isConstantKeyNodes) {
                    this.addConstantEntries(members, keyNodes, values2);
                    return ElementsLiteralNodeGen.create(sourceSection, this.language, currentScope.getQualifiedName(), currentScope.isCustomThisScope(), frameDescriptor, parameterTypes, members, elements.toArray(new ObjectMember[0]), parentNode);
                }
                return ElementsEntriesLiteralNodeGen.create(sourceSection, this.language, currentScope.getQualifiedName(), currentScope.isCustomThisScope(), frameDescriptor, parameterTypes, members, elements.toArray(new ObjectMember[0]), keyNodes.toArray(new ExpressionNode[0]), values2.toArray(new ObjectMember[0]), parentNode);
            }
            if (!keyNodes.isEmpty()) {
                if (isConstantKeyNodes) {
                    this.addConstantEntries(members, keyNodes, values2);
                    return ConstantEntriesLiteralNodeGen.create(sourceSection, this.language, currentScope.getQualifiedName(), currentScope.isCustomThisScope(), frameDescriptor, parameterTypes, members, parentNode);
                }
                return EntriesLiteralNodeGen.create(sourceSection, this.language, currentScope.getQualifiedName(), currentScope.isCustomThisScope(), frameDescriptor, parameterTypes, members, keyNodes.toArray(new ExpressionNode[0]), values2.toArray(new ObjectMember[0]), parentNode);
            }
            return PropertiesLiteralNodeGen.create(sourceSection, this.language, currentScope.getQualifiedName(), currentScope.isCustomThisScope(), frameDescriptor, parameterTypes, members, parentNode);
        });
    }

    private void addConstantEntries(EconomicMap<Object, ObjectMember> members, List<ExpressionNode> keyNodes, List<ObjectMember> values2) {
        for (int i = 0; i < keyNodes.size(); ++i) {
            ObjectMember value2;
            Object key2 = ((ConstantNode)((Object)keyNodes.get(i))).getValue();
            ObjectMember previousValue = EconomicMaps.put(members, key2, value2 = values2.get(i));
            if (previousValue == null) continue;
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().evalError("duplicateDefinition", new VmException.ProgramValue("", key2)).withSourceSection(value2.getHeaderSection()).build();
        }
    }

    private ObjectMember doVisitObjectElement(PklParser.ObjectElementContext ctx) {
        return this.symbolTable.enterEntry(null, scope -> {
            ExpressionNode elementNode = this.visitExpr(ctx.expr());
            ObjectMember member = new ObjectMember(this.createSourceSection(ctx), elementNode.getSourceSection(), 2048, null, scope.getQualifiedName());
            if (elementNode instanceof ConstantNode) {
                member.initConstantValue((ConstantNode)((Object)elementNode));
            } else {
                member.initMemberNode(new UntypedObjectMemberNode(this.language, scope.buildFrameDescriptor(), member, elementNode));
            }
            return member;
        });
    }

    private Pair<ExpressionNode, ObjectMember> doVisitMemberPredicate(PklParser.MemberPredicateContext ctx) {
        if (ctx.err1 == null && ctx.err2 == null) {
            throw this.missingDelimiter("]]", ctx.k.stop.getStopIndex() + 1);
        }
        if (ctx.err1 != null && (ctx.err2 == null || ctx.err1.getStartIndex() != ctx.err2.getStartIndex() - 1)) {
            throw this.wrongDelimiter("]]", "]", ctx.err1.getStartIndex());
        }
        ExpressionNode keyNode = this.symbolTable.enterCustomThisScope(scope -> this.visitExpr(ctx.k));
        return this.symbolTable.enterEntry(keyNode, this.objectMemberInserter(this.createSourceSection(ctx), keyNode, ctx.v, ctx.objectBody()));
    }

    private Pair<ExpressionNode, ObjectMember> doVisitObjectEntry(PklParser.ObjectEntryContext ctx) {
        this.checkClosingDelimiter(ctx.err1, "]", ctx.k.stop);
        if (ctx.err2 != null) {
            throw ctx.err1.getStartIndex() == ctx.err2.getStartIndex() - 1 ? this.wrongDelimiter("]", "]]", ctx.err1.getStartIndex()) : this.danglingDelimiter("]", ctx.err2.getStartIndex());
        }
        ExpressionNode keyNode = this.visitExpr(ctx.k);
        return this.symbolTable.enterEntry(keyNode, this.objectMemberInserter(this.createSourceSection(ctx), keyNode, ctx.v, ctx.objectBody()));
    }

    private Function<SymbolTable.EntryScope, Pair<ExpressionNode, ObjectMember>> objectMemberInserter(SourceSection sourceSection, ExpressionNode keyNode,  @Nullable PklParser.ExprContext valueCtx, List<? extends PklParser.ObjectBodyContext> objectBodyCtxs) {
        return scope -> {
            ObjectMember member = new ObjectMember(sourceSection, keyNode.getSourceSection(), 1024, null, scope.getQualifiedName());
            if (valueCtx != null) {
                ExpressionNode valueNode = this.visitExpr(valueCtx);
                if (valueNode instanceof ConstantNode) {
                    member.initConstantValue((ConstantNode)((Object)valueNode));
                } else {
                    member.initMemberNode(new UntypedObjectMemberNode(this.language, scope.buildFrameDescriptor(), member, valueNode));
                }
            } else {
                ExpressionNode objectBody = this.doVisitObjectBody(objectBodyCtxs, (ExpressionNode)new ReadSuperEntryNode(AstBuilder.unavailableSourceSection(), new GetMemberKeyNode()));
                member.initMemberNode(new UntypedObjectMemberNode(this.language, scope.buildFrameDescriptor(), member, objectBody));
            }
            return Pair.of(keyNode, member);
        };
    }

    @Override
    public ExpressionNode visitAnnotation(PklParser.AnnotationContext ctx) {
        CheckIsAnnotationClassNode verifyNode = new CheckIsAnnotationClassNode(this.visitType(ctx.type()));
        PklParser.ObjectBodyContext bodyCtx = ctx.objectBody();
        if (bodyCtx == null) {
            SymbolTable.Scope currentScope = this.symbolTable.getCurrentScope();
            return PropertiesLiteralNodeGen.create(this.createSourceSection(ctx), this.language, currentScope.getQualifiedName(), currentScope.isCustomThisScope(), null, new UnresolvedTypeNode[0], EconomicMaps.create(), verifyNode);
        }
        return this.symbolTable.enterAnnotationScope(scope -> this.doVisitObjectBody(bodyCtx, (ExpressionNode)verifyNode));
    }

    private ExpressionNode[] doVisitAnnotations(List<? extends PklParser.AnnotationContext> ctxs) {
        return (ExpressionNode[])ctxs.stream().map(this::visitAnnotation).toArray(ExpressionNode[]::new);
    }

    @Override
    public Integer visitModifier(PklParser.ModifierContext ctx) {
        switch (ctx.t.getType()) {
            case 8: {
                return 16;
            }
            case 1: {
                return 1;
            }
            case 25: {
                return 2;
            }
            case 20: {
                return 4;
            }
            case 13: {
                return 8;
            }
            case 10: {
                return 32;
            }
            case 5: {
                return 64;
            }
        }
        throw this.createUnexpectedTokenError(ctx.t);
    }

    private int doVisitModifiers(List<? extends PklParser.ModifierContext> contexts, int validModifiers, String errorMessage) {
        int result = 0;
        for (PklParser.ModifierContext modifierContext : contexts) {
            int modifier = this.visitModifier(modifierContext);
            if ((modifier & validModifiers) == 0) {
                throw this.exceptionBuilder().evalError(errorMessage, modifierContext.t.getText()).withSourceSection(this.createSourceSection(modifierContext)).build();
            }
            result += modifier;
        }
        if (VmModifier.isExternal(result) && !ModuleKeys.isStdLibModule(this.moduleKey)) {
            throw this.exceptionBuilder().evalError("cannotDefineExternalMember", new Object[0]).withSourceSection(this.createSourceSection(contexts, 8)).build();
        }
        if (VmModifier.isLocal(result) && VmModifier.isHidden(result)) {
            throw this.exceptionBuilder().evalError("redundantHiddenModifier", new Object[0]).withSourceSection(this.createSourceSection(contexts, 13)).build();
        }
        if (VmModifier.isLocal(result) && VmModifier.isFixed(result)) {
            throw this.exceptionBuilder().evalError("redundantFixedModifier", new Object[0]).withSourceSection(this.createSourceSection(contexts, 10)).build();
        }
        if (VmModifier.isAbstract(result) && VmModifier.isOpen(result)) {
            throw this.exceptionBuilder().evalError("redundantOpenModifier", new Object[0]).withSourceSection(this.createSourceSection(contexts, 25)).build();
        }
        return result;
    }

    @Override
    public UnresolvedMethodNode visitClassMethod(PklParser.ClassMethodContext ctx) {
        PklParser.MethodHeaderContext headerCtx = ctx.methodHeader();
        SourceSection headerSection = this.createSourceSection(headerCtx);
        Object typeParameters = this.visitTypeParameterList(headerCtx.typeParameterList());
        int modifiers = this.doVisitModifiers(headerCtx.modifier(), 85, "invalidMethodModifier");
        boolean isLocal = VmModifier.isLocal(modifiers);
        Identifier methodName = Identifier.method(headerCtx.Identifier().getText(), isLocal);
        PklParser.ExprContext bodyContext = ctx.expr();
        PklParser.ParameterListContext paramListCtx = headerCtx.parameterList();
        FrameDescriptor.Builder descriptorBuilder = this.createFrameDescriptorBuilder(paramListCtx);
        int paramCount = paramListCtx.ts.size();
        return this.symbolTable.enterMethod(methodName, this.getConstLevel(modifiers), descriptorBuilder, (List<TypeParameter>)typeParameters, arg_0 -> this.lambda$visitClassMethod$13(bodyContext, modifiers, headerSection, paramCount, methodName, ctx, (List)typeParameters, paramListCtx, headerCtx, arg_0));
    }

    @Override
    public ExpressionNode visitFunctionLiteral(PklParser.FunctionLiteralContext ctx) {
        SourceSection sourceSection = this.createSourceSection(ctx);
        PklParser.ParameterListContext paramCtx = ctx.parameterList();
        FrameDescriptor.Builder descriptorBuilder = this.createFrameDescriptorBuilder(paramCtx);
        int paramCount = paramCtx.ts.size();
        if (paramCount > 5) {
            throw this.exceptionBuilder().evalError("tooManyFunctionParameters", new Object[0]).withSourceSection(sourceSection).build();
        }
        boolean isCustomThisScope = this.symbolTable.getCurrentScope().isCustomThisScope();
        return this.symbolTable.enterLambda(descriptorBuilder, scope -> {
            ExpressionNode expr = this.visitExpr(ctx.expr());
            UnresolvedFunctionNode functionNode = new UnresolvedFunctionNode(this.language, scope.buildFrameDescriptor(), new Lambda(sourceSection, scope.getQualifiedName()), paramCount, this.doVisitParameterTypes(paramCtx), null, expr);
            return new FunctionLiteralNode(sourceSection, functionNode, isCustomThisScope);
        });
    }

    @Override
    public ConstantValueNode visitNullLiteral(PklParser.NullLiteralContext ctx) {
        return new ConstantValueNode(this.createSourceSection(ctx), VmNull.withoutDefault());
    }

    @Override
    public ExpressionNode visitTrueLiteral(PklParser.TrueLiteralContext ctx) {
        return new TrueLiteralNode(this.createSourceSection(ctx));
    }

    @Override
    public Object visitFalseLiteral(PklParser.FalseLiteralContext ctx) {
        return new FalseLiteralNode(this.createSourceSection(ctx));
    }

    @Override
    public IntLiteralNode visitIntLiteral(PklParser.IntLiteralContext ctx) {
        SourceSection section = this.createSourceSection(ctx);
        Object text = ctx.IntLiteral().getText();
        int radix = 10;
        if (((String)text).startsWith("0x") || ((String)text).startsWith("0b") || ((String)text).startsWith("0o")) {
            char type = ((String)text).charAt(1);
            radix = type == 'x' ? 16 : (type == 'b' ? 2 : 8);
            if (((String)(text = ((String)text).substring(2))).startsWith("_")) {
                this.invalidSeparatorPosition(this.source.createSection(ctx.getStart().getStartIndex() + 2, 1));
            }
        }
        if (ctx.getParent() instanceof PklParser.UnaryMinusExprContext) {
            text = "-" + (String)text;
        }
        text = ((String)text).replaceAll("_", "");
        try {
            long num = Long.parseLong((String)text, radix);
            return new IntLiteralNode(section, num);
        }
        catch (NumberFormatException e2) {
            throw this.exceptionBuilder().evalError("intTooLarge", text).withSourceSection(section).build();
        }
    }

    @Override
    public FloatLiteralNode visitFloatLiteral(PklParser.FloatLiteralContext ctx) {
        int exponentIdx;
        int dotIdx;
        SourceSection section = this.createSourceSection(ctx);
        Object text = ctx.FloatLiteral().getText();
        if (ctx.getParent() instanceof PklParser.UnaryMinusExprContext) {
            text = "-" + (String)text;
        }
        if ((dotIdx = ((String)text).indexOf(46)) != -1 && ((String)text).charAt(dotIdx + 1) == '_') {
            this.invalidSeparatorPosition(this.source.createSection(ctx.getStart().getStartIndex() + dotIdx + 1, 1));
        }
        if ((exponentIdx = ((String)text).indexOf(101)) == -1) {
            exponentIdx = ((String)text).indexOf(69);
        }
        if (exponentIdx != -1 && ((String)text).charAt(exponentIdx + 1) == '_') {
            this.invalidSeparatorPosition(this.source.createSection(ctx.getStart().getStartIndex() + exponentIdx + 1, 1));
        }
        text = ((String)text).replaceAll("_", "");
        try {
            double num = Double.parseDouble((String)text);
            return new FloatLiteralNode(section, num);
        }
        catch (NumberFormatException e2) {
            throw this.exceptionBuilder().evalError("floatTooLarge", text).withSourceSection(section).build();
        }
    }

    @Override
    public Object visitSingleLineStringLiteral(PklParser.SingleLineStringLiteralContext ctx) {
        List<Token> ts;
        this.checkSingleLineStringDelimiters(ctx.t, ctx.t2);
        List<? extends PklParser.SingleLineStringPartContext> singleParts = ctx.singleLineStringPart();
        if (singleParts.isEmpty()) {
            return new ConstantValueNode(this.createSourceSection(ctx), "");
        }
        if (singleParts.size() == 1 && !(ts = singleParts.get((int)0).ts).isEmpty()) {
            return new ConstantValueNode(this.createSourceSection(ctx), this.doVisitSingleLineConstantStringPart(ts));
        }
        return new InterpolatedStringLiteralNode(this.createSourceSection(ctx), (ExpressionNode[])singleParts.stream().map(this::visitSingleLineStringPart).toArray(ExpressionNode[]::new));
    }

    @Override
    public Object visitMultiLineStringLiteral(PklParser.MultiLineStringLiteralContext ctx) {
        List<? extends PklParser.MultiLineStringPartContext> multiPart = ctx.multiLineStringPart();
        if (multiPart.isEmpty()) {
            throw this.exceptionBuilder().evalError("stringContentMustBeginOnNewLine", new Object[0]).withSourceSection(this.createSourceSection(ctx.t2)).build();
        }
        PklParser.MultiLineStringPartContext firstPart = multiPart.get(0);
        if (firstPart.e != null || firstPart.ts.get(0).getType() != 104) {
            throw this.exceptionBuilder().evalError("stringContentMustBeginOnNewLine", new Object[0]).withSourceSection(firstPart.e != null ? this.startOf(firstPart.MLInterpolation()) : this.startOf(firstPart.ts.get(0))).build();
        }
        PklParser.MultiLineStringPartContext lastPart = multiPart.get(multiPart.size() - 1);
        String commonIndent = this.getCommonIndent(lastPart, ctx.t2);
        if (multiPart.size() == 1) {
            return new ConstantValueNode(this.createSourceSection(ctx), this.doVisitMultiLineConstantStringPart(firstPart.ts, commonIndent, true, true));
        }
        ExpressionNode[] multiPartExprs = new ExpressionNode[multiPart.size()];
        int lastIndex2 = multiPart.size() - 1;
        for (int i = 0; i <= lastIndex2; ++i) {
            multiPartExprs[i] = this.doVisitMultiLineStringPart(multiPart.get(i), commonIndent, i == 0, i == lastIndex2);
        }
        return new InterpolatedStringLiteralNode(this.createSourceSection(ctx), multiPartExprs);
    }

    @Override
    public String visitStringConstant(PklParser.StringConstantContext ctx) {
        this.checkSingleLineStringDelimiters(ctx.t, ctx.t2);
        return this.doVisitSingleLineConstantStringPart(ctx.ts);
    }

    @Override
    public ExpressionNode visitSingleLineStringPart(PklParser.SingleLineStringPartContext ctx) {
        if (ctx.e != null) {
            return ToStringNodeGen.create(this.createSourceSection(ctx), this.visitExpr(ctx.e));
        }
        return new ConstantValueNode(this.createSourceSection(ctx), this.doVisitSingleLineConstantStringPart(ctx.ts));
    }

    @Override
    public ExpressionNode visitMultiLineStringPart(PklParser.MultiLineStringPartContext ctx) {
        throw this.exceptionBuilder().unreachableCode().build();
    }

    private ExpressionNode createResolveVariableNode(SourceSection section, Identifier propertyName) {
        SymbolTable.Scope scope = this.symbolTable.getCurrentScope();
        return new ResolveVariableNode(section, propertyName, this.isBaseModule, scope.isCustomThisScope(), scope.getConstLevel(), scope.getConstDepth());
    }

    private ExpressionNode doVisitListLiteral(PklParser.ExprContext ctx, PklParser.ArgumentListContext argListCtx) {
        Pair<ExpressionNode[], Boolean> elementNodes = this.createCollectionArgumentNodes(argListCtx);
        if (((ExpressionNode[])elementNodes.first).length == 0) {
            return new ConstantValueNode(VmList.EMPTY);
        }
        return (Boolean)elementNodes.second != false ? new ConstantValueNode(this.createSourceSection(ctx), VmList.createFromConstantNodes((ExpressionNode[])elementNodes.first)) : new ListLiteralNode(this.createSourceSection(ctx), (ExpressionNode[])elementNodes.first);
    }

    private ExpressionNode doVisitSetLiteral(PklParser.ExprContext ctx, PklParser.ArgumentListContext argListCtx) {
        Pair<ExpressionNode[], Boolean> elementNodes = this.createCollectionArgumentNodes(argListCtx);
        if (((ExpressionNode[])elementNodes.first).length == 0) {
            return new ConstantValueNode(VmSet.EMPTY);
        }
        return (Boolean)elementNodes.second != false ? new ConstantValueNode(this.createSourceSection(ctx), VmSet.createFromConstantNodes((ExpressionNode[])elementNodes.first)) : new SetLiteralNode(this.createSourceSection(ctx), (ExpressionNode[])elementNodes.first);
    }

    private ExpressionNode doVisitMapLiteral(PklParser.ExprContext ctx, PklParser.ArgumentListContext argListCtx) {
        Pair<ExpressionNode[], Boolean> keyAndValueNodes = this.createCollectionArgumentNodes(argListCtx);
        if (((ExpressionNode[])keyAndValueNodes.first).length == 0) {
            return new ConstantValueNode(VmMap.EMPTY);
        }
        if (((ExpressionNode[])keyAndValueNodes.first).length % 2 != 0) {
            throw this.exceptionBuilder().evalError("missingMapValue", new Object[0]).withSourceSection(this.createSourceSection(ctx.stop)).build();
        }
        return (Boolean)keyAndValueNodes.second != false ? new ConstantValueNode(this.createSourceSection(ctx), VmMap.createFromConstantNodes((ExpressionNode[])keyAndValueNodes.first)) : new MapLiteralNode(this.createSourceSection(ctx), (ExpressionNode[])keyAndValueNodes.first);
    }

    private Pair<ExpressionNode[], Boolean> createCollectionArgumentNodes(PklParser.ArgumentListContext ctx) {
        this.checkCommaSeparatedElements(ctx, ctx.es, ctx.errs);
        this.checkClosingDelimiter(ctx.err, ")", ctx.stop);
        List<? extends PklParser.ExprContext> exprCtxs = ctx.expr();
        ExpressionNode[] elementNodes = new ExpressionNode[exprCtxs.size()];
        boolean isConstantNodes = true;
        for (int i = 0; i < elementNodes.length; ++i) {
            ExpressionNode exprNode;
            elementNodes[i] = exprNode = this.visitExpr(exprCtxs.get(i));
            isConstantNodes = isConstantNodes && exprNode instanceof ConstantNode;
        }
        return Pair.of(elementNodes, isConstantNodes);
    }

    @Override
    public ExpressionNode visitExpr(PklParser.ExprContext ctx) {
        return (ExpressionNode)((Object)ctx.accept(this));
    }

    @Override
    public Object visitComparisonExpr(PklParser.ComparisonExprContext ctx) {
        switch (ctx.t.getType()) {
            case 61: {
                return LessThanNodeGen.create(this.createSourceSection(ctx), this.visitExpr(ctx.l), this.visitExpr(ctx.r));
            }
            case 60: {
                return GreaterThanNodeGen.create(this.createSourceSection(ctx), this.visitExpr(ctx.l), this.visitExpr(ctx.r));
            }
            case 68: {
                return LessThanOrEqualNodeGen.create(this.createSourceSection(ctx), this.visitExpr(ctx.l), this.visitExpr(ctx.r));
            }
            case 69: {
                return GreaterThanOrEqualNodeGen.create(this.createSourceSection(ctx), this.visitExpr(ctx.l), this.visitExpr(ctx.r));
            }
        }
        throw this.createUnexpectedTokenError(ctx.t);
    }

    @Override
    public Object visitEqualityExpr(PklParser.EqualityExprContext ctx) {
        switch (ctx.t.getType()) {
            case 66: {
                return EqualNodeGen.create(this.createSourceSection(ctx), this.visitExpr(ctx.l), this.visitExpr(ctx.r));
            }
            case 67: {
                return NotEqualNodeGen.create(this.createSourceSection(ctx), this.visitExpr(ctx.l), this.visitExpr(ctx.r));
            }
        }
        throw this.createUnexpectedTokenError(ctx.t);
    }

    @Override
    public ObjectMember visitImportClause(PklParser.ImportClauseContext ctx) {
        AbstractImportNode importNode = this.doVisitImport(ctx.t.getType(), ctx, ctx.stringConstant());
        ModuleKey moduleKey = this.moduleResolver.resolve(importNode.getImportUri());
        Identifier importName = Identifier.property(ctx.Identifier() != null ? ctx.Identifier().getText() : IoUtils.inferModuleName(moduleKey), true);
        return this.symbolTable.enterProperty(importName, ConstLevel.NONE, scope -> {
            int modifiers = 196;
            if (ctx.IMPORT_GLOB() != null) {
                modifiers |= 0x1000;
            }
            ObjectMember result = new ObjectMember(importNode.getSourceSection(), importNode.getSourceSection(), modifiers, scope.getName(), scope.getQualifiedName());
            result.initMemberNode(new UntypedObjectMemberNode(this.language, scope.buildFrameDescriptor(), result, (ExpressionNode)importNode));
            return result;
        });
    }

    private URI resolveImport(String importUri, PklParser.StringConstantContext importUriCtx) {
        URI resolvedUri;
        URI parsedUri;
        try {
            parsedUri = IoUtils.toUri(importUri);
        }
        catch (URISyntaxException e2) {
            throw this.exceptionBuilder().evalError("invalidModuleUri", importUri).withHint(e2.getReason()).withSourceSection(this.createSourceSection(importUriCtx)).build();
        }
        VmContext context = VmContext.get(null);
        try {
            resolvedUri = IoUtils.resolve(context.getSecurityManager(), this.moduleKey, parsedUri);
        }
        catch (FileNotFoundException e3) {
            throw this.exceptionBuilder().evalError("cannotFindModule", importUri).withSourceSection(this.createSourceSection(importUriCtx)).build();
        }
        catch (URISyntaxException e4) {
            throw this.exceptionBuilder().evalError("invalidModuleUri", importUri).withHint(e4.getReason()).withSourceSection(this.createSourceSection(importUriCtx)).build();
        }
        catch (IOException e5) {
            throw this.exceptionBuilder().evalError("ioErrorLoadingModule", importUri).withCause(e5).withSourceSection(this.createSourceSection(importUriCtx)).build();
        }
        catch (SecurityManagerException | PackageLoadError e6) {
            throw this.exceptionBuilder().withSourceSection(this.createSourceSection(importUriCtx)).withCause(e6).build();
        }
        catch (VmException e7) {
            throw this.exceptionBuilder().evalError(e7.getMessage(), e7.getMessageArguments()).withSourceSection(this.createSourceSection(importUriCtx)).build();
        }
        if (!resolvedUri.isAbsolute()) {
            throw this.exceptionBuilder().evalError("cannotHaveRelativeImport", this.moduleKey.getUri()).withSourceSection(this.createSourceSection(importUriCtx)).build();
        }
        return resolvedUri;
    }

    @Override
    public ExpressionNode visitQualifiedIdentifier(PklParser.QualifiedIdentifierContext ctx) {
        Token firstToken = ctx.ts.get(0);
        ExpressionNode result = this.createResolveVariableNode(this.createSourceSection(firstToken), this.toIdentifier(firstToken));
        for (int i = 1; i < ctx.ts.size(); ++i) {
            Token token = ctx.ts.get(i);
            result = ReadPropertyNodeGen.create(this.createSourceSection(token), this.toIdentifier(token), result);
        }
        return result;
    }

    @Override
    public Object visitNonNullExpr(PklParser.NonNullExprContext ctx) {
        return new NonNullNode(this.createSourceSection(ctx), this.visitExpr(ctx.expr()));
    }

    @Override
    public ExpressionNode visitUnaryMinusExpr(PklParser.UnaryMinusExprContext ctx) {
        ExpressionNode childExpr = this.visitExpr(ctx.expr());
        if (childExpr instanceof IntLiteralNode || childExpr instanceof FloatLiteralNode) {
            return childExpr;
        }
        return UnaryMinusNodeGen.create(this.createSourceSection(ctx), childExpr);
    }

    @Override
    public ExpressionNode visitAdditiveExpr(PklParser.AdditiveExprContext ctx) {
        switch (ctx.t.getType()) {
            case 72: {
                return AdditionNodeGen.create(this.createSourceSection(ctx), this.visitExpr(ctx.l), this.visitExpr(ctx.r));
            }
            case 73: {
                return SubtractionNodeGen.create(this.createSourceSection(ctx), this.visitExpr(ctx.l), this.visitExpr(ctx.r));
            }
        }
        throw this.createUnexpectedTokenError(ctx.t);
    }

    @Override
    public ExpressionNode visitMultiplicativeExpr(PklParser.MultiplicativeExprContext ctx) {
        switch (ctx.t.getType()) {
            case 75: {
                return MultiplicationNodeGen.create(this.createSourceSection(ctx), this.visitExpr(ctx.l), this.visitExpr(ctx.r));
            }
            case 76: {
                return DivisionNodeGen.create(this.createSourceSection(ctx), this.visitExpr(ctx.l), this.visitExpr(ctx.r));
            }
            case 77: {
                return TruncatingDivisionNodeGen.create(this.createSourceSection(ctx), this.visitExpr(ctx.l), this.visitExpr(ctx.r));
            }
            case 78: {
                return RemainderNodeGen.create(this.createSourceSection(ctx), this.visitExpr(ctx.l), this.visitExpr(ctx.r));
            }
        }
        throw this.createUnexpectedTokenError(ctx.t);
    }

    @Override
    public Object visitExponentiationExpr(PklParser.ExponentiationExprContext ctx) {
        return ExponentiationNodeGen.create(this.createSourceSection(ctx), this.visitExpr(ctx.l), this.visitExpr(ctx.r));
    }

    @Override
    public ExpressionNode visitLogicalAndExpr(PklParser.LogicalAndExprContext ctx) {
        return LogicalAndNodeGen.create(this.createSourceSection(ctx), this.visitExpr(ctx.r), this.visitExpr(ctx.l));
    }

    @Override
    public ExpressionNode visitLogicalOrExpr(PklParser.LogicalOrExprContext ctx) {
        return LogicalOrNodeGen.create(this.createSourceSection(ctx), this.visitExpr(ctx.r), this.visitExpr(ctx.l));
    }

    @Override
    public ExpressionNode visitLogicalNotExpr(PklParser.LogicalNotExprContext ctx) {
        return LogicalNotNodeGen.create(this.createSourceSection(ctx), this.visitExpr(ctx.expr()));
    }

    @Override
    public ExpressionNode visitQualifiedAccessExpr(PklParser.QualifiedAccessExprContext ctx) {
        if (ctx.argumentList() != null) {
            return this.doVisitMethodAccessExpr(ctx);
        }
        return this.doVisitPropertyInvocationExpr(ctx);
    }

    private ExpressionNode doVisitMethodAccessExpr(PklParser.QualifiedAccessExprContext ctx) {
        SourceSection sourceSection = this.createSourceSection(ctx);
        Identifier functionName = this.toIdentifier(ctx.Identifier());
        PklParser.ArgumentListContext argCtx = ctx.argumentList();
        ExpressionNode receiver = this.visitExpr(ctx.expr());
        SymbolTable.Scope currentScope = this.symbolTable.getCurrentScope();
        ConstLevel constLevel = currentScope.getConstLevel();
        boolean needsConst = false;
        if (receiver instanceof OuterNode) {
            SymbolTable.Scope outerScope = this.getParentLexicalScope();
            if (outerScope != null) {
                switch (constLevel) {
                    case MODULE: {
                        needsConst = outerScope.isModuleScope();
                        break;
                    }
                    case ALL: {
                        needsConst = outerScope.getConstLevel() != ConstLevel.ALL;
                    }
                }
            }
        } else if (receiver instanceof GetModuleNode) {
            needsConst = constLevel != ConstLevel.NONE;
        } else if (receiver instanceof ThisNode) {
            int constDepth = currentScope.getConstDepth();
            boolean bl = needsConst = constLevel == ConstLevel.ALL && constDepth == -1;
        }
        if (ctx.t.getType() == 55) {
            return new NullPropagatingOperationNode(sourceSection, InvokeMethodVirtualNodeGen.create(sourceSection, functionName, this.visitArgumentList(argCtx), MemberLookupMode.EXPLICIT_RECEIVER, needsConst, PropagateNullReceiverNodeGen.create(AstBuilder.unavailableSourceSection(), receiver), GetClassNodeGen.create(null)));
        }
        assert (ctx.t.getType() == 54);
        return InvokeMethodVirtualNodeGen.create(sourceSection, functionName, this.visitArgumentList(argCtx), MemberLookupMode.EXPLICIT_RECEIVER, needsConst, receiver, GetClassNodeGen.create(null));
    }

    private ExpressionNode doVisitPropertyInvocationExpr(PklParser.QualifiedAccessExprContext ctx) {
        DataSizeUnit dataSizeUnit;
        DurationUnit durationUnit;
        SourceSection sourceSection = this.createSourceSection(ctx);
        Identifier propertyName = this.toIdentifier(ctx.Identifier());
        ExpressionNode receiver = this.visitExpr(ctx.expr());
        if (receiver instanceof IntLiteralNode) {
            durationUnit = VmDuration.toUnit(propertyName);
            if (durationUnit != null) {
                return new ConstantValueNode(sourceSection, new VmDuration(((IntLiteralNode)receiver).executeInt(null), durationUnit));
            }
            dataSizeUnit = VmDataSize.toUnit(propertyName);
            if (dataSizeUnit != null) {
                return new ConstantValueNode(sourceSection, new VmDataSize(((IntLiteralNode)receiver).executeInt(null), dataSizeUnit));
            }
        }
        if (receiver instanceof FloatLiteralNode) {
            durationUnit = VmDuration.toUnit(propertyName);
            if (durationUnit != null) {
                return new ConstantValueNode(sourceSection, new VmDuration(((FloatLiteralNode)receiver).executeFloat(null), durationUnit));
            }
            dataSizeUnit = VmDataSize.toUnit(propertyName);
            if (dataSizeUnit != null) {
                return new ConstantValueNode(sourceSection, new VmDataSize(((FloatLiteralNode)receiver).executeFloat(null), dataSizeUnit));
            }
        }
        ConstLevel constLevel = this.symbolTable.getCurrentScope().getConstLevel();
        boolean needsConst = false;
        if (receiver instanceof OuterNode) {
            SymbolTable.Scope outerScope = this.getParentLexicalScope();
            if (outerScope != null) {
                switch (constLevel) {
                    case MODULE: {
                        needsConst = outerScope.isModuleScope();
                        break;
                    }
                    case ALL: {
                        needsConst = outerScope.getConstLevel() != ConstLevel.ALL;
                    }
                }
            }
        } else if (receiver instanceof GetModuleNode) {
            needsConst = constLevel != ConstLevel.NONE;
        } else if (receiver instanceof ThisNode) {
            int constDepth = this.symbolTable.getCurrentScope().getConstDepth();
            boolean bl = needsConst = constLevel == ConstLevel.ALL && constDepth == -1;
        }
        if (ctx.t.getType() == 55) {
            return new NullPropagatingOperationNode(sourceSection, ReadPropertyNodeGen.create(sourceSection, propertyName, needsConst, PropagateNullReceiverNodeGen.create(AstBuilder.unavailableSourceSection(), receiver)));
        }
        assert (ctx.t.getType() == 54);
        return ReadPropertyNodeGen.create(sourceSection, propertyName, needsConst, receiver);
    }

    @Override
    public ExpressionNode visitSuperAccessExpr(PklParser.SuperAccessExprContext ctx) {
        boolean needsConst;
        SourceSection sourceSection = this.createSourceSection(ctx);
        Identifier memberName = this.toIdentifier(ctx.Identifier());
        PklParser.ArgumentListContext argCtx = ctx.argumentList();
        SymbolTable.Scope currentScope = this.symbolTable.getCurrentScope();
        boolean bl = needsConst = currentScope.getConstLevel() == ConstLevel.ALL && currentScope.getConstDepth() == -1;
        if (argCtx != null) {
            if (!this.symbolTable.getCurrentScope().isClassMemberScope()) {
                throw this.exceptionBuilder().evalError("cannotInvokeSupermethodFromHere", new Object[0]).withSourceSection(sourceSection).build();
            }
            return InvokeSuperMethodNodeGen.create(sourceSection, memberName, this.visitArgumentList(argCtx), needsConst);
        }
        return new ReadSuperPropertyNode(this.createSourceSection(ctx), memberName, needsConst);
    }

    @Override
    public ExpressionNode visitSuperSubscriptExpr(PklParser.SuperSubscriptExprContext ctx) {
        this.checkClosingDelimiter(ctx.err, "]", ctx.e.stop);
        return new ReadSuperEntryNode(this.createSourceSection(ctx), this.visitExpr(ctx.e));
    }

    @Override
    public Object visitPipeExpr(PklParser.PipeExprContext ctx) {
        return PipeNodeGen.create(this.createSourceSection(ctx), this.visitExpr(ctx.l), this.visitExpr(ctx.r));
    }

    @Override
    public ExpressionNode visitNullCoalesceExpr(PklParser.NullCoalesceExprContext ctx) {
        return NullCoalescingNodeGen.create(this.createSourceSection(ctx), this.visitExpr(ctx.r), this.visitExpr(ctx.l));
    }

    @Override
    public ExpressionNode visitUnqualifiedAccessExpr(PklParser.UnqualifiedAccessExprContext ctx) {
        Identifier identifier = this.toIdentifier(ctx.Identifier());
        PklParser.ArgumentListContext argListCtx = ctx.argumentList();
        if (argListCtx == null) {
            return this.createResolveVariableNode(this.createSourceSection(ctx), identifier);
        }
        if (identifier == Identifier.LIST) {
            return this.doVisitListLiteral(ctx, argListCtx);
        }
        if (identifier == Identifier.SET) {
            return this.doVisitSetLiteral(ctx, argListCtx);
        }
        if (identifier == Identifier.MAP) {
            return this.doVisitMapLiteral(ctx, argListCtx);
        }
        SymbolTable.Scope scope = this.symbolTable.getCurrentScope();
        return new ResolveMethodNode(this.createSourceSection(ctx), identifier, this.visitArgumentList(argListCtx), this.isBaseModule, scope.isCustomThisScope(), scope.getConstLevel(), scope.getConstDepth());
    }

    @Override
    public ExpressionNode[] visitArgumentList(PklParser.ArgumentListContext ctx) {
        this.checkCommaSeparatedElements(ctx, ctx.es, ctx.errs);
        this.checkClosingDelimiter(ctx.err, ")", ctx.stop);
        return (ExpressionNode[])ctx.es.stream().map(this::visitExpr).toArray(ExpressionNode[]::new);
    }

    private Identifier toIdentifier(TerminalNode node) {
        return Identifier.get(node.getText());
    }

    private Identifier toIdentifier(Token token) {
        return Identifier.get(token.getText());
    }

    private FrameDescriptor.Builder createFrameDescriptorBuilder(PklParser.ParameterListContext ctx) {
        this.checkCommaSeparatedElements(ctx, ctx.ts, ctx.errs);
        this.checkClosingDelimiter(ctx.err, ")", ctx.stop);
        FrameDescriptor.Builder builder = FrameDescriptor.newBuilder((int)ctx.ts.size());
        for (PklParser.ParameterContext param : ctx.ts) {
            Identifier ident = AstBuilder.isIgnored(param) ? null : this.toIdentifier(param.typedIdentifier().Identifier());
            builder.addSlot(FrameSlotKind.Illegal, (Object)ident, null);
        }
        return builder;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable FrameDescriptor.Builder createFrameDescriptorBuilder(PklParser.ObjectBodyContext ctx) {
        if (ctx.ps.isEmpty()) {
            return null;
        }
        this.checkCommaSeparatedElements(ctx, ctx.ps, ctx.errs);
        FrameDescriptor.Builder builder = FrameDescriptor.newBuilder((int)ctx.ps.size());
        for (PklParser.ParameterContext param : ctx.ps) {
            Identifier ident = AstBuilder.isIgnored(param) ? null : this.toIdentifier(param.typedIdentifier().Identifier());
            builder.addSlot(FrameSlotKind.Illegal, (Object)ident, null);
        }
        return builder;
    }

    private UnresolvedTypeNode[] doVisitParameterTypes(PklParser.ParameterListContext ctx) {
        return (UnresolvedTypeNode[])ctx.ts.stream().map(it -> AstBuilder.isIgnored(it) ? null : this.visitTypeAnnotation(it.typedIdentifier().typeAnnotation())).toArray(UnresolvedTypeNode[]::new);
    }

    private UnresolvedTypeNode[] doVisitParameterTypes(PklParser.ObjectBodyContext ctx) {
        return (UnresolvedTypeNode[])ctx.ps.stream().map(it -> AstBuilder.isIgnored(it) ? null : this.visitTypeAnnotation(it.typedIdentifier().typeAnnotation())).toArray(UnresolvedTypeNode[]::new);
    }

    @Override
    public Object visitTypedIdentifier(PklParser.TypedIdentifierContext ctx) {
        throw this.exceptionBuilder().unreachableCode().build();
    }

    @Override
    public Object visitThrowExpr(PklParser.ThrowExprContext ctx) {
        PklParser.ExprContext exprCtx = ctx.expr();
        this.checkClosingDelimiter(ctx.err, ")", exprCtx.stop);
        return ThrowNodeGen.create(this.createSourceSection(ctx), this.visitExpr(exprCtx));
    }

    @Override
    public Object visitTraceExpr(PklParser.TraceExprContext ctx) {
        PklParser.ExprContext exprCtx = ctx.expr();
        this.checkClosingDelimiter(ctx.err, ")", exprCtx.stop);
        return new TraceNode(this.createSourceSection(ctx), this.visitExpr(exprCtx));
    }

    @Override
    public Object visitImportExpr(PklParser.ImportExprContext ctx) {
        PklParser.StringConstantContext importUriCtx = ctx.stringConstant();
        this.checkClosingDelimiter(ctx.err, ")", importUriCtx.stop);
        return this.doVisitImport(ctx.t.getType(), ctx, importUriCtx);
    }

    @Override
    public Object visitIfExpr(PklParser.IfExprContext ctx) {
        this.checkClosingDelimiter(ctx.err, ")", ctx.c.stop);
        return new IfElseNode(this.createSourceSection(ctx), this.visitExpr(ctx.c), this.visitExpr(ctx.l), this.visitExpr(ctx.r));
    }

    @Override
    public Object visitReadExpr(PklParser.ReadExprContext ctx) {
        PklParser.ExprContext exprCtx = ctx.expr();
        this.checkClosingDelimiter(ctx.err, ")", exprCtx.stop);
        int tokenType = ctx.t.getType();
        if (tokenType == 28) {
            return ReadNodeGen.create(this.createSourceSection(ctx), this.moduleKey, this.visitExpr(exprCtx));
        }
        if (tokenType == 30) {
            return ReadOrNullNodeGen.create(this.createSourceSection(ctx), this.moduleKey, this.visitExpr(exprCtx));
        }
        assert (tokenType == 29);
        return ReadGlobNodeGen.create(this.language, this.createSourceSection(ctx), this.moduleKey, this.visitExpr(exprCtx));
    }

    @Override
    public Object visitLetExpr(PklParser.LetExprContext ctx) {
        UnresolvedTypeNode[] unresolvedTypeNodeArray;
        this.checkClosingDelimiter(ctx.err, ")", ctx.l.stop);
        SourceSection sourceSection = this.createSourceSection(ctx);
        PklParser.ParameterContext idCtx = ctx.parameter();
        FrameDescriptor.Builder frameBuilder = FrameDescriptor.newBuilder();
        boolean isIgnored = AstBuilder.isIgnored(idCtx);
        if (isIgnored) {
            unresolvedTypeNodeArray = new UnresolvedTypeNode[]{};
        } else {
            UnresolvedTypeNode[] unresolvedTypeNodeArray2 = new UnresolvedTypeNode[1];
            unresolvedTypeNodeArray = unresolvedTypeNodeArray2;
            unresolvedTypeNodeArray2[0] = this.visitTypeAnnotation(idCtx.typedIdentifier().typeAnnotation());
        }
        UnresolvedTypeNode[] typeNodes = unresolvedTypeNodeArray;
        if (!isIgnored) {
            frameBuilder.addSlot(FrameSlotKind.Illegal, (Object)this.toIdentifier(idCtx.typedIdentifier().Identifier()), null);
        }
        boolean isCustomThisScope = this.symbolTable.getCurrentScope().isCustomThisScope();
        UnresolvedFunctionNode functionNode = this.symbolTable.enterLambda(frameBuilder, scope -> {
            ExpressionNode expr = this.visitExpr(ctx.r);
            return new UnresolvedFunctionNode(this.language, scope.buildFrameDescriptor(), new Lambda(this.createSourceSection(ctx.r), scope.getQualifiedName()), 1, typeNodes, null, expr);
        });
        return new LetExprNode(sourceSection, functionNode, this.visitExpr(ctx.l), isCustomThisScope);
    }

    @Override
    public ExpressionNode visitThisExpr(PklParser.ThisExprContext ctx) {
        if (!(ctx.parent instanceof PklParser.QualifiedAccessExprContext)) {
            boolean needsConst;
            SymbolTable.Scope currentScope = this.symbolTable.getCurrentScope();
            boolean bl = needsConst = currentScope.getConstLevel() == ConstLevel.ALL && currentScope.getConstDepth() == -1 && !currentScope.isCustomThisScope();
            if (needsConst) {
                throw this.exceptionBuilder().withSourceSection(this.createSourceSection(ctx)).evalError("thisIsNotConst", new Object[0]).build();
            }
        }
        return VmUtils.createThisNode(this.createSourceSection(ctx), this.symbolTable.getCurrentScope().isCustomThisScope());
    }

    @Override
    public OuterNode visitOuterExpr(PklParser.OuterExprContext ctx) {
        if (!(ctx.parent instanceof PklParser.QualifiedAccessExprContext)) {
            ConstLevel constLevel = this.symbolTable.getCurrentScope().getConstLevel();
            SymbolTable.Scope outerScope = this.getParentLexicalScope();
            if (outerScope != null && constLevel.bigger(outerScope.getConstLevel())) {
                throw this.exceptionBuilder().evalError("outerIsNotConst", new Object[0]).withSourceSection(this.createSourceSection(ctx)).build();
            }
        }
        return new OuterNode(this.createSourceSection(ctx));
    }

    @Override
    public Object visitModuleExpr(PklParser.ModuleExprContext ctx) {
        if (this.symbolTable.getCurrentScope().getConstLevel().isConst() && !(ctx.parent instanceof PklParser.QualifiedAccessExprContext)) {
            SymbolTable.Scope scope;
            for (scope = this.symbolTable.getCurrentScope(); scope != null && !(scope instanceof SymbolTable.AnnotationScope) && !(scope instanceof SymbolTable.ClassScope); scope = scope.getParent()) {
            }
            if (scope == null) {
                throw this.exceptionBuilder().evalError("moduleIsNotConst", this.symbolTable.getCurrentScope().getName().toString()).withSourceSection(this.createSourceSection(ctx)).build();
            }
            String messageKey = scope instanceof SymbolTable.AnnotationScope ? "moduleIsNotConstAnnotation" : "moduleIsNotConstClass";
            throw this.exceptionBuilder().evalError(messageKey, new Object[0]).withSourceSection(this.createSourceSection(ctx)).build();
        }
        return new GetModuleNode(this.createSourceSection(ctx));
    }

    @Override
    public ExpressionNode visitParenthesizedExpr(PklParser.ParenthesizedExprContext ctx) {
        this.checkClosingDelimiter(ctx.err, ")", ctx.stop);
        return this.visitExpr(ctx.expr());
    }

    @Override
    public Object visitSubscriptExpr(PklParser.SubscriptExprContext ctx) {
        this.checkClosingDelimiter(ctx.err, "]", ctx.stop);
        return SubscriptNodeGen.create(this.createSourceSection(ctx), this.visitExpr(ctx.l), this.visitExpr(ctx.r));
    }

    @Override
    public Object visitTypeTestExpr(PklParser.TypeTestExprContext ctx) {
        if (ctx.t.getType() == 18) {
            return new TypeTestNode(this.createSourceSection(ctx), this.visitExpr(ctx.l), this.visitType(ctx.r));
        }
        assert (ctx.t.getType() == 3);
        return new TypeCastNode(this.createSourceSection(ctx), this.visitExpr(ctx.l), this.visitType(ctx.r));
    }

    @Override
    public Object visitUnknownType(PklParser.UnknownTypeContext ctx) {
        return new UnresolvedTypeNode.Unknown(this.createSourceSection(ctx));
    }

    @Override
    public Object visitNothingType(PklParser.NothingTypeContext ctx) {
        return new UnresolvedTypeNode.Nothing(this.createSourceSection(ctx));
    }

    @Override
    public Object visitModuleType(PklParser.ModuleTypeContext ctx) {
        return new UnresolvedTypeNode.Module(this.createSourceSection(ctx));
    }

    @Override
    public Object visitStringLiteralType(PklParser.StringLiteralTypeContext ctx) {
        return new UnresolvedTypeNode.StringLiteral(this.createSourceSection(ctx), this.visitStringConstant(ctx.stringConstant()));
    }

    @Override
    public UnresolvedTypeNode visitType(PklParser.TypeContext ctx) {
        return (UnresolvedTypeNode)((Object)ctx.accept(this));
    }

    @Override
    public UnresolvedTypeNode visitDeclaredType(PklParser.DeclaredTypeContext ctx) {
        PklParser.QualifiedIdentifierContext idCtx = ctx.qualifiedIdentifier();
        PklParser.TypeArgumentListContext argCtx = ctx.typeArgumentList();
        if (argCtx == null) {
            String text;
            TypeParameter typeParameter;
            if (idCtx.ts.size() == 1 && (typeParameter = this.symbolTable.findTypeParameter(text = idCtx.ts.get(0).getText())) != null) {
                return new UnresolvedTypeNode.TypeVariable(this.createSourceSection(ctx), typeParameter);
            }
            return new UnresolvedTypeNode.Declared(this.createSourceSection(ctx), this.doVisitTypeName(idCtx));
        }
        this.checkCommaSeparatedElements(argCtx, argCtx.ts, argCtx.errs);
        this.checkClosingDelimiter(argCtx.err, ">", argCtx.stop);
        return new UnresolvedTypeNode.Parameterized(this.createSourceSection(ctx), this.doVisitTypeName(idCtx), (UnresolvedTypeNode[])argCtx.ts.stream().map(this::visitType).toArray(UnresolvedTypeNode[]::new));
    }

    @Override
    public UnresolvedTypeNode visitParenthesizedType(PklParser.ParenthesizedTypeContext ctx) {
        this.checkClosingDelimiter(ctx.err, ")", ctx.stop);
        return this.visitType(ctx.type());
    }

    @Override
    public Object visitDefaultUnionType(PklParser.DefaultUnionTypeContext ctx) {
        throw this.exceptionBuilder().evalError("notAUnion", new Object[0]).withSourceSection(this.createSourceSection(ctx)).build();
    }

    @Override
    public UnresolvedTypeNode visitUnionType(PklParser.UnionTypeContext ctx) {
        ArrayList<PklParser.TypeContext> elementTypeCtxs = new ArrayList<PklParser.TypeContext>();
        Pair<Boolean, Integer> result = this.flattenUnionType(ctx, elementTypeCtxs);
        boolean isUnionOfStringLiterals = (Boolean)result.first;
        int defaultIndex = (Integer)result.second;
        if (isUnionOfStringLiterals) {
            return new UnresolvedTypeNode.UnionOfStringLiterals(this.createSourceSection(ctx), defaultIndex, elementTypeCtxs.stream().map(it -> this.visitStringConstant(((PklParser.StringLiteralTypeContext)((Object)it)).stringConstant())).collect(Collectors.toCollection(LinkedHashSet::new)));
        }
        return new UnresolvedTypeNode.Union(this.createSourceSection(ctx), defaultIndex, (UnresolvedTypeNode[])elementTypeCtxs.stream().map(this::visitType).toArray(UnresolvedTypeNode[]::new));
    }

    private Pair<Boolean, Integer> flattenUnionType(PklParser.UnionTypeContext ctx, List<PklParser.TypeContext> collector) {
        boolean isUnionOfStringLiterals = true;
        int index = 0;
        int defaultIndex = -1;
        ArrayDeque<PklParser.TypeContext> list = new ArrayDeque<PklParser.TypeContext>();
        list.addLast(ctx.l);
        list.addLast(ctx.r);
        while (!list.isEmpty()) {
            PklParser.TypeContext current2 = (PklParser.TypeContext)((Object)list.removeFirst());
            if (current2 instanceof PklParser.UnionTypeContext) {
                PklParser.UnionTypeContext union = (PklParser.UnionTypeContext)current2;
                list.addFirst(union.r);
                list.addFirst(union.l);
                continue;
            }
            if (current2 instanceof PklParser.DefaultUnionTypeContext) {
                if (defaultIndex != -1) {
                    throw this.exceptionBuilder().evalError("multipleUnionDefaults", new Object[0]).withSourceSection(this.createSourceSection(ctx)).build();
                }
                defaultIndex = index;
                PklParser.DefaultUnionTypeContext def = (PklParser.DefaultUnionTypeContext)current2;
                isUnionOfStringLiterals = isUnionOfStringLiterals && def.type() instanceof PklParser.StringLiteralTypeContext;
                collector.add(def.type());
            } else {
                isUnionOfStringLiterals = isUnionOfStringLiterals && current2 instanceof PklParser.StringLiteralTypeContext;
                collector.add(current2);
            }
            ++index;
        }
        return Pair.of(isUnionOfStringLiterals, defaultIndex);
    }

    @Override
    public UnresolvedTypeNode visitNullableType(PklParser.NullableTypeContext ctx) {
        return new UnresolvedTypeNode.Nullable(this.createSourceSection(ctx), (UnresolvedTypeNode)((Object)ctx.type().accept(this)));
    }

    @Override
    public UnresolvedTypeNode visitConstrainedType(PklParser.ConstrainedTypeContext ctx) {
        this.checkCommaSeparatedElements(ctx, ctx.es, ctx.errs);
        this.checkClosingDelimiter(ctx.err, ")", ctx.stop);
        UnresolvedTypeNode childNode = (UnresolvedTypeNode)((Object)ctx.type().accept(this));
        return this.symbolTable.enterCustomThisScope(scope -> new UnresolvedTypeNode.Constrained(this.createSourceSection(ctx), childNode, (TypeConstraintNode[])ctx.es.stream().map(this::visitExpr).map(it -> TypeConstraintNodeGen.create(it.getSourceSection(), it)).toArray(TypeConstraintNode[]::new)));
    }

    @Override
    public UnresolvedTypeNode visitFunctionType(PklParser.FunctionTypeContext ctx) {
        this.checkCommaSeparatedElements(ctx, ctx.ps, ctx.errs);
        this.checkClosingDelimiter(ctx.err, ")", ctx.ps.isEmpty() ? ctx.t : ctx.ps.get((int)(ctx.ps.size() - 1)).stop);
        return new UnresolvedTypeNode.Function(this.createSourceSection(ctx), (UnresolvedTypeNode[])ctx.ps.stream().map(this::visitType).toArray(UnresolvedTypeNode[]::new), (UnresolvedTypeNode)((Object)ctx.r.accept(this)));
    }

    private ExpressionNode resolveBaseModuleClass(Identifier className, Supplier<VmClass> clazz) {
        return this.isBaseModule ? new GetBaseModuleClassNode(className) : new ConstantValueNode(clazz.get());
    }

    private UnresolvedPropertyNode[] doVisitClassProperties(List<PklParser.ClassPropertyContext> propertyContexts, Set<String> propertyNames) {
        UnresolvedPropertyNode[] propertyNodes = new UnresolvedPropertyNode[propertyContexts.size()];
        for (int i = 0; i < propertyNodes.length; ++i) {
            PklParser.ClassPropertyContext propertyCtx = propertyContexts.get(i);
            UnresolvedPropertyNode propertyNode = this.visitClassProperty(propertyCtx);
            this.checkDuplicateMember(propertyNode.getName(), propertyNode.getHeaderSection(), propertyNames);
            propertyNodes[i] = propertyNode;
        }
        return propertyNodes;
    }

    private UnresolvedMethodNode[] doVisitMethodDefs(List<PklParser.ClassMethodContext> methodDefs) {
        UnresolvedMethodNode[] methodNodes = new UnresolvedMethodNode[methodDefs.size()];
        HashSet<String> methodNames = CollectionUtils.newHashSet(methodDefs.size());
        for (int i = 0; i < methodNodes.length; ++i) {
            UnresolvedMethodNode methodNode = this.visitClassMethod(methodDefs.get(i));
            this.checkDuplicateMember(methodNode.getName(), methodNode.getHeaderSection(), methodNames);
            methodNodes[i] = methodNode;
        }
        return methodNodes;
    }

    private EconomicMap<Object, ObjectMember> doVisitModuleProperties(List<PklParser.ImportClauseContext> importCtxs, List<PklParser.ClazzContext> classCtxs, List<PklParser.TypeAliasContext> typeAliasCtxs, List<PklParser.ClassPropertyContext> propertyCtxs, Set<String> propertyNames, ModuleInfo moduleInfo) {
        ObjectMember member;
        int totalSize = importCtxs.size() + classCtxs.size() + typeAliasCtxs.size();
        EconomicMap result = EconomicMaps.create(totalSize);
        for (PklParser.ImportClauseContext importClauseContext : importCtxs) {
            member = this.visitImportClause(importClauseContext);
            this.checkDuplicateMember(member.getName(), member.getHeaderSection(), propertyNames);
            EconomicMaps.put(result, member.getName(), member);
        }
        for (PklParser.ClazzContext clazzContext : classCtxs) {
            member = this.visitClazz(clazzContext);
            if (moduleInfo.isAmend() && !member.isLocal()) {
                throw this.exceptionBuilder().evalError("classMustBeLocal", new Object[0]).withSourceSection(member.getHeaderSection()).build();
            }
            this.checkDuplicateMember(member.getName(), member.getHeaderSection(), propertyNames);
            EconomicMaps.put(result, member.getName(), member);
        }
        for (PklParser.TypeAliasContext typeAliasContext : typeAliasCtxs) {
            member = this.visitTypeAlias(typeAliasContext);
            if (moduleInfo.isAmend() && !member.isLocal()) {
                throw this.exceptionBuilder().evalError("typeAliasMustBeLocal", new Object[0]).withSourceSection(member.getHeaderSection()).build();
            }
            this.checkDuplicateMember(member.getName(), member.getHeaderSection(), propertyNames);
            EconomicMaps.put(result, member.getName(), member);
        }
        for (PklParser.ClassPropertyContext classPropertyContext : propertyCtxs) {
            member = this.doVisitObjectProperty(classPropertyContext, classPropertyContext.modifier(), classPropertyContext.Identifier(), classPropertyContext.typeAnnotation(), classPropertyContext.expr(), classPropertyContext.objectBody());
            if (moduleInfo.isAmend() && !member.isLocal() && classPropertyContext.typeAnnotation() != null) {
                throw this.exceptionBuilder().evalError("nonLocalObjectPropertyCannotHaveTypeAnnotation", new Object[0]).withSourceSection(this.createSourceSection(classPropertyContext.typeAnnotation().type())).build();
            }
            this.checkDuplicateMember(member.getName(), member.getHeaderSection(), propertyNames);
            EconomicMaps.put(result, member.getName(), member);
        }
        return result;
    }

    private void checkDuplicateMember(Identifier memberName, SourceSection headerSection, Set<String> visited) {
        if (!visited.add(memberName.toString())) {
            throw this.exceptionBuilder().evalError("duplicateDefinition", memberName).withSourceSection(headerSection).build();
        }
    }

    private void addProperty(EconomicMap<Object, ObjectMember> objectMembers, ObjectMember property) {
        if (EconomicMaps.put(objectMembers, property.getName(), property) != null) {
            throw this.exceptionBuilder().evalError("duplicateDefinition", property.getName()).withSourceSection(property.getHeaderSection()).build();
        }
    }

    private void invalidSeparatorPosition(SourceSection source) {
        throw this.exceptionBuilder().evalError("invalidSeparatorPosition", new Object[0]).withSourceSection(source).build();
    }

    private AbstractImportNode doVisitImport(int lexerToken, ParserRuleContext ctx, PklParser.StringConstantContext importUriCtx) {
        boolean isGlobImport = lexerToken == 16;
        SourceSection section = this.createSourceSection(ctx);
        String importUri = this.visitStringConstant(importUriCtx);
        if (isGlobImport && importUri.startsWith("...")) {
            throw this.exceptionBuilder().evalError("cannotGlobTripleDots", new Object[0]).withSourceSection(section).build();
        }
        URI resolvedUri = this.resolveImport(importUri, importUriCtx);
        if (isGlobImport) {
            return new ImportGlobNode(this.language, section, this.moduleInfo.getResolvedModuleKey(), resolvedUri, importUri);
        }
        return new ImportNode(this.language, section, this.moduleInfo.getResolvedModuleKey(), resolvedUri);
    }

    private SourceSection startOf(TerminalNode node) {
        return this.startOf(node.getSymbol());
    }

    private SourceSection startOf(Token token) {
        return this.source.createSection(token.getStartIndex(), 1);
    }

    private SourceSection shrinkLeft(SourceSection section, int length2) {
        return this.source.createSection(section.getCharIndex() + length2, section.getCharLength() - length2);
    }

    private VmException createUnexpectedTokenError(Token token) {
        return this.exceptionBuilder().bug("Unexpected token `%s`.", token).build();
    }

    @Override
    protected VmExceptionBuilder exceptionBuilder() {
        return new VmExceptionBuilder().withMemberName(this.symbolTable.getCurrentScope().getQualifiedName());
    }

    private static SourceSection unavailableSourceSection() {
        return VmUtils.unavailableSourceSection();
    }

    private String getCommonIndent(PklParser.MultiLineStringPartContext lastPart, Token endQuoteToken) {
        Token lastButOneToken;
        if (lastPart.e != null) {
            throw this.exceptionBuilder().evalError("closingStringDelimiterMustBeginOnNewLine", new Object[0]).withSourceSection(this.startOf(endQuoteToken)).build();
        }
        List<Token> tokens = lastPart.ts;
        assert (tokens.size() >= 1);
        Token lastToken = tokens.get(tokens.size() - 1);
        if (lastToken.getType() == 104) {
            return "";
        }
        if (tokens.size() > 1 && (lastButOneToken = tokens.get(tokens.size() - 2)).getType() == 104 && AstBuilder.isIndentChars(lastToken)) {
            return lastToken.getText();
        }
        throw this.exceptionBuilder().evalError("closingStringDelimiterMustBeginOnNewLine", new Object[0]).withSourceSection(this.startOf(endQuoteToken)).build();
    }

    private static boolean isIndentChars(Token token) {
        String text = token.getText();
        block3: for (int i = 0; i < text.length(); ++i) {
            switch (text.charAt(i)) {
                case '\t': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private static String getLeadingIndent(Token token) {
        String text = token.getText();
        block3: for (int i = 0; i < text.length(); ++i) {
            switch (text.charAt(i)) {
                case '\t': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return text.substring(0, i);
                }
            }
        }
        return text;
    }

    private ExpressionNode doVisitMultiLineStringPart(PklParser.MultiLineStringPartContext ctx, String commonIndent, boolean isStringStart, boolean isStringEnd) {
        if (ctx.e != null) {
            return ToStringNodeGen.create(this.createSourceSection(ctx), this.visitExpr(ctx.e));
        }
        return new ConstantValueNode(this.createSourceSection(ctx), this.doVisitMultiLineConstantStringPart(ctx.ts, commonIndent, isStringStart, isStringEnd));
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private String doVisitMultiLineConstantStringPart(List<Token> tokens, String commonIndent, boolean isStringStart, boolean isStringEnd) {
        int startIndex = 0;
        if (isStringStart) {
            startIndex = 1;
        }
        int endIndex = tokens.size() - 1;
        if (isStringEnd) {
            endIndex = tokens.get(endIndex).getType() == 104 ? --endIndex : (endIndex -= 2);
        }
        StringBuilder builder = new StringBuilder();
        boolean isLineStart = isStringStart;
        int i = startIndex;
        while (i <= endIndex) {
            Token token = tokens.get(i);
            switch (token.getType()) {
                case 104: {
                    builder.append('\n');
                    isLineStart = true;
                    break;
                }
                case 105: {
                    String text = token.getText();
                    if (isLineStart) {
                        if (!text.startsWith(commonIndent)) {
                            String actualIndent = AstBuilder.getLeadingIndent(token);
                            if (actualIndent.length() <= commonIndent.length()) throw this.exceptionBuilder().evalError("stringIndentationMustMatchLastLine", new Object[0]).withSourceSection(this.shrinkLeft(this.createSourceSection(token), actualIndent.length())).build();
                            actualIndent = actualIndent.substring(0, commonIndent.length());
                            throw this.exceptionBuilder().evalError("stringIndentationMustMatchLastLine", new Object[0]).withSourceSection(this.shrinkLeft(this.createSourceSection(token), actualIndent.length())).build();
                        }
                        builder.append(text, commonIndent.length(), text.length());
                    } else {
                        builder.append(text);
                    }
                    isLineStart = false;
                    break;
                }
                case 103: {
                    if (isLineStart && !commonIndent.isEmpty()) {
                        throw this.exceptionBuilder().evalError("stringIndentationMustMatchLastLine", new Object[0]).withSourceSection(this.createSourceSection(token)).build();
                    }
                    builder.append(this.parseCharacterEscapeSequence(token));
                    isLineStart = false;
                    break;
                }
                case 102: {
                    if (isLineStart && !commonIndent.isEmpty()) {
                        throw this.exceptionBuilder().evalError("stringIndentationMustMatchLastLine", new Object[0]).withSourceSection(this.createSourceSection(token)).build();
                    }
                    builder.appendCodePoint(this.parseUnicodeEscapeSequence(token));
                    isLineStart = false;
                    break;
                }
                default: {
                    throw this.exceptionBuilder().unreachableCode().build();
                }
            }
            ++i;
        }
        return builder.toString();
    }

    private ResolveDeclaredTypeNode doVisitTypeName(PklParser.QualifiedIdentifierContext ctx) {
        List<Token> tokens = ctx.ts;
        switch (tokens.size()) {
            case 1: {
                Token token = tokens.get(0);
                return new ResolveSimpleDeclaredTypeNode(this.createSourceSection(token), Identifier.get(token.getText()), this.isBaseModule);
            }
            case 2: {
                Token token1 = tokens.get(0);
                Token token2 = tokens.get(1);
                return new ResolveQualifiedDeclaredTypeNode(this.createSourceSection(ctx), this.createSourceSection(token1), this.createSourceSection(token2), Identifier.localProperty(token1.getText()), Identifier.get(token2.getText()));
            }
        }
        throw this.exceptionBuilder().evalError("invalidTypeName", ctx.getText()).withSourceSection(this.createSourceSection(ctx)).build();
    }

    private void checkCommaSeparatedElements(ParserRuleContext ctx, List<? extends ParserRuleContext> elements, List<Token> separators) {
        if (elements.isEmpty() || separators.size() == elements.size() - 1) {
            return;
        }
        ParseTree prevChild = null;
        for (ParseTree child : ctx.children) {
            int index = elements.indexOf(child);
            if (index > 0) {
                assert (prevChild != null);
                if (!(prevChild instanceof TerminalNode) || !separators.contains(((TerminalNode)prevChild).getSymbol())) {
                    Token prevToken = prevChild instanceof TerminalNode ? ((TerminalNode)prevChild).getSymbol() : ((ParserRuleContext)prevChild).getStop();
                    throw this.exceptionBuilder().evalError("missingCommaSeparator", new Object[0]).withSourceSection(this.source.createSection(prevToken.getStopIndex() + 1, 1)).build();
                }
            }
            prevChild = child;
        }
        throw this.exceptionBuilder().unreachableCode().build();
    }

    private void checkClosingDelimiter(@Nullable Token delimiter, String delimiterSymbol, Token tokenBeforeDelimiter) {
        if (delimiter == null) {
            throw this.missingDelimiter(delimiterSymbol, tokenBeforeDelimiter.getStopIndex() + 1);
        }
    }

    private void checkSingleLineStringDelimiters(Token openingDelimiter, Token closingDelimiter) {
        String closingText = closingDelimiter.getText();
        char lastChar = closingText.charAt(closingText.length() - 1);
        if (lastChar == '\"' || lastChar == '#') {
            return;
        }
        assert (lastChar == '\n' || lastChar == '\r');
        String openingText = openingDelimiter.getText();
        throw this.missingDelimiter("\"" + openingText.substring(0, openingText.length() - 1), closingDelimiter.getStopIndex());
    }

    private VmException missingDelimiter(String delimiter, int charIndex) {
        return this.exceptionBuilder().evalError("missingDelimiter", delimiter).withSourceSection(this.source.createSection(charIndex, 0)).build();
    }

    private VmException wrongDelimiter(String expected, String actual, int charIndex) {
        return this.exceptionBuilder().evalError("wrongDelimiter", expected, actual).withSourceSection(this.source.createSection(charIndex, 0)).build();
    }

    private VmException danglingDelimiter(String delimiter, int charIndex) {
        return this.exceptionBuilder().evalError("danglingDelimiter", delimiter).withSourceSection(this.source.createSection(charIndex, 0)).build();
    }

    private @Nullable SymbolTable.Scope getParentLexicalScope() {
        SymbolTable.Scope parent = this.symbolTable.getCurrentScope().getLexicalScope().getParent();
        if (parent != null) {
            return parent.getLexicalScope();
        }
        return null;
    }

    private ConstLevel getConstLevel(int modifiers) {
        if (VmModifier.isConst(modifiers)) {
            return ConstLevel.ALL;
        }
        return this.symbolTable.getCurrentScope().getConstLevel();
    }

    private /* synthetic */ UnresolvedMethodNode lambda$visitClassMethod$13(PklParser.ExprContext bodyContext, int modifiers, SourceSection headerSection, int paramCount, Identifier methodName, PklParser.ClassMethodContext ctx, List typeParameters, PklParser.ParameterListContext paramListCtx, PklParser.MethodHeaderContext headerCtx, SymbolTable.MethodScope scope) {
        ExpressionNode bodyNode;
        if (bodyContext != null) {
            if (VmModifier.isExternal(modifiers)) {
                throw this.exceptionBuilder().evalError("externalMemberCannotHaveBody", new Object[0]).withSourceSection(headerSection).build();
            }
            if (VmModifier.isAbstract(modifiers)) {
                throw this.exceptionBuilder().evalError("abstractMemberCannotHaveBody", new Object[0]).withSourceSection(headerSection).build();
            }
            bodyNode = this.visitExpr(bodyContext);
        } else if (VmModifier.isExternal(modifiers)) {
            bodyNode = this.externalMemberRegistry.getFunctionBody(scope.getQualifiedName(), headerSection, paramCount);
            if (bodyNode instanceof LanguageAwareNode) {
                ((LanguageAwareNode)((Object)bodyNode)).initLanguage(this.language);
            }
        } else if (VmModifier.isAbstract(modifiers)) {
            bodyNode = new CannotInvokeAbstractFunctionNode(headerSection, scope.getQualifiedName());
        } else {
            throw this.exceptionBuilder().evalError("missingMethodBody", methodName).withSourceSection(headerSection).build();
        }
        return new UnresolvedMethodNode(this.language, this.createSourceSection(ctx), headerSection, scope.buildFrameDescriptor(), this.createSourceSection(ctx.t), this.doVisitAnnotations(ctx.annotation()), modifiers, methodName, scope.getQualifiedName(), paramCount, typeParameters, this.doVisitParameterTypes(paramListCtx), this.visitTypeAnnotation(headerCtx.typeAnnotation()), this.isMethodReturnTypeChecked, bodyNode);
    }

    private /* synthetic */ ObjectMember lambda$visitTypeAlias$1(SourceSection sourceSection, SourceSection headerSection, PklParser.TypeAliasContext ctx, int modifiers, List typeParameters, boolean isLocal, SymbolTable.TypeAliasScope scope) {
        Identifier scopeName = scope.getName();
        TypeAliasNode typeAliasNode = new TypeAliasNode(sourceSection, headerSection, this.createSourceSection(ctx.t), this.doVisitAnnotations(ctx.annotation()), modifiers, scopeName.toString(), scope.getQualifiedName(), typeParameters, (UnresolvedTypeNode)((Object)ctx.type().accept(this)));
        ObjectMember result = new ObjectMember(sourceSection, headerSection, isLocal ? 580 : 576, scopeName, scope.getQualifiedName());
        result.initMemberNode(new UntypedObjectMemberNode(this.language, scope.buildFrameDescriptor(), result, (ExpressionNode)typeAliasNode));
        return result;
    }

    private /* synthetic */ ObjectMember lambda$visitClazz$0(PklParser.ClassHeaderContext headerCtx, Identifier className, List propertyCtxs, SourceSection sourceSection, SourceSection headerSection, PklParser.ClazzContext ctx, int modifiers, List typeParameters, List methodCtxs, SymbolTable.ClassScope scope) {
        UnresolvedTypeNode supertypeNode;
        PklParser.TypeContext supertypeCtx = headerCtx.type();
        UnresolvedTypeNode unresolvedTypeNode = supertypeCtx != null ? this.visitType(supertypeCtx) : (supertypeNode = this.isBaseModule && className == Identifier.ANY ? null : new UnresolvedTypeNode.Declared(VmUtils.unavailableSourceSection(), this.resolveBaseModuleClass(Identifier.TYPED, BaseModule::getTypedClass)));
        if (!(supertypeNode == null || supertypeNode instanceof UnresolvedTypeNode.Declared || supertypeNode instanceof UnresolvedTypeNode.Parameterized || supertypeNode instanceof UnresolvedTypeNode.Module)) {
            throw this.exceptionBuilder().evalError("invalidSupertype", supertypeNode.getSourceSection().getCharacters()).withSourceSection(supertypeNode.getSourceSection()).build();
        }
        PClassInfo<?> classInfo = PClassInfo.get(this.moduleInfo.getModuleName(), className.toString(), this.moduleInfo.getModuleKey().getUri());
        HashSet<String> propertyNames = CollectionUtils.newHashSet(propertyCtxs.size());
        ClassNode classNode = new ClassNode(sourceSection, headerSection, this.createSourceSection(ctx.t), this.doVisitAnnotations(ctx.annotation()), modifiers, classInfo, typeParameters, null, supertypeNode, EconomicMaps.create(), this.doVisitClassProperties(propertyCtxs, propertyNames), this.doVisitMethodDefs(methodCtxs));
        boolean isLocal = VmModifier.isLocal(modifiers);
        ObjectMember result = new ObjectMember(sourceSection, headerSection, isLocal ? 324 : 320, scope.getName(), scope.getQualifiedName());
        result.initMemberNode(new UntypedObjectMemberNode(this.language, scope.buildFrameDescriptor(), result, (ExpressionNode)classNode));
        return result;
    }
}

