/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.pkl.core.PClassInfo;
import org.pkl.core.Value;
import org.pkl.core.ValueConverter;
import org.pkl.core.ValueVisitor;
import org.pkl.core.util.Nullable;

public final class Pair<F, S>
implements Value,
Iterable<Object> {
    private static final long serialVersionUID = 0L;
    private final F first;
    private final S second;

    public Pair(F first2, S second2) {
        this.first = first2;
        this.second = second2;
    }

    public F getFirst() {
        return this.first;
    }

    public S getSecond() {
        return this.second;
    }

    @Override
    public Iterator<Object> iterator() {
        return new Iterator<Object>(){
            int pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < 2;
            }

            @Override
            public Object next() {
                switch (this.pos++) {
                    case 0: {
                        return Pair.this.first;
                    }
                    case 1: {
                        return Pair.this.second;
                    }
                }
                throw new NoSuchElementException("Pair only has two elements.");
            }
        };
    }

    @Override
    public void accept(ValueVisitor visitor) {
        visitor.visitPair(this);
    }

    @Override
    public <T> T accept(ValueConverter<T> converter) {
        return converter.convertPair(this);
    }

    @Override
    public PClassInfo<?> getClassInfo() {
        return PClassInfo.Pair;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)obj;
        return this.first.equals(other.first) && this.second.equals(other.second);
    }

    public int hashCode() {
        return this.first.hashCode() * 31 + this.second.hashCode();
    }

    public String toString() {
        return "Pair(" + this.first + ", " + this.second + ")";
    }
}

